/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BuildBotLocaleResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, BuildBotLocaleResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(BuildBotLocaleResponse.getter(BuildBotLocaleResponse::botId)).setter(BuildBotLocaleResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(BuildBotLocaleResponse.getter(BuildBotLocaleResponse::botVersion)).setter(BuildBotLocaleResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(BuildBotLocaleResponse.getter(BuildBotLocaleResponse::localeId)).setter(BuildBotLocaleResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botLocaleStatus").getter(BuildBotLocaleResponse.getter(BuildBotLocaleResponse::botLocaleStatusAsString)).setter(BuildBotLocaleResponse.setter(Builder::botLocaleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()}).build();
    private static final SdkField<Instant> LAST_BUILD_SUBMITTED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastBuildSubmittedDateTime").getter(BuildBotLocaleResponse.getter(BuildBotLocaleResponse::lastBuildSubmittedDateTime)).setter(BuildBotLocaleResponse.setter(Builder::lastBuildSubmittedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastBuildSubmittedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_LOCALE_STATUS_FIELD, LAST_BUILD_SUBMITTED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botId", BOT_ID_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("localeId", LOCALE_ID_FIELD);
            this.put("botLocaleStatus", BOT_LOCALE_STATUS_FIELD);
            this.put("lastBuildSubmittedDateTime", LAST_BUILD_SUBMITTED_DATE_TIME_FIELD);
        }
    });
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String botLocaleStatus;
    private final Instant lastBuildSubmittedDateTime;

    private BuildBotLocaleResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botLocaleStatus = builder.botLocaleStatus;
        this.lastBuildSubmittedDateTime = builder.lastBuildSubmittedDateTime;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(this.botLocaleStatus);
    }

    public final String botLocaleStatusAsString() {
        return this.botLocaleStatus;
    }

    public final Instant lastBuildSubmittedDateTime() {
        return this.lastBuildSubmittedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botLocaleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastBuildSubmittedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BuildBotLocaleResponse)) {
            return false;
        }
        BuildBotLocaleResponse other = (BuildBotLocaleResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.botLocaleStatusAsString(), other.botLocaleStatusAsString()) && Objects.equals(this.lastBuildSubmittedDateTime(), other.lastBuildSubmittedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"BuildBotLocaleResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("BotLocaleStatus", (Object)this.botLocaleStatusAsString()).add("LastBuildSubmittedDateTime", (Object)this.lastBuildSubmittedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "botLocaleStatus": {
                return Optional.ofNullable(clazz.cast(this.botLocaleStatusAsString()));
            }
            case "lastBuildSubmittedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastBuildSubmittedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BuildBotLocaleResponse, T> g) {
        return obj -> g.apply((BuildBotLocaleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String botLocaleStatus;
        private Instant lastBuildSubmittedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BuildBotLocaleResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.botLocaleStatus(model.botLocaleStatus);
            this.lastBuildSubmittedDateTime(model.lastBuildSubmittedDateTime);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getBotLocaleStatus() {
            return this.botLocaleStatus;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        @Override
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        public final Instant getLastBuildSubmittedDateTime() {
            return this.lastBuildSubmittedDateTime;
        }

        public final void setLastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
        }

        @Override
        public final Builder lastBuildSubmittedDateTime(Instant lastBuildSubmittedDateTime) {
            this.lastBuildSubmittedDateTime = lastBuildSubmittedDateTime;
            return this;
        }

        @Override
        public BuildBotLocaleResponse build() {
            return new BuildBotLocaleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BuildBotLocaleResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder botLocaleStatus(String var1);

        public Builder botLocaleStatus(BotLocaleStatus var1);

        public Builder lastBuildSubmittedDateTime(Instant var1);
    }
}

