/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.BotLocaleSummaryListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListBotLocalesResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListBotLocalesResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListBotLocalesResponse.getter(ListBotLocalesResponse::botId)).setter(ListBotLocalesResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(ListBotLocalesResponse.getter(ListBotLocalesResponse::botVersion)).setter(ListBotLocalesResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListBotLocalesResponse.getter(ListBotLocalesResponse::nextToken)).setter(ListBotLocalesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<BotLocaleSummary>> BOT_LOCALE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("botLocaleSummaries").getter(ListBotLocalesResponse.getter(ListBotLocalesResponse::botLocaleSummaries)).setter(ListBotLocalesResponse.setter(Builder::botLocaleSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BotLocaleSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, NEXT_TOKEN_FIELD, BOT_LOCALE_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botId", BOT_ID_FIELD);
            this.put("botVersion", BOT_VERSION_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("botLocaleSummaries", BOT_LOCALE_SUMMARIES_FIELD);
        }
    });
    private final String botId;
    private final String botVersion;
    private final String nextToken;
    private final List<BotLocaleSummary> botLocaleSummaries;

    private ListBotLocalesResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.nextToken = builder.nextToken;
        this.botLocaleSummaries = builder.botLocaleSummaries;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasBotLocaleSummaries() {
        return this.botLocaleSummaries != null && !(this.botLocaleSummaries instanceof SdkAutoConstructList);
    }

    public final List<BotLocaleSummary> botLocaleSummaries() {
        return this.botLocaleSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBotLocaleSummaries() ? this.botLocaleSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotLocalesResponse)) {
            return false;
        }
        ListBotLocalesResponse other = (ListBotLocalesResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasBotLocaleSummaries() == other.hasBotLocaleSummaries() && Objects.equals(this.botLocaleSummaries(), other.botLocaleSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListBotLocalesResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("NextToken", (Object)this.nextToken()).add("BotLocaleSummaries", this.hasBotLocaleSummaries() ? this.botLocaleSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "botLocaleSummaries": {
                return Optional.ofNullable(clazz.cast(this.botLocaleSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListBotLocalesResponse, T> g) {
        return obj -> g.apply((ListBotLocalesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String nextToken;
        private List<BotLocaleSummary> botLocaleSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotLocalesResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.nextToken(model.nextToken);
            this.botLocaleSummaries(model.botLocaleSummaries);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<BotLocaleSummary.Builder> getBotLocaleSummaries() {
            List<BotLocaleSummary.Builder> result = BotLocaleSummaryListCopier.copyToBuilder(this.botLocaleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotLocaleSummaries(Collection<BotLocaleSummary.BuilderImpl> botLocaleSummaries) {
            this.botLocaleSummaries = BotLocaleSummaryListCopier.copyFromBuilder(botLocaleSummaries);
        }

        @Override
        public final Builder botLocaleSummaries(Collection<BotLocaleSummary> botLocaleSummaries) {
            this.botLocaleSummaries = BotLocaleSummaryListCopier.copy(botLocaleSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botLocaleSummaries(BotLocaleSummary ... botLocaleSummaries) {
            this.botLocaleSummaries(Arrays.asList(botLocaleSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botLocaleSummaries(Consumer<BotLocaleSummary.Builder> ... botLocaleSummaries) {
            this.botLocaleSummaries(Stream.of(botLocaleSummaries).map(c -> (BotLocaleSummary)((BotLocaleSummary.Builder)BotLocaleSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListBotLocalesResponse build() {
            return new ListBotLocalesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListBotLocalesResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder nextToken(String var1);

        public Builder botLocaleSummaries(Collection<BotLocaleSummary> var1);

        public Builder botLocaleSummaries(BotLocaleSummary ... var1);

        public Builder botLocaleSummaries(Consumer<BotLocaleSummary.Builder> ... var1);
    }
}

