/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinByListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinBySpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionFilter;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionFiltersCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupByListCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionGroupBySpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetric;
import software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsSessionMetricsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Request;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSessionMetricsRequest
extends LexModelsV2Request
implements ToCopyableBuilder<Builder, ListSessionMetricsRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::botId)).setter(ListSessionMetricsRequest.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()}).build();
    private static final SdkField<Instant> START_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDateTime").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::startDateTime)).setter(ListSessionMetricsRequest.setter(Builder::startDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startDateTime").build()}).build();
    private static final SdkField<Instant> END_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDateTime").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::endDateTime)).setter(ListSessionMetricsRequest.setter(Builder::endDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endDateTime").build()}).build();
    private static final SdkField<List<AnalyticsSessionMetric>> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("metrics").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::metrics)).setter(ListSessionMetricsRequest.setter(Builder::metrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metrics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsSessionMetric::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsBinBySpecification>> BIN_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("binBy").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::binBy)).setter(ListSessionMetricsRequest.setter(Builder::binBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsBinBySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsSessionGroupBySpecification>> GROUP_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("groupBy").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::groupBy)).setter(ListSessionMetricsRequest.setter(Builder::groupBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsSessionGroupBySpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AnalyticsSessionFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::filters)).setter(ListSessionMetricsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyticsSessionFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::maxResults)).setter(ListSessionMetricsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSessionMetricsRequest.getter(ListSessionMetricsRequest::nextToken)).setter(ListSessionMetricsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, START_DATE_TIME_FIELD, END_DATE_TIME_FIELD, METRICS_FIELD, BIN_BY_FIELD, GROUP_BY_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("botId", BOT_ID_FIELD);
            this.put("startDateTime", START_DATE_TIME_FIELD);
            this.put("endDateTime", END_DATE_TIME_FIELD);
            this.put("metrics", METRICS_FIELD);
            this.put("binBy", BIN_BY_FIELD);
            this.put("groupBy", GROUP_BY_FIELD);
            this.put("filters", FILTERS_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String botId;
    private final Instant startDateTime;
    private final Instant endDateTime;
    private final List<AnalyticsSessionMetric> metrics;
    private final List<AnalyticsBinBySpecification> binBy;
    private final List<AnalyticsSessionGroupBySpecification> groupBy;
    private final List<AnalyticsSessionFilter> filters;
    private final Integer maxResults;
    private final String nextToken;

    private ListSessionMetricsRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.startDateTime = builder.startDateTime;
        this.endDateTime = builder.endDateTime;
        this.metrics = builder.metrics;
        this.binBy = builder.binBy;
        this.groupBy = builder.groupBy;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String botId() {
        return this.botId;
    }

    public final Instant startDateTime() {
        return this.startDateTime;
    }

    public final Instant endDateTime() {
        return this.endDateTime;
    }

    public final boolean hasMetrics() {
        return this.metrics != null && !(this.metrics instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsSessionMetric> metrics() {
        return this.metrics;
    }

    public final boolean hasBinBy() {
        return this.binBy != null && !(this.binBy instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsBinBySpecification> binBy() {
        return this.binBy;
    }

    public final boolean hasGroupBy() {
        return this.groupBy != null && !(this.groupBy instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsSessionGroupBySpecification> groupBy() {
        return this.groupBy;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<AnalyticsSessionFilter> filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetrics() ? this.metrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBinBy() ? this.binBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupBy() ? this.groupBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionMetricsRequest)) {
            return false;
        }
        ListSessionMetricsRequest other = (ListSessionMetricsRequest)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime()) && this.hasMetrics() == other.hasMetrics() && Objects.equals(this.metrics(), other.metrics()) && this.hasBinBy() == other.hasBinBy() && Objects.equals(this.binBy(), other.binBy()) && this.hasGroupBy() == other.hasGroupBy() && Objects.equals(this.groupBy(), other.groupBy()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSessionMetricsRequest").add("BotId", (Object)this.botId()).add("StartDateTime", (Object)this.startDateTime()).add("EndDateTime", (Object)this.endDateTime()).add("Metrics", this.hasMetrics() ? this.metrics() : null).add("BinBy", this.hasBinBy() ? this.binBy() : null).add("GroupBy", this.hasGroupBy() ? this.groupBy() : null).add("Filters", this.hasFilters() ? this.filters() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "startDateTime": {
                return Optional.ofNullable(clazz.cast(this.startDateTime()));
            }
            case "endDateTime": {
                return Optional.ofNullable(clazz.cast(this.endDateTime()));
            }
            case "metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "binBy": {
                return Optional.ofNullable(clazz.cast(this.binBy()));
            }
            case "groupBy": {
                return Optional.ofNullable(clazz.cast(this.groupBy()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListSessionMetricsRequest, T> g) {
        return obj -> g.apply((ListSessionMetricsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Request.BuilderImpl
    implements Builder {
        private String botId;
        private Instant startDateTime;
        private Instant endDateTime;
        private List<AnalyticsSessionMetric> metrics = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsBinBySpecification> binBy = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsSessionGroupBySpecification> groupBy = DefaultSdkAutoConstructList.getInstance();
        private List<AnalyticsSessionFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionMetricsRequest model) {
            super(model);
            this.botId(model.botId);
            this.startDateTime(model.startDateTime);
            this.endDateTime(model.endDateTime);
            this.metrics(model.metrics);
            this.binBy(model.binBy);
            this.groupBy(model.groupBy);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final List<AnalyticsSessionMetric.Builder> getMetrics() {
            List<AnalyticsSessionMetric.Builder> result = AnalyticsSessionMetricsCopier.copyToBuilder(this.metrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetrics(Collection<AnalyticsSessionMetric.BuilderImpl> metrics) {
            this.metrics = AnalyticsSessionMetricsCopier.copyFromBuilder(metrics);
        }

        @Override
        public final Builder metrics(Collection<AnalyticsSessionMetric> metrics) {
            this.metrics = AnalyticsSessionMetricsCopier.copy(metrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(AnalyticsSessionMetric ... metrics) {
            this.metrics(Arrays.asList(metrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metrics(Consumer<AnalyticsSessionMetric.Builder> ... metrics) {
            this.metrics(Stream.of(metrics).map(c -> (AnalyticsSessionMetric)((AnalyticsSessionMetric.Builder)AnalyticsSessionMetric.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsBinBySpecification.Builder> getBinBy() {
            List<AnalyticsBinBySpecification.Builder> result = AnalyticsBinByListCopier.copyToBuilder(this.binBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinBy(Collection<AnalyticsBinBySpecification.BuilderImpl> binBy) {
            this.binBy = AnalyticsBinByListCopier.copyFromBuilder(binBy);
        }

        @Override
        public final Builder binBy(Collection<AnalyticsBinBySpecification> binBy) {
            this.binBy = AnalyticsBinByListCopier.copy(binBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binBy(AnalyticsBinBySpecification ... binBy) {
            this.binBy(Arrays.asList(binBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binBy(Consumer<AnalyticsBinBySpecification.Builder> ... binBy) {
            this.binBy(Stream.of(binBy).map(c -> (AnalyticsBinBySpecification)((AnalyticsBinBySpecification.Builder)AnalyticsBinBySpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsSessionGroupBySpecification.Builder> getGroupBy() {
            List<AnalyticsSessionGroupBySpecification.Builder> result = AnalyticsSessionGroupByListCopier.copyToBuilder(this.groupBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupBy(Collection<AnalyticsSessionGroupBySpecification.BuilderImpl> groupBy) {
            this.groupBy = AnalyticsSessionGroupByListCopier.copyFromBuilder(groupBy);
        }

        @Override
        public final Builder groupBy(Collection<AnalyticsSessionGroupBySpecification> groupBy) {
            this.groupBy = AnalyticsSessionGroupByListCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(AnalyticsSessionGroupBySpecification ... groupBy) {
            this.groupBy(Arrays.asList(groupBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(Consumer<AnalyticsSessionGroupBySpecification.Builder> ... groupBy) {
            this.groupBy(Stream.of(groupBy).map(c -> (AnalyticsSessionGroupBySpecification)((AnalyticsSessionGroupBySpecification.Builder)AnalyticsSessionGroupBySpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsSessionFilter.Builder> getFilters() {
            List<AnalyticsSessionFilter.Builder> result = AnalyticsSessionFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AnalyticsSessionFilter.BuilderImpl> filters) {
            this.filters = AnalyticsSessionFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<AnalyticsSessionFilter> filters) {
            this.filters = AnalyticsSessionFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(AnalyticsSessionFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<AnalyticsSessionFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (AnalyticsSessionFilter)((AnalyticsSessionFilter.Builder)AnalyticsSessionFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSessionMetricsRequest build() {
            return new ListSessionMetricsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSessionMetricsRequest> {
        public Builder botId(String var1);

        public Builder startDateTime(Instant var1);

        public Builder endDateTime(Instant var1);

        public Builder metrics(Collection<AnalyticsSessionMetric> var1);

        public Builder metrics(AnalyticsSessionMetric ... var1);

        public Builder metrics(Consumer<AnalyticsSessionMetric.Builder> ... var1);

        public Builder binBy(Collection<AnalyticsBinBySpecification> var1);

        public Builder binBy(AnalyticsBinBySpecification ... var1);

        public Builder binBy(Consumer<AnalyticsBinBySpecification.Builder> ... var1);

        public Builder groupBy(Collection<AnalyticsSessionGroupBySpecification> var1);

        public Builder groupBy(AnalyticsSessionGroupBySpecification ... var1);

        public Builder groupBy(Consumer<AnalyticsSessionGroupBySpecification.Builder> ... var1);

        public Builder filters(Collection<AnalyticsSessionFilter> var1);

        public Builder filters(AnalyticsSessionFilter ... var1);

        public Builder filters(Consumer<AnalyticsSessionFilter.Builder> ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

