/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSummary;
import software.amazon.awssdk.services.lexmodelsv2.model.TestExecutionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestExecutionsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListTestExecutionsResponse> {
    private static final SdkField<List<TestExecutionSummary>> TEST_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testExecutions").getter(ListTestExecutionsResponse.getter(ListTestExecutionsResponse::testExecutions)).setter(ListTestExecutionsResponse.setter(Builder::testExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestExecutionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestExecutionsResponse.getter(ListTestExecutionsResponse::nextToken)).setter(ListTestExecutionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("testExecutions", TEST_EXECUTIONS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<TestExecutionSummary> testExecutions;
    private final String nextToken;

    private ListTestExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.testExecutions = builder.testExecutions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestExecutions() {
        return this.testExecutions != null && !(this.testExecutions instanceof SdkAutoConstructList);
    }

    public final List<TestExecutionSummary> testExecutions() {
        return this.testExecutions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestExecutions() ? this.testExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestExecutionsResponse)) {
            return false;
        }
        ListTestExecutionsResponse other = (ListTestExecutionsResponse)((Object)obj);
        return this.hasTestExecutions() == other.hasTestExecutions() && Objects.equals(this.testExecutions(), other.testExecutions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestExecutionsResponse").add("TestExecutions", this.hasTestExecutions() ? this.testExecutions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testExecutions": {
                return Optional.ofNullable(clazz.cast(this.testExecutions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTestExecutionsResponse, T> g) {
        return obj -> g.apply((ListTestExecutionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private List<TestExecutionSummary> testExecutions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestExecutionsResponse model) {
            super(model);
            this.testExecutions(model.testExecutions);
            this.nextToken(model.nextToken);
        }

        public final List<TestExecutionSummary.Builder> getTestExecutions() {
            List<TestExecutionSummary.Builder> result = TestExecutionSummaryListCopier.copyToBuilder(this.testExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestExecutions(Collection<TestExecutionSummary.BuilderImpl> testExecutions) {
            this.testExecutions = TestExecutionSummaryListCopier.copyFromBuilder(testExecutions);
        }

        @Override
        public final Builder testExecutions(Collection<TestExecutionSummary> testExecutions) {
            this.testExecutions = TestExecutionSummaryListCopier.copy(testExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testExecutions(TestExecutionSummary ... testExecutions) {
            this.testExecutions(Arrays.asList(testExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testExecutions(Consumer<TestExecutionSummary.Builder> ... testExecutions) {
            this.testExecutions(Stream.of(testExecutions).map(c -> (TestExecutionSummary)((TestExecutionSummary.Builder)TestExecutionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestExecutionsResponse build() {
            return new ListTestExecutionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestExecutionsResponse> {
        public Builder testExecutions(Collection<TestExecutionSummary> var1);

        public Builder testExecutions(TestExecutionSummary ... var1);

        public Builder testExecutions(Consumer<TestExecutionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

