/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.lexmodelsv2.model.InputSessionStateSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.StringMapCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.UtteranceInputSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserTurnInputSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserTurnInputSpecification> {
    private static final SdkField<UtteranceInputSpecification> UTTERANCE_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("utteranceInput").getter(UserTurnInputSpecification.getter(UserTurnInputSpecification::utteranceInput)).setter(UserTurnInputSpecification.setter(Builder::utteranceInput)).constructor(UtteranceInputSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utteranceInput").build()}).build();
    private static final SdkField<Map<String, String>> REQUEST_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("requestAttributes").getter(UserTurnInputSpecification.getter(UserTurnInputSpecification::requestAttributes)).setter(UserTurnInputSpecification.setter(Builder::requestAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<InputSessionStateSpecification> SESSION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sessionState").getter(UserTurnInputSpecification.getter(UserTurnInputSpecification::sessionState)).setter(UserTurnInputSpecification.setter(Builder::sessionState)).constructor(InputSessionStateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UTTERANCE_INPUT_FIELD, REQUEST_ATTRIBUTES_FIELD, SESSION_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("utteranceInput", UTTERANCE_INPUT_FIELD);
            this.put("requestAttributes", REQUEST_ATTRIBUTES_FIELD);
            this.put("sessionState", SESSION_STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final UtteranceInputSpecification utteranceInput;
    private final Map<String, String> requestAttributes;
    private final InputSessionStateSpecification sessionState;

    private UserTurnInputSpecification(BuilderImpl builder) {
        this.utteranceInput = builder.utteranceInput;
        this.requestAttributes = builder.requestAttributes;
        this.sessionState = builder.sessionState;
    }

    public final UtteranceInputSpecification utteranceInput() {
        return this.utteranceInput;
    }

    public final boolean hasRequestAttributes() {
        return this.requestAttributes != null && !(this.requestAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> requestAttributes() {
        return this.requestAttributes;
    }

    public final InputSessionStateSpecification sessionState() {
        return this.sessionState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.utteranceInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequestAttributes() ? this.requestAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionState());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserTurnInputSpecification)) {
            return false;
        }
        UserTurnInputSpecification other = (UserTurnInputSpecification)obj;
        return Objects.equals(this.utteranceInput(), other.utteranceInput()) && this.hasRequestAttributes() == other.hasRequestAttributes() && Objects.equals(this.requestAttributes(), other.requestAttributes()) && Objects.equals(this.sessionState(), other.sessionState());
    }

    public final String toString() {
        return ToString.builder((String)"UserTurnInputSpecification").add("UtteranceInput", (Object)this.utteranceInput()).add("RequestAttributes", this.hasRequestAttributes() ? this.requestAttributes() : null).add("SessionState", (Object)this.sessionState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "utteranceInput": {
                return Optional.ofNullable(clazz.cast(this.utteranceInput()));
            }
            case "requestAttributes": {
                return Optional.ofNullable(clazz.cast(this.requestAttributes()));
            }
            case "sessionState": {
                return Optional.ofNullable(clazz.cast(this.sessionState()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UserTurnInputSpecification, T> g) {
        return obj -> g.apply((UserTurnInputSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private UtteranceInputSpecification utteranceInput;
        private Map<String, String> requestAttributes = DefaultSdkAutoConstructMap.getInstance();
        private InputSessionStateSpecification sessionState;

        private BuilderImpl() {
        }

        private BuilderImpl(UserTurnInputSpecification model) {
            this.utteranceInput(model.utteranceInput);
            this.requestAttributes(model.requestAttributes);
            this.sessionState(model.sessionState);
        }

        public final UtteranceInputSpecification.Builder getUtteranceInput() {
            return this.utteranceInput != null ? this.utteranceInput.toBuilder() : null;
        }

        public final void setUtteranceInput(UtteranceInputSpecification.BuilderImpl utteranceInput) {
            this.utteranceInput = utteranceInput != null ? utteranceInput.build() : null;
        }

        @Override
        public final Builder utteranceInput(UtteranceInputSpecification utteranceInput) {
            this.utteranceInput = utteranceInput;
            return this;
        }

        public final Map<String, String> getRequestAttributes() {
            if (this.requestAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.requestAttributes;
        }

        public final void setRequestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
        }

        @Override
        public final Builder requestAttributes(Map<String, String> requestAttributes) {
            this.requestAttributes = StringMapCopier.copy(requestAttributes);
            return this;
        }

        public final InputSessionStateSpecification.Builder getSessionState() {
            return this.sessionState != null ? this.sessionState.toBuilder() : null;
        }

        public final void setSessionState(InputSessionStateSpecification.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(InputSessionStateSpecification sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public UserTurnInputSpecification build() {
            return new UserTurnInputSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserTurnInputSpecification> {
        public Builder utteranceInput(UtteranceInputSpecification var1);

        default public Builder utteranceInput(Consumer<UtteranceInputSpecification.Builder> utteranceInput) {
            return this.utteranceInput((UtteranceInputSpecification)((UtteranceInputSpecification.Builder)UtteranceInputSpecification.builder().applyMutation(utteranceInput)).build());
        }

        public Builder requestAttributes(Map<String, String> var1);

        public Builder sessionState(InputSessionStateSpecification var1);

        default public Builder sessionState(Consumer<InputSessionStateSpecification.Builder> sessionState) {
            return this.sessionState((InputSessionStateSpecification)((InputSessionStateSpecification.Builder)InputSessionStateSpecification.builder().applyMutation(sessionState)).build());
        }
    }
}

