/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.FailureReasonsCopier;
import software.amazon.awssdk.services.lexmodelsv2.model.GenerationStatus;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeBotResourceGenerationResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, DescribeBotResourceGenerationResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::botId)).setter(DescribeBotResourceGenerationResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botVersion").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::botVersion)).setter(DescribeBotResourceGenerationResponse.setter(Builder::botVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()}).build();
    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("localeId").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::localeId)).setter(DescribeBotResourceGenerationResponse.setter(Builder::localeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()}).build();
    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationId").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::generationId)).setter(DescribeBotResourceGenerationResponse.setter(Builder::generationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()}).build();
    private static final SdkField<List<String>> FAILURE_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failureReasons").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::failureReasons)).setter(DescribeBotResourceGenerationResponse.setter(Builder::failureReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationStatus").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::generationStatusAsString)).setter(DescribeBotResourceGenerationResponse.setter(Builder::generationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationStatus").build()}).build();
    private static final SdkField<String> GENERATION_INPUT_PROMPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generationInputPrompt").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::generationInputPrompt)).setter(DescribeBotResourceGenerationResponse.setter(Builder::generationInputPrompt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationInputPrompt").build()}).build();
    private static final SdkField<String> GENERATED_BOT_LOCALE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generatedBotLocaleUrl").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::generatedBotLocaleUrl)).setter(DescribeBotResourceGenerationResponse.setter(Builder::generatedBotLocaleUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedBotLocaleUrl").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationDateTime").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::creationDateTime)).setter(DescribeBotResourceGenerationResponse.setter(Builder::creationDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::modelArn)).setter(DescribeBotResourceGenerationResponse.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDateTime").getter(DescribeBotResourceGenerationResponse.getter(DescribeBotResourceGenerationResponse::lastUpdatedDateTime)).setter(DescribeBotResourceGenerationResponse.setter(Builder::lastUpdatedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD, GENERATION_ID_FIELD, FAILURE_REASONS_FIELD, GENERATION_STATUS_FIELD, GENERATION_INPUT_PROMPT_FIELD, GENERATED_BOT_LOCALE_URL_FIELD, CREATION_DATE_TIME_FIELD, MODEL_ARN_FIELD, LAST_UPDATED_DATE_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeBotResourceGenerationResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String botVersion;
    private final String localeId;
    private final String generationId;
    private final List<String> failureReasons;
    private final String generationStatus;
    private final String generationInputPrompt;
    private final String generatedBotLocaleUrl;
    private final Instant creationDateTime;
    private final String modelArn;
    private final Instant lastUpdatedDateTime;

    private DescribeBotResourceGenerationResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.generationId = builder.generationId;
        this.failureReasons = builder.failureReasons;
        this.generationStatus = builder.generationStatus;
        this.generationInputPrompt = builder.generationInputPrompt;
        this.generatedBotLocaleUrl = builder.generatedBotLocaleUrl;
        this.creationDateTime = builder.creationDateTime;
        this.modelArn = builder.modelArn;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    public final String botId() {
        return this.botId;
    }

    public final String botVersion() {
        return this.botVersion;
    }

    public final String localeId() {
        return this.localeId;
    }

    public final String generationId() {
        return this.generationId;
    }

    public final boolean hasFailureReasons() {
        return this.failureReasons != null && !(this.failureReasons instanceof SdkAutoConstructList);
    }

    public final List<String> failureReasons() {
        return this.failureReasons;
    }

    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(this.generationStatus);
    }

    public final String generationStatusAsString() {
        return this.generationStatus;
    }

    public final String generationInputPrompt() {
        return this.generationInputPrompt;
    }

    public final String generatedBotLocaleUrl() {
        return this.generatedBotLocaleUrl;
    }

    public final Instant creationDateTime() {
        return this.creationDateTime;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Instant lastUpdatedDateTime() {
        return this.lastUpdatedDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.localeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailureReasons() ? this.failureReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationInputPrompt());
        hashCode = 31 * hashCode + Objects.hashCode(this.generatedBotLocaleUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeBotResourceGenerationResponse)) {
            return false;
        }
        DescribeBotResourceGenerationResponse other = (DescribeBotResourceGenerationResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.botVersion(), other.botVersion()) && Objects.equals(this.localeId(), other.localeId()) && Objects.equals(this.generationId(), other.generationId()) && this.hasFailureReasons() == other.hasFailureReasons() && Objects.equals(this.failureReasons(), other.failureReasons()) && Objects.equals(this.generationStatusAsString(), other.generationStatusAsString()) && Objects.equals(this.generationInputPrompt(), other.generationInputPrompt()) && Objects.equals(this.generatedBotLocaleUrl(), other.generatedBotLocaleUrl()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeBotResourceGenerationResponse").add("BotId", (Object)this.botId()).add("BotVersion", (Object)this.botVersion()).add("LocaleId", (Object)this.localeId()).add("GenerationId", (Object)this.generationId()).add("FailureReasons", this.hasFailureReasons() ? this.failureReasons() : null).add("GenerationStatus", (Object)this.generationStatusAsString()).add("GenerationInputPrompt", (Object)this.generationInputPrompt()).add("GeneratedBotLocaleUrl", (Object)this.generatedBotLocaleUrl()).add("CreationDateTime", (Object)this.creationDateTime()).add("ModelArn", (Object)this.modelArn()).add("LastUpdatedDateTime", (Object)this.lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "botVersion": {
                return Optional.ofNullable(clazz.cast(this.botVersion()));
            }
            case "localeId": {
                return Optional.ofNullable(clazz.cast(this.localeId()));
            }
            case "generationId": {
                return Optional.ofNullable(clazz.cast(this.generationId()));
            }
            case "failureReasons": {
                return Optional.ofNullable(clazz.cast(this.failureReasons()));
            }
            case "generationStatus": {
                return Optional.ofNullable(clazz.cast(this.generationStatusAsString()));
            }
            case "generationInputPrompt": {
                return Optional.ofNullable(clazz.cast(this.generationInputPrompt()));
            }
            case "generatedBotLocaleUrl": {
                return Optional.ofNullable(clazz.cast(this.generatedBotLocaleUrl()));
            }
            case "creationDateTime": {
                return Optional.ofNullable(clazz.cast(this.creationDateTime()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "lastUpdatedDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("generationId", GENERATION_ID_FIELD);
        map.put("failureReasons", FAILURE_REASONS_FIELD);
        map.put("generationStatus", GENERATION_STATUS_FIELD);
        map.put("generationInputPrompt", GENERATION_INPUT_PROMPT_FIELD);
        map.put("generatedBotLocaleUrl", GENERATED_BOT_LOCALE_URL_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeBotResourceGenerationResponse, T> g) {
        return obj -> g.apply((DescribeBotResourceGenerationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String botVersion;
        private String localeId;
        private String generationId;
        private List<String> failureReasons = DefaultSdkAutoConstructList.getInstance();
        private String generationStatus;
        private String generationInputPrompt;
        private String generatedBotLocaleUrl;
        private Instant creationDateTime;
        private String modelArn;
        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeBotResourceGenerationResponse model) {
            super(model);
            this.botId(model.botId);
            this.botVersion(model.botVersion);
            this.localeId(model.localeId);
            this.generationId(model.generationId);
            this.failureReasons(model.failureReasons);
            this.generationStatus(model.generationStatus);
            this.generationInputPrompt(model.generationInputPrompt);
            this.generatedBotLocaleUrl(model.generatedBotLocaleUrl);
            this.creationDateTime(model.creationDateTime);
            this.modelArn(model.modelArn);
            this.lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return this.botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return this.localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getGenerationId() {
            return this.generationId;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final Collection<String> getFailureReasons() {
            if (this.failureReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.failureReasons;
        }

        public final void setFailureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
        }

        @Override
        public final Builder failureReasons(Collection<String> failureReasons) {
            this.failureReasons = FailureReasonsCopier.copy(failureReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReasons(String ... failureReasons) {
            this.failureReasons(Arrays.asList(failureReasons));
            return this;
        }

        public final String getGenerationStatus() {
            return this.generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final String getGenerationInputPrompt() {
            return this.generationInputPrompt;
        }

        public final void setGenerationInputPrompt(String generationInputPrompt) {
            this.generationInputPrompt = generationInputPrompt;
        }

        @Override
        public final Builder generationInputPrompt(String generationInputPrompt) {
            this.generationInputPrompt = generationInputPrompt;
            return this;
        }

        public final String getGeneratedBotLocaleUrl() {
            return this.generatedBotLocaleUrl;
        }

        public final void setGeneratedBotLocaleUrl(String generatedBotLocaleUrl) {
            this.generatedBotLocaleUrl = generatedBotLocaleUrl;
        }

        @Override
        public final Builder generatedBotLocaleUrl(String generatedBotLocaleUrl) {
            this.generatedBotLocaleUrl = generatedBotLocaleUrl;
            return this;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return this.lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public DescribeBotResourceGenerationResponse build() {
            return new DescribeBotResourceGenerationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeBotResourceGenerationResponse> {
        public Builder botId(String var1);

        public Builder botVersion(String var1);

        public Builder localeId(String var1);

        public Builder generationId(String var1);

        public Builder failureReasons(Collection<String> var1);

        public Builder failureReasons(String ... var1);

        public Builder generationStatus(String var1);

        public Builder generationStatus(GenerationStatus var1);

        public Builder generationInputPrompt(String var1);

        public Builder generatedBotLocaleUrl(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder modelArn(String var1);

        public Builder lastUpdatedDateTime(Instant var1);
    }
}

