/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListSlotsResponse;

public class ListSlotsPublisher
implements SdkPublisher<ListSlotsResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListSlotsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSlotsPublisher(LexModelsV2AsyncClient client, ListSlotsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSlotsPublisher(LexModelsV2AsyncClient client, ListSlotsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSlotsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSlotsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListSlotsResponseFetcher
    implements AsyncPageFetcher<ListSlotsResponse> {
        private ListSlotsResponseFetcher() {
        }

        public boolean hasNextPage(ListSlotsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSlotsResponse> nextPage(ListSlotsResponse previousPage) {
            if (previousPage == null) {
                return ListSlotsPublisher.this.client.listSlots(ListSlotsPublisher.this.firstRequest);
            }
            return ListSlotsPublisher.this.client.listSlots((ListSlotsRequest)((Object)ListSlotsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

