/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2Client;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListUtteranceMetricsResponse;

public class ListUtteranceMetricsIterable
implements SdkIterable<ListUtteranceMetricsResponse> {
    private final LexModelsV2Client client;
    private final ListUtteranceMetricsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListUtteranceMetricsIterable(LexModelsV2Client client, ListUtteranceMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListUtteranceMetricsResponseFetcher();
    }

    public Iterator<ListUtteranceMetricsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListUtteranceMetricsResponseFetcher
    implements SyncPageFetcher<ListUtteranceMetricsResponse> {
        private ListUtteranceMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListUtteranceMetricsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListUtteranceMetricsResponse nextPage(ListUtteranceMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListUtteranceMetricsIterable.this.client.listUtteranceMetrics(ListUtteranceMetricsIterable.this.firstRequest);
            }
            return ListUtteranceMetricsIterable.this.client.listUtteranceMetrics((ListUtteranceMetricsRequest)((Object)ListUtteranceMetricsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

