/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AnalyticsIntentStageResultsCopier {
    static List<AnalyticsIntentStageResult> copy(Collection<? extends AnalyticsIntentStageResult> analyticsIntentStageResultsParam) {
        List<AnalyticsIntentStageResult> list;
        if (analyticsIntentStageResultsParam == null || analyticsIntentStageResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AnalyticsIntentStageResult> modifiableList = new ArrayList<>(analyticsIntentStageResultsParam.size());
            analyticsIntentStageResultsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AnalyticsIntentStageResult> copyFromBuilder(
            Collection<? extends AnalyticsIntentStageResult.Builder> analyticsIntentStageResultsParam) {
        List<AnalyticsIntentStageResult> list;
        if (analyticsIntentStageResultsParam == null || analyticsIntentStageResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AnalyticsIntentStageResult> modifiableList = new ArrayList<>(analyticsIntentStageResultsParam.size());
            analyticsIntentStageResultsParam.forEach(entry -> {
                AnalyticsIntentStageResult member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AnalyticsIntentStageResult.Builder> copyToBuilder(
            Collection<? extends AnalyticsIntentStageResult> analyticsIntentStageResultsParam) {
        List<AnalyticsIntentStageResult.Builder> list;
        if (analyticsIntentStageResultsParam == null || analyticsIntentStageResultsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AnalyticsIntentStageResult.Builder> modifiableList = new ArrayList<>(analyticsIntentStageResultsParam.size());
            analyticsIntentStageResultsParam.forEach(entry -> {
                AnalyticsIntentStageResult.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
