/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotReplicaResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateBotReplicaResponse.Builder, CreateBotReplicaResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateBotReplicaResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> REPLICA_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicaRegion").getter(getter(CreateBotReplicaResponse::replicaRegion))
            .setter(setter(Builder::replicaRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicaRegion").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRegion").getter(getter(CreateBotReplicaResponse::sourceRegion))
            .setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateBotReplicaResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<String> BOT_REPLICA_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botReplicaStatus").getter(getter(CreateBotReplicaResponse::botReplicaStatusAsString))
            .setter(setter(Builder::botReplicaStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botReplicaStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            REPLICA_REGION_FIELD, SOURCE_REGION_FIELD, CREATION_DATE_TIME_FIELD, BOT_REPLICA_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String replicaRegion;

    private final String sourceRegion;

    private final Instant creationDateTime;

    private final String botReplicaStatus;

    private CreateBotReplicaResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.replicaRegion = builder.replicaRegion;
        this.sourceRegion = builder.sourceRegion;
        this.creationDateTime = builder.creationDateTime;
        this.botReplicaStatus = builder.botReplicaStatus;
    }

    /**
     * <p>
     * The unique bot ID of the replicated bot generated.
     * </p>
     * 
     * @return The unique bot ID of the replicated bot generated.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The region of the replicated bot generated.
     * </p>
     * 
     * @return The region of the replicated bot generated.
     */
    public final String replicaRegion() {
        return replicaRegion;
    }

    /**
     * <p>
     * The source region for the source bot used for the replicated bot generated.
     * </p>
     * 
     * @return The source region for the source bot used for the replicated bot generated.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The creation date and time of the replicated bot generated.
     * </p>
     * 
     * @return The creation date and time of the replicated bot generated.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The operational status of the replicated bot generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botReplicaStatus}
     * will return {@link BotReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botReplicaStatusAsString}.
     * </p>
     * 
     * @return The operational status of the replicated bot generated.
     * @see BotReplicaStatus
     */
    public final BotReplicaStatus botReplicaStatus() {
        return BotReplicaStatus.fromValue(botReplicaStatus);
    }

    /**
     * <p>
     * The operational status of the replicated bot generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botReplicaStatus}
     * will return {@link BotReplicaStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botReplicaStatusAsString}.
     * </p>
     * 
     * @return The operational status of the replicated bot generated.
     * @see BotReplicaStatus
     */
    public final String botReplicaStatusAsString() {
        return botReplicaStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(replicaRegion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(botReplicaStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotReplicaResponse)) {
            return false;
        }
        CreateBotReplicaResponse other = (CreateBotReplicaResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(replicaRegion(), other.replicaRegion())
                && Objects.equals(sourceRegion(), other.sourceRegion())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(botReplicaStatusAsString(), other.botReplicaStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBotReplicaResponse").add("BotId", botId()).add("ReplicaRegion", replicaRegion())
                .add("SourceRegion", sourceRegion()).add("CreationDateTime", creationDateTime())
                .add("BotReplicaStatus", botReplicaStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "replicaRegion":
            return Optional.ofNullable(clazz.cast(replicaRegion()));
        case "sourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "botReplicaStatus":
            return Optional.ofNullable(clazz.cast(botReplicaStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("replicaRegion", REPLICA_REGION_FIELD);
        map.put("sourceRegion", SOURCE_REGION_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("botReplicaStatus", BOT_REPLICA_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBotReplicaResponse, T> g) {
        return obj -> g.apply((CreateBotReplicaResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotReplicaResponse> {
        /**
         * <p>
         * The unique bot ID of the replicated bot generated.
         * </p>
         * 
         * @param botId
         *        The unique bot ID of the replicated bot generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The region of the replicated bot generated.
         * </p>
         * 
         * @param replicaRegion
         *        The region of the replicated bot generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicaRegion(String replicaRegion);

        /**
         * <p>
         * The source region for the source bot used for the replicated bot generated.
         * </p>
         * 
         * @param sourceRegion
         *        The source region for the source bot used for the replicated bot generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The creation date and time of the replicated bot generated.
         * </p>
         * 
         * @param creationDateTime
         *        The creation date and time of the replicated bot generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The operational status of the replicated bot generated.
         * </p>
         * 
         * @param botReplicaStatus
         *        The operational status of the replicated bot generated.
         * @see BotReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotReplicaStatus
         */
        Builder botReplicaStatus(String botReplicaStatus);

        /**
         * <p>
         * The operational status of the replicated bot generated.
         * </p>
         * 
         * @param botReplicaStatus
         *        The operational status of the replicated bot generated.
         * @see BotReplicaStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotReplicaStatus
         */
        Builder botReplicaStatus(BotReplicaStatus botReplicaStatus);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String replicaRegion;

        private String sourceRegion;

        private Instant creationDateTime;

        private String botReplicaStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotReplicaResponse model) {
            super(model);
            botId(model.botId);
            replicaRegion(model.replicaRegion);
            sourceRegion(model.sourceRegion);
            creationDateTime(model.creationDateTime);
            botReplicaStatus(model.botReplicaStatus);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getReplicaRegion() {
            return replicaRegion;
        }

        public final void setReplicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
        }

        @Override
        public final Builder replicaRegion(String replicaRegion) {
            this.replicaRegion = replicaRegion;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final String getBotReplicaStatus() {
            return botReplicaStatus;
        }

        public final void setBotReplicaStatus(String botReplicaStatus) {
            this.botReplicaStatus = botReplicaStatus;
        }

        @Override
        public final Builder botReplicaStatus(String botReplicaStatus) {
            this.botReplicaStatus = botReplicaStatus;
            return this;
        }

        @Override
        public final Builder botReplicaStatus(BotReplicaStatus botReplicaStatus) {
            this.botReplicaStatus(botReplicaStatus == null ? null : botReplicaStatus.toString());
            return this;
        }

        @Override
        public CreateBotReplicaResponse build() {
            return new CreateBotReplicaResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
