/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIntentRequest extends LexModelsV2Request implements
        ToCopyableBuilder<CreateIntentRequest.Builder, CreateIntentRequest> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(CreateIntentRequest::intentName)).setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateIntentRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> PARENT_INTENT_SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentIntentSignature").getter(getter(CreateIntentRequest::parentIntentSignature))
            .setter(setter(Builder::parentIntentSignature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentIntentSignature").build())
            .build();

    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<SampleUtterance>> builder(MarshallingType.LIST)
            .memberName("sampleUtterances")
            .getter(getter(CreateIntentRequest::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampleUtterance> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampleUtterance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DialogCodeHookSettings> DIALOG_CODE_HOOK_FIELD = SdkField
            .<DialogCodeHookSettings> builder(MarshallingType.SDK_POJO).memberName("dialogCodeHook")
            .getter(getter(CreateIntentRequest::dialogCodeHook)).setter(setter(Builder::dialogCodeHook))
            .constructor(DialogCodeHookSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dialogCodeHook").build()).build();

    private static final SdkField<FulfillmentCodeHookSettings> FULFILLMENT_CODE_HOOK_FIELD = SdkField
            .<FulfillmentCodeHookSettings> builder(MarshallingType.SDK_POJO).memberName("fulfillmentCodeHook")
            .getter(getter(CreateIntentRequest::fulfillmentCodeHook)).setter(setter(Builder::fulfillmentCodeHook))
            .constructor(FulfillmentCodeHookSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fulfillmentCodeHook").build())
            .build();

    private static final SdkField<IntentConfirmationSetting> INTENT_CONFIRMATION_SETTING_FIELD = SdkField
            .<IntentConfirmationSetting> builder(MarshallingType.SDK_POJO).memberName("intentConfirmationSetting")
            .getter(getter(CreateIntentRequest::intentConfirmationSetting)).setter(setter(Builder::intentConfirmationSetting))
            .constructor(IntentConfirmationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentConfirmationSetting").build())
            .build();

    private static final SdkField<IntentClosingSetting> INTENT_CLOSING_SETTING_FIELD = SdkField
            .<IntentClosingSetting> builder(MarshallingType.SDK_POJO).memberName("intentClosingSetting")
            .getter(getter(CreateIntentRequest::intentClosingSetting)).setter(setter(Builder::intentClosingSetting))
            .constructor(IntentClosingSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentClosingSetting").build())
            .build();

    private static final SdkField<List<InputContext>> INPUT_CONTEXTS_FIELD = SdkField
            .<List<InputContext>> builder(MarshallingType.LIST)
            .memberName("inputContexts")
            .getter(getter(CreateIntentRequest::inputContexts))
            .setter(setter(Builder::inputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(InputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OutputContext>> OUTPUT_CONTEXTS_FIELD = SdkField
            .<List<OutputContext>> builder(MarshallingType.LIST)
            .memberName("outputContexts")
            .getter(getter(CreateIntentRequest::outputContexts))
            .setter(setter(Builder::outputContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<KendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField
            .<KendraConfiguration> builder(MarshallingType.SDK_POJO).memberName("kendraConfiguration")
            .getter(getter(CreateIntentRequest::kendraConfiguration)).setter(setter(Builder::kendraConfiguration))
            .constructor(KendraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build())
            .build();

    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateIntentRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateIntentRequest::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(CreateIntentRequest::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("localeId").build()).build();

    private static final SdkField<InitialResponseSetting> INITIAL_RESPONSE_SETTING_FIELD = SdkField
            .<InitialResponseSetting> builder(MarshallingType.SDK_POJO).memberName("initialResponseSetting")
            .getter(getter(CreateIntentRequest::initialResponseSetting)).setter(setter(Builder::initialResponseSetting))
            .constructor(InitialResponseSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialResponseSetting").build())
            .build();

    private static final SdkField<QnAIntentConfiguration> QN_A_INTENT_CONFIGURATION_FIELD = SdkField
            .<QnAIntentConfiguration> builder(MarshallingType.SDK_POJO).memberName("qnAIntentConfiguration")
            .getter(getter(CreateIntentRequest::qnAIntentConfiguration)).setter(setter(Builder::qnAIntentConfiguration))
            .constructor(QnAIntentConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("qnAIntentConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD,
            DESCRIPTION_FIELD, PARENT_INTENT_SIGNATURE_FIELD, SAMPLE_UTTERANCES_FIELD, DIALOG_CODE_HOOK_FIELD,
            FULFILLMENT_CODE_HOOK_FIELD, INTENT_CONFIRMATION_SETTING_FIELD, INTENT_CLOSING_SETTING_FIELD, INPUT_CONTEXTS_FIELD,
            OUTPUT_CONTEXTS_FIELD, KENDRA_CONFIGURATION_FIELD, BOT_ID_FIELD, BOT_VERSION_FIELD, LOCALE_ID_FIELD,
            INITIAL_RESPONSE_SETTING_FIELD, QN_A_INTENT_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String intentName;

    private final String description;

    private final String parentIntentSignature;

    private final List<SampleUtterance> sampleUtterances;

    private final DialogCodeHookSettings dialogCodeHook;

    private final FulfillmentCodeHookSettings fulfillmentCodeHook;

    private final IntentConfirmationSetting intentConfirmationSetting;

    private final IntentClosingSetting intentClosingSetting;

    private final List<InputContext> inputContexts;

    private final List<OutputContext> outputContexts;

    private final KendraConfiguration kendraConfiguration;

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final InitialResponseSetting initialResponseSetting;

    private final QnAIntentConfiguration qnAIntentConfiguration;

    private CreateIntentRequest(BuilderImpl builder) {
        super(builder);
        this.intentName = builder.intentName;
        this.description = builder.description;
        this.parentIntentSignature = builder.parentIntentSignature;
        this.sampleUtterances = builder.sampleUtterances;
        this.dialogCodeHook = builder.dialogCodeHook;
        this.fulfillmentCodeHook = builder.fulfillmentCodeHook;
        this.intentConfirmationSetting = builder.intentConfirmationSetting;
        this.intentClosingSetting = builder.intentClosingSetting;
        this.inputContexts = builder.inputContexts;
        this.outputContexts = builder.outputContexts;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.initialResponseSetting = builder.initialResponseSetting;
        this.qnAIntentConfiguration = builder.qnAIntentConfiguration;
    }

    /**
     * <p>
     * The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match the
     * name of any built-in intent.
     * </p>
     * 
     * @return The name of the intent. Intent names must be unique in the locale that contains the intent and cannot
     *         match the name of any built-in intent.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * A description of the intent. Use the description to help identify the intent in lists.
     * </p>
     * 
     * @return A description of the intent. Use the description to help identify the intent in lists.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier for the built-in intent to base this intent on.
     * </p>
     * 
     * @return A unique identifier for the built-in intent to base this intent on.
     */
    public final String parentIntentSignature() {
        return parentIntentSignature;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampleUtterances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that a user might say to signal the intent. For example, "I want a pizza", or
     * "I want a {PizzaSize} pizza".
     * </p>
     * <p>
     * In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be displayed in
     * the utterance shown to the user..
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampleUtterances} method.
     * </p>
     * 
     * @return An array of strings that a user might say to signal the intent. For example, "I want a pizza", or
     *         "I want a {PizzaSize} pizza". </p>
     *         <p>
     *         In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be
     *         displayed in the utterance shown to the user..
     */
    public final List<SampleUtterance> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * <p>
     * Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda
     * function to personalize user interaction.
     * </p>
     * <p>
     * For example, suppose that your bot determines that the user's name is John. You Lambda function might retrieve
     * John's information from a backend database and prepopulate some of the values. For example, if you find that John
     * is gluten intolerant, you might set the corresponding intent slot, <code>glutenIntolerant</code> to
     * <code>true</code>. You might find John's phone number and set the corresponding session attribute.
     * </p>
     * 
     * @return Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this
     *         Lambda function to personalize user interaction.</p>
     *         <p>
     *         For example, suppose that your bot determines that the user's name is John. You Lambda function might
     *         retrieve John's information from a backend database and prepopulate some of the values. For example, if
     *         you find that John is gluten intolerant, you might set the corresponding intent slot,
     *         <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the
     *         corresponding session attribute.
     */
    public final DialogCodeHookSettings dialogCodeHook() {
        return dialogCodeHook;
    }

    /**
     * <p>
     * Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can
     * invoke this function to complete the bot's transaction with the user.
     * </p>
     * <p>
     * For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the
     * customer's location and then place an order on the customer's behalf.
     * </p>
     * 
     * @return Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You
     *         can invoke this function to complete the bot's transaction with the user.</p>
     *         <p>
     *         For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the
     *         customer's location and then place an order on the customer's behalf.
     */
    public final FulfillmentCodeHookSettings fulfillmentCodeHook() {
        return fulfillmentCodeHook;
    }

    /**
     * <p>
     * Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user answers
     * "no," the settings contain a statement that is sent to the user to end the intent.
     * </p>
     * 
     * @return Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user
     *         answers "no," the settings contain a statement that is sent to the user to end the intent.
     */
    public final IntentConfirmationSetting intentConfirmationSetting() {
        return intentConfirmationSetting;
    }

    /**
     * <p>
     * Sets the response that Amazon Lex sends to the user when the intent is closed.
     * </p>
     * 
     * @return Sets the response that Amazon Lex sends to the user when the intent is closed.
     */
    public final IntentClosingSetting intentClosingSetting() {
        return intentClosingSetting;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputContexts() {
        return inputContexts != null && !(inputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of contexts that must be active for this intent to be considered by Amazon Lex.
     * </p>
     * <p>
     * When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with the
     * user when the specified contexts are included in the active context list for the session. If the contexts are not
     * active, then Amazon Lex will not use the intent.
     * </p>
     * <p>
     * A context can be automatically activated using the <code>outputContexts</code> property or it can be set at
     * runtime.
     * </p>
     * <p>
     * For example, if there are two intents with different input contexts that respond to the same utterances, only the
     * intent with the active context will respond.
     * </p>
     * <p>
     * An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must be
     * active to consider the intent.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputContexts} method.
     * </p>
     * 
     * @return A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
     *         <p>
     *         When an intent has an input context list, Amazon Lex only considers using the intent in an interaction
     *         with the user when the specified contexts are included in the active context list for the session. If the
     *         contexts are not active, then Amazon Lex will not use the intent.
     *         </p>
     *         <p>
     *         A context can be automatically activated using the <code>outputContexts</code> property or it can be set
     *         at runtime.
     *         </p>
     *         <p>
     *         For example, if there are two intents with different input contexts that respond to the same utterances,
     *         only the intent with the active context will respond.
     *         </p>
     *         <p>
     *         An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts
     *         must be active to consider the intent.
     */
    public final List<InputContext> inputContexts() {
        return inputContexts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputContexts() {
        return outputContexts != null && !(outputContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A lists of contexts that the intent activates when it is fulfilled.
     * </p>
     * <p>
     * You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of the
     * conversation with a customer.
     * </p>
     * <p>
     * When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are
     * activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of
     * conversation turns that the context should be active, or the length of time that the context should be active.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputContexts} method.
     * </p>
     * 
     * @return A lists of contexts that the intent activates when it is fulfilled.</p>
     *         <p>
     *         You can use an output context to indicate the intents that Amazon Lex should consider for the next turn
     *         of the conversation with a customer.
     *         </p>
     *         <p>
     *         When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are
     *         activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number
     *         of conversation turns that the context should be active, or the length of time that the context should be
     *         active.
     */
    public final List<OutputContext> outputContexts() {
        return outputContexts;
    }

    /**
     * <p>
     * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an
     * Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't determine
     * another intent to invoke.
     * </p>
     * 
     * @return Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to
     *         an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't
     *         determine another intent to invoke.
     */
    public final KendraConfiguration kendraConfiguration() {
        return kendraConfiguration;
    }

    /**
     * <p>
     * The identifier of the bot associated with this intent.
     * </p>
     * 
     * @return The identifier of the bot associated with this intent.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot associated with this intent.
     * </p>
     * 
     * @return The version of the bot associated with this intent.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots used
     * by the intent must have the same locale. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     * </p>
     * 
     * @return The identifier of the language and locale where this intent is used. All of the bots, slot types, and
     *         slots used by the intent must have the same locale. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * Configuration settings for the response that is sent to the user at the beginning of a conversation, before
     * eliciting slot values.
     * </p>
     * 
     * @return Configuration settings for the response that is sent to the user at the beginning of a conversation,
     *         before eliciting slot values.
     */
    public final InitialResponseSetting initialResponseSetting() {
        return initialResponseSetting;
    }

    /**
     * <p>
     * Specifies the configuration of the built-in <code>Amazon.QnAIntent</code>. The <code>AMAZON.QnAIntent</code>
     * intent is called when Amazon Lex can't determine another intent to invoke. If you specify this field, you can't
     * specify the <code>kendraConfiguration</code> field.
     * </p>
     * 
     * @return Specifies the configuration of the built-in <code>Amazon.QnAIntent</code>. The
     *         <code>AMAZON.QnAIntent</code> intent is called when Amazon Lex can't determine another intent to invoke.
     *         If you specify this field, you can't specify the <code>kendraConfiguration</code> field.
     */
    public final QnAIntentConfiguration qnAIntentConfiguration() {
        return qnAIntentConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(parentIntentSignature());
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dialogCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(fulfillmentCodeHook());
        hashCode = 31 * hashCode + Objects.hashCode(intentConfirmationSetting());
        hashCode = 31 * hashCode + Objects.hashCode(intentClosingSetting());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputContexts() ? inputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputContexts() ? outputContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(initialResponseSetting());
        hashCode = 31 * hashCode + Objects.hashCode(qnAIntentConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIntentRequest)) {
            return false;
        }
        CreateIntentRequest other = (CreateIntentRequest) obj;
        return Objects.equals(intentName(), other.intentName()) && Objects.equals(description(), other.description())
                && Objects.equals(parentIntentSignature(), other.parentIntentSignature())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(dialogCodeHook(), other.dialogCodeHook())
                && Objects.equals(fulfillmentCodeHook(), other.fulfillmentCodeHook())
                && Objects.equals(intentConfirmationSetting(), other.intentConfirmationSetting())
                && Objects.equals(intentClosingSetting(), other.intentClosingSetting())
                && hasInputContexts() == other.hasInputContexts() && Objects.equals(inputContexts(), other.inputContexts())
                && hasOutputContexts() == other.hasOutputContexts() && Objects.equals(outputContexts(), other.outputContexts())
                && Objects.equals(kendraConfiguration(), other.kendraConfiguration()) && Objects.equals(botId(), other.botId())
                && Objects.equals(botVersion(), other.botVersion()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(initialResponseSetting(), other.initialResponseSetting())
                && Objects.equals(qnAIntentConfiguration(), other.qnAIntentConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIntentRequest").add("IntentName", intentName()).add("Description", description())
                .add("ParentIntentSignature", parentIntentSignature())
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null)
                .add("DialogCodeHook", dialogCodeHook()).add("FulfillmentCodeHook", fulfillmentCodeHook())
                .add("IntentConfirmationSetting", intentConfirmationSetting())
                .add("IntentClosingSetting", intentClosingSetting())
                .add("InputContexts", hasInputContexts() ? inputContexts() : null)
                .add("OutputContexts", hasOutputContexts() ? outputContexts() : null)
                .add("KendraConfiguration", kendraConfiguration()).add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("InitialResponseSetting", initialResponseSetting())
                .add("QnAIntentConfiguration", qnAIntentConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "parentIntentSignature":
            return Optional.ofNullable(clazz.cast(parentIntentSignature()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "dialogCodeHook":
            return Optional.ofNullable(clazz.cast(dialogCodeHook()));
        case "fulfillmentCodeHook":
            return Optional.ofNullable(clazz.cast(fulfillmentCodeHook()));
        case "intentConfirmationSetting":
            return Optional.ofNullable(clazz.cast(intentConfirmationSetting()));
        case "intentClosingSetting":
            return Optional.ofNullable(clazz.cast(intentClosingSetting()));
        case "inputContexts":
            return Optional.ofNullable(clazz.cast(inputContexts()));
        case "outputContexts":
            return Optional.ofNullable(clazz.cast(outputContexts()));
        case "kendraConfiguration":
            return Optional.ofNullable(clazz.cast(kendraConfiguration()));
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "initialResponseSetting":
            return Optional.ofNullable(clazz.cast(initialResponseSetting()));
        case "qnAIntentConfiguration":
            return Optional.ofNullable(clazz.cast(qnAIntentConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intentName", INTENT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("parentIntentSignature", PARENT_INTENT_SIGNATURE_FIELD);
        map.put("sampleUtterances", SAMPLE_UTTERANCES_FIELD);
        map.put("dialogCodeHook", DIALOG_CODE_HOOK_FIELD);
        map.put("fulfillmentCodeHook", FULFILLMENT_CODE_HOOK_FIELD);
        map.put("intentConfirmationSetting", INTENT_CONFIRMATION_SETTING_FIELD);
        map.put("intentClosingSetting", INTENT_CLOSING_SETTING_FIELD);
        map.put("inputContexts", INPUT_CONTEXTS_FIELD);
        map.put("outputContexts", OUTPUT_CONTEXTS_FIELD);
        map.put("kendraConfiguration", KENDRA_CONFIGURATION_FIELD);
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("initialResponseSetting", INITIAL_RESPONSE_SETTING_FIELD);
        map.put("qnAIntentConfiguration", QN_A_INTENT_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateIntentRequest, T> g) {
        return obj -> g.apply((CreateIntentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateIntentRequest> {
        /**
         * <p>
         * The name of the intent. Intent names must be unique in the locale that contains the intent and cannot match
         * the name of any built-in intent.
         * </p>
         * 
         * @param intentName
         *        The name of the intent. Intent names must be unique in the locale that contains the intent and cannot
         *        match the name of any built-in intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * A description of the intent. Use the description to help identify the intent in lists.
         * </p>
         * 
         * @param description
         *        A description of the intent. Use the description to help identify the intent in lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier for the built-in intent to base this intent on.
         * </p>
         * 
         * @param parentIntentSignature
         *        A unique identifier for the built-in intent to base this intent on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentIntentSignature(String parentIntentSignature);

        /**
         * <p>
         * An array of strings that a user might say to signal the intent. For example, "I want a pizza", or
         * "I want a {PizzaSize} pizza".
         * </p>
         * <p>
         * In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be
         * displayed in the utterance shown to the user..
         * </p>
         * 
         * @param sampleUtterances
         *        An array of strings that a user might say to signal the intent. For example, "I want a pizza", or
         *        "I want a {PizzaSize} pizza". </p>
         *        <p>
         *        In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be
         *        displayed in the utterance shown to the user..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances);

        /**
         * <p>
         * An array of strings that a user might say to signal the intent. For example, "I want a pizza", or
         * "I want a {PizzaSize} pizza".
         * </p>
         * <p>
         * In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be
         * displayed in the utterance shown to the user..
         * </p>
         * 
         * @param sampleUtterances
         *        An array of strings that a user might say to signal the intent. For example, "I want a pizza", or
         *        "I want a {PizzaSize} pizza". </p>
         *        <p>
         *        In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be
         *        displayed in the utterance shown to the user..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(SampleUtterance... sampleUtterances);

        /**
         * <p>
         * An array of strings that a user might say to signal the intent. For example, "I want a pizza", or
         * "I want a {PizzaSize} pizza".
         * </p>
         * <p>
         * In an utterance, slot names are enclosed in curly braces ("{", "}") to indicate where they should be
         * displayed in the utterance shown to the user..
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder#build()} is called
         * immediately and its result is passed to {@link #sampleUtterances(List<SampleUtterance>)}.
         * 
         * @param sampleUtterances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleUtterances(java.util.Collection<SampleUtterance>)
         */
        Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances);

        /**
         * <p>
         * Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda
         * function to personalize user interaction.
         * </p>
         * <p>
         * For example, suppose that your bot determines that the user's name is John. You Lambda function might
         * retrieve John's information from a backend database and prepopulate some of the values. For example, if you
         * find that John is gluten intolerant, you might set the corresponding intent slot,
         * <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the
         * corresponding session attribute.
         * </p>
         * 
         * @param dialogCodeHook
         *        Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this
         *        Lambda function to personalize user interaction.</p>
         *        <p>
         *        For example, suppose that your bot determines that the user's name is John. You Lambda function might
         *        retrieve John's information from a backend database and prepopulate some of the values. For example,
         *        if you find that John is gluten intolerant, you might set the corresponding intent slot,
         *        <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the
         *        corresponding session attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook);

        /**
         * <p>
         * Specifies that Amazon Lex invokes the alias Lambda function for each user input. You can invoke this Lambda
         * function to personalize user interaction.
         * </p>
         * <p>
         * For example, suppose that your bot determines that the user's name is John. You Lambda function might
         * retrieve John's information from a backend database and prepopulate some of the values. For example, if you
         * find that John is gluten intolerant, you might set the corresponding intent slot,
         * <code>glutenIntolerant</code> to <code>true</code>. You might find John's phone number and set the
         * corresponding session attribute.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogCodeHookSettings.Builder} avoiding
         * the need to create one manually via {@link DialogCodeHookSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogCodeHookSettings.Builder#build()} is called immediately and
         * its result is passed to {@link #dialogCodeHook(DialogCodeHookSettings)}.
         * 
         * @param dialogCodeHook
         *        a consumer that will call methods on {@link DialogCodeHookSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dialogCodeHook(DialogCodeHookSettings)
         */
        default Builder dialogCodeHook(Consumer<DialogCodeHookSettings.Builder> dialogCodeHook) {
            return dialogCodeHook(DialogCodeHookSettings.builder().applyMutation(dialogCodeHook).build());
        }

        /**
         * <p>
         * Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can
         * invoke this function to complete the bot's transaction with the user.
         * </p>
         * <p>
         * For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the
         * customer's location and then place an order on the customer's behalf.
         * </p>
         * 
         * @param fulfillmentCodeHook
         *        Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment.
         *        You can invoke this function to complete the bot's transaction with the user.</p>
         *        <p>
         *        For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to
         *        the customer's location and then place an order on the customer's behalf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook);

        /**
         * <p>
         * Specifies that Amazon Lex invokes the alias Lambda function when the intent is ready for fulfillment. You can
         * invoke this function to complete the bot's transaction with the user.
         * </p>
         * <p>
         * For example, in a pizza ordering bot, the Lambda function can look up the closest pizza restaurant to the
         * customer's location and then place an order on the customer's behalf.
         * </p>
         * This is a convenience method that creates an instance of the {@link FulfillmentCodeHookSettings.Builder}
         * avoiding the need to create one manually via {@link FulfillmentCodeHookSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FulfillmentCodeHookSettings.Builder#build()} is called
         * immediately and its result is passed to {@link #fulfillmentCodeHook(FulfillmentCodeHookSettings)}.
         * 
         * @param fulfillmentCodeHook
         *        a consumer that will call methods on {@link FulfillmentCodeHookSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fulfillmentCodeHook(FulfillmentCodeHookSettings)
         */
        default Builder fulfillmentCodeHook(Consumer<FulfillmentCodeHookSettings.Builder> fulfillmentCodeHook) {
            return fulfillmentCodeHook(FulfillmentCodeHookSettings.builder().applyMutation(fulfillmentCodeHook).build());
        }

        /**
         * <p>
         * Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user
         * answers "no," the settings contain a statement that is sent to the user to end the intent.
         * </p>
         * 
         * @param intentConfirmationSetting
         *        Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user
         *        answers "no," the settings contain a statement that is sent to the user to end the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting);

        /**
         * <p>
         * Provides prompts that Amazon Lex sends to the user to confirm the completion of an intent. If the user
         * answers "no," the settings contain a statement that is sent to the user to end the intent.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentConfirmationSetting.Builder}
         * avoiding the need to create one manually via {@link IntentConfirmationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentConfirmationSetting.Builder#build()} is called immediately
         * and its result is passed to {@link #intentConfirmationSetting(IntentConfirmationSetting)}.
         * 
         * @param intentConfirmationSetting
         *        a consumer that will call methods on {@link IntentConfirmationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentConfirmationSetting(IntentConfirmationSetting)
         */
        default Builder intentConfirmationSetting(Consumer<IntentConfirmationSetting.Builder> intentConfirmationSetting) {
            return intentConfirmationSetting(IntentConfirmationSetting.builder().applyMutation(intentConfirmationSetting).build());
        }

        /**
         * <p>
         * Sets the response that Amazon Lex sends to the user when the intent is closed.
         * </p>
         * 
         * @param intentClosingSetting
         *        Sets the response that Amazon Lex sends to the user when the intent is closed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentClosingSetting(IntentClosingSetting intentClosingSetting);

        /**
         * <p>
         * Sets the response that Amazon Lex sends to the user when the intent is closed.
         * </p>
         * This is a convenience method that creates an instance of the {@link IntentClosingSetting.Builder} avoiding
         * the need to create one manually via {@link IntentClosingSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentClosingSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #intentClosingSetting(IntentClosingSetting)}.
         * 
         * @param intentClosingSetting
         *        a consumer that will call methods on {@link IntentClosingSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intentClosingSetting(IntentClosingSetting)
         */
        default Builder intentClosingSetting(Consumer<IntentClosingSetting.Builder> intentClosingSetting) {
            return intentClosingSetting(IntentClosingSetting.builder().applyMutation(intentClosingSetting).build());
        }

        /**
         * <p>
         * A list of contexts that must be active for this intent to be considered by Amazon Lex.
         * </p>
         * <p>
         * When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with
         * the user when the specified contexts are included in the active context list for the session. If the contexts
         * are not active, then Amazon Lex will not use the intent.
         * </p>
         * <p>
         * A context can be automatically activated using the <code>outputContexts</code> property or it can be set at
         * runtime.
         * </p>
         * <p>
         * For example, if there are two intents with different input contexts that respond to the same utterances, only
         * the intent with the active context will respond.
         * </p>
         * <p>
         * An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must
         * be active to consider the intent.
         * </p>
         * 
         * @param inputContexts
         *        A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
         *        <p>
         *        When an intent has an input context list, Amazon Lex only considers using the intent in an interaction
         *        with the user when the specified contexts are included in the active context list for the session. If
         *        the contexts are not active, then Amazon Lex will not use the intent.
         *        </p>
         *        <p>
         *        A context can be automatically activated using the <code>outputContexts</code> property or it can be
         *        set at runtime.
         *        </p>
         *        <p>
         *        For example, if there are two intents with different input contexts that respond to the same
         *        utterances, only the intent with the active context will respond.
         *        </p>
         *        <p>
         *        An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the
         *        contexts must be active to consider the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(Collection<InputContext> inputContexts);

        /**
         * <p>
         * A list of contexts that must be active for this intent to be considered by Amazon Lex.
         * </p>
         * <p>
         * When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with
         * the user when the specified contexts are included in the active context list for the session. If the contexts
         * are not active, then Amazon Lex will not use the intent.
         * </p>
         * <p>
         * A context can be automatically activated using the <code>outputContexts</code> property or it can be set at
         * runtime.
         * </p>
         * <p>
         * For example, if there are two intents with different input contexts that respond to the same utterances, only
         * the intent with the active context will respond.
         * </p>
         * <p>
         * An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must
         * be active to consider the intent.
         * </p>
         * 
         * @param inputContexts
         *        A list of contexts that must be active for this intent to be considered by Amazon Lex.</p>
         *        <p>
         *        When an intent has an input context list, Amazon Lex only considers using the intent in an interaction
         *        with the user when the specified contexts are included in the active context list for the session. If
         *        the contexts are not active, then Amazon Lex will not use the intent.
         *        </p>
         *        <p>
         *        A context can be automatically activated using the <code>outputContexts</code> property or it can be
         *        set at runtime.
         *        </p>
         *        <p>
         *        For example, if there are two intents with different input contexts that respond to the same
         *        utterances, only the intent with the active context will respond.
         *        </p>
         *        <p>
         *        An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the
         *        contexts must be active to consider the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputContexts(InputContext... inputContexts);

        /**
         * <p>
         * A list of contexts that must be active for this intent to be considered by Amazon Lex.
         * </p>
         * <p>
         * When an intent has an input context list, Amazon Lex only considers using the intent in an interaction with
         * the user when the specified contexts are included in the active context list for the session. If the contexts
         * are not active, then Amazon Lex will not use the intent.
         * </p>
         * <p>
         * A context can be automatically activated using the <code>outputContexts</code> property or it can be set at
         * runtime.
         * </p>
         * <p>
         * For example, if there are two intents with different input contexts that respond to the same utterances, only
         * the intent with the active context will respond.
         * </p>
         * <p>
         * An intent may have up to 5 input contexts. If an intent has multiple input contexts, all of the contexts must
         * be active to consider the intent.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder#build()} is called immediately
         * and its result is passed to {@link #inputContexts(List<InputContext>)}.
         * 
         * @param inputContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.InputContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputContexts(java.util.Collection<InputContext>)
         */
        Builder inputContexts(Consumer<InputContext.Builder>... inputContexts);

        /**
         * <p>
         * A lists of contexts that the intent activates when it is fulfilled.
         * </p>
         * <p>
         * You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of
         * the conversation with a customer.
         * </p>
         * <p>
         * When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are
         * activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of
         * conversation turns that the context should be active, or the length of time that the context should be
         * active.
         * </p>
         * 
         * @param outputContexts
         *        A lists of contexts that the intent activates when it is fulfilled.</p>
         *        <p>
         *        You can use an output context to indicate the intents that Amazon Lex should consider for the next
         *        turn of the conversation with a customer.
         *        </p>
         *        <p>
         *        When you use the <code>outputContextsList</code> property, all of the contexts specified in the list
         *        are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the
         *        number of conversation turns that the context should be active, or the length of time that the context
         *        should be active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(Collection<OutputContext> outputContexts);

        /**
         * <p>
         * A lists of contexts that the intent activates when it is fulfilled.
         * </p>
         * <p>
         * You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of
         * the conversation with a customer.
         * </p>
         * <p>
         * When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are
         * activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of
         * conversation turns that the context should be active, or the length of time that the context should be
         * active.
         * </p>
         * 
         * @param outputContexts
         *        A lists of contexts that the intent activates when it is fulfilled.</p>
         *        <p>
         *        You can use an output context to indicate the intents that Amazon Lex should consider for the next
         *        turn of the conversation with a customer.
         *        </p>
         *        <p>
         *        When you use the <code>outputContextsList</code> property, all of the contexts specified in the list
         *        are activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the
         *        number of conversation turns that the context should be active, or the length of time that the context
         *        should be active.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputContexts(OutputContext... outputContexts);

        /**
         * <p>
         * A lists of contexts that the intent activates when it is fulfilled.
         * </p>
         * <p>
         * You can use an output context to indicate the intents that Amazon Lex should consider for the next turn of
         * the conversation with a customer.
         * </p>
         * <p>
         * When you use the <code>outputContextsList</code> property, all of the contexts specified in the list are
         * activated when the intent is fulfilled. You can set up to 10 output contexts. You can also set the number of
         * conversation turns that the context should be active, or the length of time that the context should be
         * active.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder#build()} is called immediately
         * and its result is passed to {@link #outputContexts(List<OutputContext>)}.
         * 
         * @param outputContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.OutputContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputContexts(java.util.Collection<OutputContext>)
         */
        Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts);

        /**
         * <p>
         * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an
         * Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't
         * determine another intent to invoke.
         * </p>
         * 
         * @param kendraConfiguration
         *        Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect
         *        to an Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex
         *        can't determine another intent to invoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraConfiguration(KendraConfiguration kendraConfiguration);

        /**
         * <p>
         * Configuration information required to use the <code>AMAZON.KendraSearchIntent</code> intent to connect to an
         * Amazon Kendra index. The <code>AMAZON.KendraSearchIntent</code> intent is called when Amazon Lex can't
         * determine another intent to invoke.
         * </p>
         * This is a convenience method that creates an instance of the {@link KendraConfiguration.Builder} avoiding the
         * need to create one manually via {@link KendraConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link KendraConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kendraConfiguration(KendraConfiguration)}.
         * 
         * @param kendraConfiguration
         *        a consumer that will call methods on {@link KendraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraConfiguration(KendraConfiguration)
         */
        default Builder kendraConfiguration(Consumer<KendraConfiguration.Builder> kendraConfiguration) {
            return kendraConfiguration(KendraConfiguration.builder().applyMutation(kendraConfiguration).build());
        }

        /**
         * <p>
         * The identifier of the bot associated with this intent.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with this intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot associated with this intent.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot associated with this intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale where this intent is used. All of the bots, slot types, and slots
         * used by the intent must have the same locale. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale where this intent is used. All of the bots, slot types, and
         *        slots used by the intent must have the same locale. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html">Supported languages</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * Configuration settings for the response that is sent to the user at the beginning of a conversation, before
         * eliciting slot values.
         * </p>
         * 
         * @param initialResponseSetting
         *        Configuration settings for the response that is sent to the user at the beginning of a conversation,
         *        before eliciting slot values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialResponseSetting(InitialResponseSetting initialResponseSetting);

        /**
         * <p>
         * Configuration settings for the response that is sent to the user at the beginning of a conversation, before
         * eliciting slot values.
         * </p>
         * This is a convenience method that creates an instance of the {@link InitialResponseSetting.Builder} avoiding
         * the need to create one manually via {@link InitialResponseSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InitialResponseSetting.Builder#build()} is called immediately and
         * its result is passed to {@link #initialResponseSetting(InitialResponseSetting)}.
         * 
         * @param initialResponseSetting
         *        a consumer that will call methods on {@link InitialResponseSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialResponseSetting(InitialResponseSetting)
         */
        default Builder initialResponseSetting(Consumer<InitialResponseSetting.Builder> initialResponseSetting) {
            return initialResponseSetting(InitialResponseSetting.builder().applyMutation(initialResponseSetting).build());
        }

        /**
         * <p>
         * Specifies the configuration of the built-in <code>Amazon.QnAIntent</code>. The <code>AMAZON.QnAIntent</code>
         * intent is called when Amazon Lex can't determine another intent to invoke. If you specify this field, you
         * can't specify the <code>kendraConfiguration</code> field.
         * </p>
         * 
         * @param qnAIntentConfiguration
         *        Specifies the configuration of the built-in <code>Amazon.QnAIntent</code>. The
         *        <code>AMAZON.QnAIntent</code> intent is called when Amazon Lex can't determine another intent to
         *        invoke. If you specify this field, you can't specify the <code>kendraConfiguration</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qnAIntentConfiguration(QnAIntentConfiguration qnAIntentConfiguration);

        /**
         * <p>
         * Specifies the configuration of the built-in <code>Amazon.QnAIntent</code>. The <code>AMAZON.QnAIntent</code>
         * intent is called when Amazon Lex can't determine another intent to invoke. If you specify this field, you
         * can't specify the <code>kendraConfiguration</code> field.
         * </p>
         * This is a convenience method that creates an instance of the {@link QnAIntentConfiguration.Builder} avoiding
         * the need to create one manually via {@link QnAIntentConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QnAIntentConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #qnAIntentConfiguration(QnAIntentConfiguration)}.
         * 
         * @param qnAIntentConfiguration
         *        a consumer that will call methods on {@link QnAIntentConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qnAIntentConfiguration(QnAIntentConfiguration)
         */
        default Builder qnAIntentConfiguration(Consumer<QnAIntentConfiguration.Builder> qnAIntentConfiguration) {
            return qnAIntentConfiguration(QnAIntentConfiguration.builder().applyMutation(qnAIntentConfiguration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String intentName;

        private String description;

        private String parentIntentSignature;

        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private DialogCodeHookSettings dialogCodeHook;

        private FulfillmentCodeHookSettings fulfillmentCodeHook;

        private IntentConfirmationSetting intentConfirmationSetting;

        private IntentClosingSetting intentClosingSetting;

        private List<InputContext> inputContexts = DefaultSdkAutoConstructList.getInstance();

        private List<OutputContext> outputContexts = DefaultSdkAutoConstructList.getInstance();

        private KendraConfiguration kendraConfiguration;

        private String botId;

        private String botVersion;

        private String localeId;

        private InitialResponseSetting initialResponseSetting;

        private QnAIntentConfiguration qnAIntentConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIntentRequest model) {
            super(model);
            intentName(model.intentName);
            description(model.description);
            parentIntentSignature(model.parentIntentSignature);
            sampleUtterances(model.sampleUtterances);
            dialogCodeHook(model.dialogCodeHook);
            fulfillmentCodeHook(model.fulfillmentCodeHook);
            intentConfirmationSetting(model.intentConfirmationSetting);
            intentClosingSetting(model.intentClosingSetting);
            inputContexts(model.inputContexts);
            outputContexts(model.outputContexts);
            kendraConfiguration(model.kendraConfiguration);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            initialResponseSetting(model.initialResponseSetting);
            qnAIntentConfiguration(model.qnAIntentConfiguration);
        }

        public final String getIntentName() {
            return intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getParentIntentSignature() {
            return parentIntentSignature;
        }

        public final void setParentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
        }

        @Override
        public final Builder parentIntentSignature(String parentIntentSignature) {
            this.parentIntentSignature = parentIntentSignature;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances) {
            sampleUtterances(Stream.of(sampleUtterances).map(c -> SampleUtterance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DialogCodeHookSettings.Builder getDialogCodeHook() {
            return dialogCodeHook != null ? dialogCodeHook.toBuilder() : null;
        }

        public final void setDialogCodeHook(DialogCodeHookSettings.BuilderImpl dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook != null ? dialogCodeHook.build() : null;
        }

        @Override
        public final Builder dialogCodeHook(DialogCodeHookSettings dialogCodeHook) {
            this.dialogCodeHook = dialogCodeHook;
            return this;
        }

        public final FulfillmentCodeHookSettings.Builder getFulfillmentCodeHook() {
            return fulfillmentCodeHook != null ? fulfillmentCodeHook.toBuilder() : null;
        }

        public final void setFulfillmentCodeHook(FulfillmentCodeHookSettings.BuilderImpl fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook != null ? fulfillmentCodeHook.build() : null;
        }

        @Override
        public final Builder fulfillmentCodeHook(FulfillmentCodeHookSettings fulfillmentCodeHook) {
            this.fulfillmentCodeHook = fulfillmentCodeHook;
            return this;
        }

        public final IntentConfirmationSetting.Builder getIntentConfirmationSetting() {
            return intentConfirmationSetting != null ? intentConfirmationSetting.toBuilder() : null;
        }

        public final void setIntentConfirmationSetting(IntentConfirmationSetting.BuilderImpl intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting != null ? intentConfirmationSetting.build() : null;
        }

        @Override
        public final Builder intentConfirmationSetting(IntentConfirmationSetting intentConfirmationSetting) {
            this.intentConfirmationSetting = intentConfirmationSetting;
            return this;
        }

        public final IntentClosingSetting.Builder getIntentClosingSetting() {
            return intentClosingSetting != null ? intentClosingSetting.toBuilder() : null;
        }

        public final void setIntentClosingSetting(IntentClosingSetting.BuilderImpl intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting != null ? intentClosingSetting.build() : null;
        }

        @Override
        public final Builder intentClosingSetting(IntentClosingSetting intentClosingSetting) {
            this.intentClosingSetting = intentClosingSetting;
            return this;
        }

        public final List<InputContext.Builder> getInputContexts() {
            List<InputContext.Builder> result = InputContextsListCopier.copyToBuilder(this.inputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputContexts(Collection<InputContext.BuilderImpl> inputContexts) {
            this.inputContexts = InputContextsListCopier.copyFromBuilder(inputContexts);
        }

        @Override
        public final Builder inputContexts(Collection<InputContext> inputContexts) {
            this.inputContexts = InputContextsListCopier.copy(inputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(InputContext... inputContexts) {
            inputContexts(Arrays.asList(inputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputContexts(Consumer<InputContext.Builder>... inputContexts) {
            inputContexts(Stream.of(inputContexts).map(c -> InputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OutputContext.Builder> getOutputContexts() {
            List<OutputContext.Builder> result = OutputContextsListCopier.copyToBuilder(this.outputContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputContexts(Collection<OutputContext.BuilderImpl> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copyFromBuilder(outputContexts);
        }

        @Override
        public final Builder outputContexts(Collection<OutputContext> outputContexts) {
            this.outputContexts = OutputContextsListCopier.copy(outputContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(OutputContext... outputContexts) {
            outputContexts(Arrays.asList(outputContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputContexts(Consumer<OutputContext.Builder>... outputContexts) {
            outputContexts(Stream.of(outputContexts).map(c -> OutputContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final KendraConfiguration.Builder getKendraConfiguration() {
            return kendraConfiguration != null ? kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(KendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public final Builder kendraConfiguration(KendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final InitialResponseSetting.Builder getInitialResponseSetting() {
            return initialResponseSetting != null ? initialResponseSetting.toBuilder() : null;
        }

        public final void setInitialResponseSetting(InitialResponseSetting.BuilderImpl initialResponseSetting) {
            this.initialResponseSetting = initialResponseSetting != null ? initialResponseSetting.build() : null;
        }

        @Override
        public final Builder initialResponseSetting(InitialResponseSetting initialResponseSetting) {
            this.initialResponseSetting = initialResponseSetting;
            return this;
        }

        public final QnAIntentConfiguration.Builder getQnAIntentConfiguration() {
            return qnAIntentConfiguration != null ? qnAIntentConfiguration.toBuilder() : null;
        }

        public final void setQnAIntentConfiguration(QnAIntentConfiguration.BuilderImpl qnAIntentConfiguration) {
            this.qnAIntentConfiguration = qnAIntentConfiguration != null ? qnAIntentConfiguration.build() : null;
        }

        @Override
        public final Builder qnAIntentConfiguration(QnAIntentConfiguration qnAIntentConfiguration) {
            this.qnAIntentConfiguration = qnAIntentConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIntentRequest build() {
            return new CreateIntentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
