/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of actions that Amazon Lex should run if none of the other conditions are met.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefaultConditionalBranch implements SdkPojo, Serializable,
        ToCopyableBuilder<DefaultConditionalBranch.Builder, DefaultConditionalBranch> {
    private static final SdkField<DialogState> NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("nextStep").getter(getter(DefaultConditionalBranch::nextStep)).setter(setter(Builder::nextStep))
            .constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextStep").build()).build();

    private static final SdkField<ResponseSpecification> RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("response")
            .getter(getter(DefaultConditionalBranch::response)).setter(setter(Builder::response))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("response").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_STEP_FIELD,
            RESPONSE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DialogState nextStep;

    private final ResponseSpecification response;

    private DefaultConditionalBranch(BuilderImpl builder) {
        this.nextStep = builder.nextStep;
        this.response = builder.response;
    }

    /**
     * <p>
     * The next step in the conversation.
     * </p>
     * 
     * @return The next step in the conversation.
     */
    public final DialogState nextStep() {
        return nextStep;
    }

    /**
     * Returns the value of the Response property for this object.
     * 
     * @return The value of the Response property for this object.
     */
    public final ResponseSpecification response() {
        return response;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextStep());
        hashCode = 31 * hashCode + Objects.hashCode(response());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultConditionalBranch)) {
            return false;
        }
        DefaultConditionalBranch other = (DefaultConditionalBranch) obj;
        return Objects.equals(nextStep(), other.nextStep()) && Objects.equals(response(), other.response());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefaultConditionalBranch").add("NextStep", nextStep()).add("Response", response()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextStep":
            return Optional.ofNullable(clazz.cast(nextStep()));
        case "response":
            return Optional.ofNullable(clazz.cast(response()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextStep", NEXT_STEP_FIELD);
        map.put("response", RESPONSE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefaultConditionalBranch, T> g) {
        return obj -> g.apply((DefaultConditionalBranch) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefaultConditionalBranch> {
        /**
         * <p>
         * The next step in the conversation.
         * </p>
         * 
         * @param nextStep
         *        The next step in the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextStep(DialogState nextStep);

        /**
         * <p>
         * The next step in the conversation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #nextStep(DialogState)}.
         * 
         * @param nextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextStep(DialogState)
         */
        default Builder nextStep(Consumer<DialogState.Builder> nextStep) {
            return nextStep(DialogState.builder().applyMutation(nextStep).build());
        }

        /**
         * Sets the value of the Response property for this object.
         *
         * @param response
         *        The new value for the Response property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder response(ResponseSpecification response);

        /**
         * Sets the value of the Response property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #response(ResponseSpecification)}.
         * 
         * @param response
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #response(ResponseSpecification)
         */
        default Builder response(Consumer<ResponseSpecification.Builder> response) {
            return response(ResponseSpecification.builder().applyMutation(response).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DialogState nextStep;

        private ResponseSpecification response;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultConditionalBranch model) {
            nextStep(model.nextStep);
            response(model.response);
        }

        public final DialogState.Builder getNextStep() {
            return nextStep != null ? nextStep.toBuilder() : null;
        }

        public final void setNextStep(DialogState.BuilderImpl nextStep) {
            this.nextStep = nextStep != null ? nextStep.build() : null;
        }

        @Override
        public final Builder nextStep(DialogState nextStep) {
            this.nextStep = nextStep;
            return this;
        }

        public final ResponseSpecification.Builder getResponse() {
            return response != null ? response.toBuilder() : null;
        }

        public final void setResponse(ResponseSpecification.BuilderImpl response) {
            this.response = response != null ? response.build() : null;
        }

        @Override
        public final Builder response(ResponseSpecification response) {
            this.response = response;
            return this;
        }

        @Override
        public DefaultConditionalBranch build() {
            return new DefaultConditionalBranch(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
