/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourcePolicyStatementRequest extends LexModelsV2Request implements
        ToCopyableBuilder<DeleteResourcePolicyStatementRequest.Builder, DeleteResourcePolicyStatementRequest> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(DeleteResourcePolicyStatementRequest::resourceArn))
            .setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceArn").build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statementId").getter(getter(DeleteResourcePolicyStatementRequest::statementId))
            .setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("statementId").build()).build();

    private static final SdkField<String> EXPECTED_REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expectedRevisionId").getter(getter(DeleteResourcePolicyStatementRequest::expectedRevisionId))
            .setter(setter(Builder::expectedRevisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("expectedRevisionId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            STATEMENT_ID_FIELD, EXPECTED_REVISION_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String resourceArn;

    private final String statementId;

    private final String expectedRevisionId;

    private DeleteResourcePolicyStatementRequest(BuilderImpl builder) {
        super(builder);
        this.resourceArn = builder.resourceArn;
        this.statementId = builder.statementId;
        this.expectedRevisionId = builder.expectedRevisionId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The name of the statement (SID) to delete from the policy.
     * </p>
     * 
     * @return The name of the statement (SID) to delete from the policy.
     */
    public final String statementId() {
        return statementId;
    }

    /**
     * <p>
     * The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match the
     * current revision ID, Amazon Lex throws an exception.
     * </p>
     * <p>
     * If you don't specify a revision, Amazon Lex removes the current contents of the statement.
     * </p>
     * 
     * @return The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't
     *         match the current revision ID, Amazon Lex throws an exception.</p>
     *         <p>
     *         If you don't specify a revision, Amazon Lex removes the current contents of the statement.
     */
    public final String expectedRevisionId() {
        return expectedRevisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        hashCode = 31 * hashCode + Objects.hashCode(expectedRevisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourcePolicyStatementRequest)) {
            return false;
        }
        DeleteResourcePolicyStatementRequest other = (DeleteResourcePolicyStatementRequest) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(statementId(), other.statementId())
                && Objects.equals(expectedRevisionId(), other.expectedRevisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourcePolicyStatementRequest").add("ResourceArn", resourceArn())
                .add("StatementId", statementId()).add("ExpectedRevisionId", expectedRevisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "statementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        case "expectedRevisionId":
            return Optional.ofNullable(clazz.cast(expectedRevisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("statementId", STATEMENT_ID_FIELD);
        map.put("expectedRevisionId", EXPECTED_REVISION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourcePolicyStatementRequest, T> g) {
        return obj -> g.apply((DeleteResourcePolicyStatementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteResourcePolicyStatementRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
         * </p>
         * 
         * @param resourceArn
         *        The Amazon Resource Name (ARN) of the bot or bot alias that the resource policy is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The name of the statement (SID) to delete from the policy.
         * </p>
         * 
         * @param statementId
         *        The name of the statement (SID) to delete from the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);

        /**
         * <p>
         * The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't match
         * the current revision ID, Amazon Lex throws an exception.
         * </p>
         * <p>
         * If you don't specify a revision, Amazon Lex removes the current contents of the statement.
         * </p>
         * 
         * @param expectedRevisionId
         *        The identifier of the revision of the policy to delete the statement from. If this revision ID doesn't
         *        match the current revision ID, Amazon Lex throws an exception.</p>
         *        <p>
         *        If you don't specify a revision, Amazon Lex removes the current contents of the statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expectedRevisionId(String expectedRevisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String resourceArn;

        private String statementId;

        private String expectedRevisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourcePolicyStatementRequest model) {
            super(model);
            resourceArn(model.resourceArn);
            statementId(model.statementId);
            expectedRevisionId(model.expectedRevisionId);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getStatementId() {
            return statementId;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final String getExpectedRevisionId() {
            return expectedRevisionId;
        }

        public final void setExpectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
        }

        @Override
        public final Builder expectedRevisionId(String expectedRevisionId) {
            this.expectedRevisionId = expectedRevisionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourcePolicyStatementRequest build() {
            return new DeleteResourcePolicyStatementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
