/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.SessionSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.SessionSpecificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSessionAnalyticsDataResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListSessionAnalyticsDataResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListSessionAnalyticsDataResponse.getter(ListSessionAnalyticsDataResponse::botId)).setter(ListSessionAnalyticsDataResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListSessionAnalyticsDataResponse.getter(ListSessionAnalyticsDataResponse::nextToken)).setter(ListSessionAnalyticsDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SessionSpecification>> SESSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sessions").getter(ListSessionAnalyticsDataResponse.getter(ListSessionAnalyticsDataResponse::sessions)).setter(ListSessionAnalyticsDataResponse.setter(Builder::sessions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SessionSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, NEXT_TOKEN_FIELD, SESSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSessionAnalyticsDataResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String nextToken;
    private final List<SessionSpecification> sessions;

    private ListSessionAnalyticsDataResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.nextToken = builder.nextToken;
        this.sessions = builder.sessions;
    }

    public final String botId() {
        return this.botId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSessions() {
        return this.sessions != null && !(this.sessions instanceof SdkAutoConstructList);
    }

    public final List<SessionSpecification> sessions() {
        return this.sessions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSessions() ? this.sessions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionAnalyticsDataResponse)) {
            return false;
        }
        ListSessionAnalyticsDataResponse other = (ListSessionAnalyticsDataResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasSessions() == other.hasSessions() && Objects.equals(this.sessions(), other.sessions());
    }

    public final String toString() {
        return ToString.builder((String)"ListSessionAnalyticsDataResponse").add("BotId", (Object)this.botId()).add("NextToken", (Object)this.nextToken()).add("Sessions", this.hasSessions() ? this.sessions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sessions": {
                return Optional.ofNullable(clazz.cast(this.sessions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sessions", SESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSessionAnalyticsDataResponse, T> g) {
        return obj -> g.apply((ListSessionAnalyticsDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String nextToken;
        private List<SessionSpecification> sessions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionAnalyticsDataResponse model) {
            super(model);
            this.botId(model.botId);
            this.nextToken(model.nextToken);
            this.sessions(model.sessions);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SessionSpecification.Builder> getSessions() {
            List<SessionSpecification.Builder> result = SessionSpecificationsCopier.copyToBuilder(this.sessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessions(Collection<SessionSpecification.BuilderImpl> sessions) {
            this.sessions = SessionSpecificationsCopier.copyFromBuilder(sessions);
        }

        @Override
        public final Builder sessions(Collection<SessionSpecification> sessions) {
            this.sessions = SessionSpecificationsCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(SessionSpecification ... sessions) {
            this.sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<SessionSpecification.Builder> ... sessions) {
            this.sessions(Stream.of(sessions).map(c -> (SessionSpecification)((SessionSpecification.Builder)SessionSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSessionAnalyticsDataResponse build() {
            return new ListSessionAnalyticsDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSessionAnalyticsDataResponse> {
        public Builder botId(String var1);

        public Builder nextToken(String var1);

        public Builder sessions(Collection<SessionSpecification> var1);

        public Builder sessions(SessionSpecification ... var1);

        public Builder sessions(Consumer<SessionSpecification.Builder> ... var1);
    }
}

