/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification;
import software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecificationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListUtteranceAnalyticsDataResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListUtteranceAnalyticsDataResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("botId").getter(ListUtteranceAnalyticsDataResponse.getter(ListUtteranceAnalyticsDataResponse::botId)).setter(ListUtteranceAnalyticsDataResponse.setter(Builder::botId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListUtteranceAnalyticsDataResponse.getter(ListUtteranceAnalyticsDataResponse::nextToken)).setter(ListUtteranceAnalyticsDataResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<UtteranceSpecification>> UTTERANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("utterances").getter(ListUtteranceAnalyticsDataResponse.getter(ListUtteranceAnalyticsDataResponse::utterances)).setter(ListUtteranceAnalyticsDataResponse.setter(Builder::utterances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utterances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UtteranceSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD, NEXT_TOKEN_FIELD, UTTERANCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListUtteranceAnalyticsDataResponse.memberNameToFieldInitializer();
    private final String botId;
    private final String nextToken;
    private final List<UtteranceSpecification> utterances;

    private ListUtteranceAnalyticsDataResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.nextToken = builder.nextToken;
        this.utterances = builder.utterances;
    }

    public final String botId() {
        return this.botId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasUtterances() {
        return this.utterances != null && !(this.utterances instanceof SdkAutoConstructList);
    }

    public final List<UtteranceSpecification> utterances() {
        return this.utterances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.botId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUtterances() ? this.utterances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUtteranceAnalyticsDataResponse)) {
            return false;
        }
        ListUtteranceAnalyticsDataResponse other = (ListUtteranceAnalyticsDataResponse)((Object)obj);
        return Objects.equals(this.botId(), other.botId()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasUtterances() == other.hasUtterances() && Objects.equals(this.utterances(), other.utterances());
    }

    public final String toString() {
        return ToString.builder((String)"ListUtteranceAnalyticsDataResponse").add("BotId", (Object)this.botId()).add("NextToken", (Object)this.nextToken()).add("Utterances", this.hasUtterances() ? this.utterances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "botId": {
                return Optional.ofNullable(clazz.cast(this.botId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "utterances": {
                return Optional.ofNullable(clazz.cast(this.utterances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("botId", BOT_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("utterances", UTTERANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUtteranceAnalyticsDataResponse, T> g) {
        return obj -> g.apply((ListUtteranceAnalyticsDataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private String botId;
        private String nextToken;
        private List<UtteranceSpecification> utterances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUtteranceAnalyticsDataResponse model) {
            super(model);
            this.botId(model.botId);
            this.nextToken(model.nextToken);
            this.utterances(model.utterances);
        }

        public final String getBotId() {
            return this.botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UtteranceSpecification.Builder> getUtterances() {
            List<UtteranceSpecification.Builder> result = UtteranceSpecificationsCopier.copyToBuilder(this.utterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtterances(Collection<UtteranceSpecification.BuilderImpl> utterances) {
            this.utterances = UtteranceSpecificationsCopier.copyFromBuilder(utterances);
        }

        @Override
        public final Builder utterances(Collection<UtteranceSpecification> utterances) {
            this.utterances = UtteranceSpecificationsCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceSpecification ... utterances) {
            this.utterances(Arrays.asList(utterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(Consumer<UtteranceSpecification.Builder> ... utterances) {
            this.utterances(Stream.of(utterances).map(c -> (UtteranceSpecification)((UtteranceSpecification.Builder)UtteranceSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUtteranceAnalyticsDataResponse build() {
            return new ListUtteranceAnalyticsDataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListUtteranceAnalyticsDataResponse> {
        public Builder botId(String var1);

        public Builder nextToken(String var1);

        public Builder utterances(Collection<UtteranceSpecification> var1);

        public Builder utterances(UtteranceSpecification ... var1);

        public Builder utterances(Consumer<UtteranceSpecification.Builder> ... var1);
    }
}

