/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides settings that enable advanced recognition settings for slot values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AdvancedRecognitionSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<AdvancedRecognitionSetting.Builder, AdvancedRecognitionSetting> {
    private static final SdkField<String> AUDIO_RECOGNITION_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("audioRecognitionStrategy").getter(getter(AdvancedRecognitionSetting::audioRecognitionStrategyAsString))
            .setter(setter(Builder::audioRecognitionStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioRecognitionStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(AUDIO_RECOGNITION_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String audioRecognitionStrategy;

    private AdvancedRecognitionSetting(BuilderImpl builder) {
        this.audioRecognitionStrategy = builder.audioRecognitionStrategy;
    }

    /**
     * <p>
     * Enables using the slot values as a custom vocabulary for recognizing user utterances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioRecognitionStrategy} will return {@link AudioRecognitionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #audioRecognitionStrategyAsString}.
     * </p>
     * 
     * @return Enables using the slot values as a custom vocabulary for recognizing user utterances.
     * @see AudioRecognitionStrategy
     */
    public final AudioRecognitionStrategy audioRecognitionStrategy() {
        return AudioRecognitionStrategy.fromValue(audioRecognitionStrategy);
    }

    /**
     * <p>
     * Enables using the slot values as a custom vocabulary for recognizing user utterances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #audioRecognitionStrategy} will return {@link AudioRecognitionStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #audioRecognitionStrategyAsString}.
     * </p>
     * 
     * @return Enables using the slot values as a custom vocabulary for recognizing user utterances.
     * @see AudioRecognitionStrategy
     */
    public final String audioRecognitionStrategyAsString() {
        return audioRecognitionStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(audioRecognitionStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AdvancedRecognitionSetting)) {
            return false;
        }
        AdvancedRecognitionSetting other = (AdvancedRecognitionSetting) obj;
        return Objects.equals(audioRecognitionStrategyAsString(), other.audioRecognitionStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AdvancedRecognitionSetting").add("AudioRecognitionStrategy", audioRecognitionStrategyAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "audioRecognitionStrategy":
            return Optional.ofNullable(clazz.cast(audioRecognitionStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("audioRecognitionStrategy", AUDIO_RECOGNITION_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AdvancedRecognitionSetting, T> g) {
        return obj -> g.apply((AdvancedRecognitionSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AdvancedRecognitionSetting> {
        /**
         * <p>
         * Enables using the slot values as a custom vocabulary for recognizing user utterances.
         * </p>
         * 
         * @param audioRecognitionStrategy
         *        Enables using the slot values as a custom vocabulary for recognizing user utterances.
         * @see AudioRecognitionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioRecognitionStrategy
         */
        Builder audioRecognitionStrategy(String audioRecognitionStrategy);

        /**
         * <p>
         * Enables using the slot values as a custom vocabulary for recognizing user utterances.
         * </p>
         * 
         * @param audioRecognitionStrategy
         *        Enables using the slot values as a custom vocabulary for recognizing user utterances.
         * @see AudioRecognitionStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AudioRecognitionStrategy
         */
        Builder audioRecognitionStrategy(AudioRecognitionStrategy audioRecognitionStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String audioRecognitionStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(AdvancedRecognitionSetting model) {
            audioRecognitionStrategy(model.audioRecognitionStrategy);
        }

        public final String getAudioRecognitionStrategy() {
            return audioRecognitionStrategy;
        }

        public final void setAudioRecognitionStrategy(String audioRecognitionStrategy) {
            this.audioRecognitionStrategy = audioRecognitionStrategy;
        }

        @Override
        public final Builder audioRecognitionStrategy(String audioRecognitionStrategy) {
            this.audioRecognitionStrategy = audioRecognitionStrategy;
            return this;
        }

        @Override
        public final Builder audioRecognitionStrategy(AudioRecognitionStrategy audioRecognitionStrategy) {
            this.audioRecognitionStrategy(audioRecognitionStrategy == null ? null : audioRecognitionStrategy.toString());
            return this;
        }

        @Override
        public AdvancedRecognitionSetting build() {
            return new AdvancedRecognitionSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
