/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the results for the intent stage metrics you requested and the bin and/or group they refer to,
 * if applicable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsIntentStageResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsIntentStageResult.Builder, AnalyticsIntentStageResult> {
    private static final SdkField<List<AnalyticsBinKey>> BIN_KEYS_FIELD = SdkField
            .<List<AnalyticsBinKey>> builder(MarshallingType.LIST)
            .memberName("binKeys")
            .getter(getter(AnalyticsIntentStageResult::binKeys))
            .setter(setter(Builder::binKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsBinKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsBinKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AnalyticsIntentStageGroupByKey>> GROUP_BY_KEYS_FIELD = SdkField
            .<List<AnalyticsIntentStageGroupByKey>> builder(MarshallingType.LIST)
            .memberName("groupByKeys")
            .getter(getter(AnalyticsIntentStageResult::groupByKeys))
            .setter(setter(Builder::groupByKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupByKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsIntentStageGroupByKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsIntentStageGroupByKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AnalyticsIntentStageMetricResult>> METRICS_RESULTS_FIELD = SdkField
            .<List<AnalyticsIntentStageMetricResult>> builder(MarshallingType.LIST)
            .memberName("metricsResults")
            .getter(getter(AnalyticsIntentStageResult::metricsResults))
            .setter(setter(Builder::metricsResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsIntentStageMetricResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsIntentStageMetricResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIN_KEYS_FIELD,
            GROUP_BY_KEYS_FIELD, METRICS_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AnalyticsBinKey> binKeys;

    private final List<AnalyticsIntentStageGroupByKey> groupByKeys;

    private final List<AnalyticsIntentStageMetricResult> metricsResults;

    private AnalyticsIntentStageResult(BuilderImpl builder) {
        this.binKeys = builder.binKeys;
        this.groupByKeys = builder.groupByKeys;
        this.metricsResults = builder.metricsResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the BinKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBinKeys() {
        return binKeys != null && !(binKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing the criteria you requested for binning results and the values of the bins.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBinKeys} method.
     * </p>
     * 
     * @return A list of objects containing the criteria you requested for binning results and the values of the bins.
     */
    public final List<AnalyticsBinKey> binKeys() {
        return binKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupByKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupByKeys() {
        return groupByKeys != null && !(groupByKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing the criteria you requested for grouping results and the values of the bins.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupByKeys} method.
     * </p>
     * 
     * @return A list of objects containing the criteria you requested for grouping results and the values of the bins.
     */
    public final List<AnalyticsIntentStageGroupByKey> groupByKeys() {
        return groupByKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricsResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricsResults() {
        return metricsResults != null && !(metricsResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
     * return, and the method by which to organize the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricsResults} method.
     * </p>
     * 
     * @return A list of objects, each of which contains a metric you want to list, the statistic for the metric you
     *         want to return, and the method by which to organize the results.
     */
    public final List<AnalyticsIntentStageMetricResult> metricsResults() {
        return metricsResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBinKeys() ? binKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupByKeys() ? groupByKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricsResults() ? metricsResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsIntentStageResult)) {
            return false;
        }
        AnalyticsIntentStageResult other = (AnalyticsIntentStageResult) obj;
        return hasBinKeys() == other.hasBinKeys() && Objects.equals(binKeys(), other.binKeys())
                && hasGroupByKeys() == other.hasGroupByKeys() && Objects.equals(groupByKeys(), other.groupByKeys())
                && hasMetricsResults() == other.hasMetricsResults() && Objects.equals(metricsResults(), other.metricsResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsIntentStageResult").add("BinKeys", hasBinKeys() ? binKeys() : null)
                .add("GroupByKeys", hasGroupByKeys() ? groupByKeys() : null)
                .add("MetricsResults", hasMetricsResults() ? metricsResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "binKeys":
            return Optional.ofNullable(clazz.cast(binKeys()));
        case "groupByKeys":
            return Optional.ofNullable(clazz.cast(groupByKeys()));
        case "metricsResults":
            return Optional.ofNullable(clazz.cast(metricsResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("binKeys", BIN_KEYS_FIELD);
        map.put("groupByKeys", GROUP_BY_KEYS_FIELD);
        map.put("metricsResults", METRICS_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsIntentStageResult, T> g) {
        return obj -> g.apply((AnalyticsIntentStageResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsIntentStageResult> {
        /**
         * <p>
         * A list of objects containing the criteria you requested for binning results and the values of the bins.
         * </p>
         * 
         * @param binKeys
         *        A list of objects containing the criteria you requested for binning results and the values of the
         *        bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binKeys(Collection<AnalyticsBinKey> binKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for binning results and the values of the bins.
         * </p>
         * 
         * @param binKeys
         *        A list of objects containing the criteria you requested for binning results and the values of the
         *        bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binKeys(AnalyticsBinKey... binKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for binning results and the values of the bins.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey.Builder#build()} is called
         * immediately and its result is passed to {@link #binKeys(List<AnalyticsBinKey>)}.
         * 
         * @param binKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #binKeys(java.util.Collection<AnalyticsBinKey>)
         */
        Builder binKeys(Consumer<AnalyticsBinKey.Builder>... binKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for grouping results and the values of the bins.
         * </p>
         * 
         * @param groupByKeys
         *        A list of objects containing the criteria you requested for grouping results and the values of the
         *        bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByKeys(Collection<AnalyticsIntentStageGroupByKey> groupByKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for grouping results and the values of the bins.
         * </p>
         * 
         * @param groupByKeys
         *        A list of objects containing the criteria you requested for grouping results and the values of the
         *        bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByKeys(AnalyticsIntentStageGroupByKey... groupByKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for grouping results and the values of the bins.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageGroupByKey.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageGroupByKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageGroupByKey.Builder#build()} is
         * called immediately and its result is passed to {@link #groupByKeys(List<AnalyticsIntentStageGroupByKey>)}.
         * 
         * @param groupByKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageGroupByKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupByKeys(java.util.Collection<AnalyticsIntentStageGroupByKey>)
         */
        Builder groupByKeys(Consumer<AnalyticsIntentStageGroupByKey.Builder>... groupByKeys);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the method by which to organize the results.
         * </p>
         * 
         * @param metricsResults
         *        A list of objects, each of which contains a metric you want to list, the statistic for the metric you
         *        want to return, and the method by which to organize the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsResults(Collection<AnalyticsIntentStageMetricResult> metricsResults);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the method by which to organize the results.
         * </p>
         * 
         * @param metricsResults
         *        A list of objects, each of which contains a metric you want to list, the statistic for the metric you
         *        want to return, and the method by which to organize the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsResults(AnalyticsIntentStageMetricResult... metricsResults);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the method by which to organize the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #metricsResults(List<AnalyticsIntentStageMetricResult>)}.
         * 
         * @param metricsResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsIntentStageMetricResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsResults(java.util.Collection<AnalyticsIntentStageMetricResult>)
         */
        Builder metricsResults(Consumer<AnalyticsIntentStageMetricResult.Builder>... metricsResults);
    }

    static final class BuilderImpl implements Builder {
        private List<AnalyticsBinKey> binKeys = DefaultSdkAutoConstructList.getInstance();

        private List<AnalyticsIntentStageGroupByKey> groupByKeys = DefaultSdkAutoConstructList.getInstance();

        private List<AnalyticsIntentStageMetricResult> metricsResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsIntentStageResult model) {
            binKeys(model.binKeys);
            groupByKeys(model.groupByKeys);
            metricsResults(model.metricsResults);
        }

        public final List<AnalyticsBinKey.Builder> getBinKeys() {
            List<AnalyticsBinKey.Builder> result = AnalyticsBinKeysCopier.copyToBuilder(this.binKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinKeys(Collection<AnalyticsBinKey.BuilderImpl> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copyFromBuilder(binKeys);
        }

        @Override
        public final Builder binKeys(Collection<AnalyticsBinKey> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copy(binKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(AnalyticsBinKey... binKeys) {
            binKeys(Arrays.asList(binKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(Consumer<AnalyticsBinKey.Builder>... binKeys) {
            binKeys(Stream.of(binKeys).map(c -> AnalyticsBinKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentStageGroupByKey.Builder> getGroupByKeys() {
            List<AnalyticsIntentStageGroupByKey.Builder> result = AnalyticsIntentStageGroupByKeysCopier
                    .copyToBuilder(this.groupByKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByKeys(Collection<AnalyticsIntentStageGroupByKey.BuilderImpl> groupByKeys) {
            this.groupByKeys = AnalyticsIntentStageGroupByKeysCopier.copyFromBuilder(groupByKeys);
        }

        @Override
        public final Builder groupByKeys(Collection<AnalyticsIntentStageGroupByKey> groupByKeys) {
            this.groupByKeys = AnalyticsIntentStageGroupByKeysCopier.copy(groupByKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(AnalyticsIntentStageGroupByKey... groupByKeys) {
            groupByKeys(Arrays.asList(groupByKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(Consumer<AnalyticsIntentStageGroupByKey.Builder>... groupByKeys) {
            groupByKeys(Stream.of(groupByKeys).map(c -> AnalyticsIntentStageGroupByKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsIntentStageMetricResult.Builder> getMetricsResults() {
            List<AnalyticsIntentStageMetricResult.Builder> result = AnalyticsIntentStageMetricResultsCopier
                    .copyToBuilder(this.metricsResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsResults(Collection<AnalyticsIntentStageMetricResult.BuilderImpl> metricsResults) {
            this.metricsResults = AnalyticsIntentStageMetricResultsCopier.copyFromBuilder(metricsResults);
        }

        @Override
        public final Builder metricsResults(Collection<AnalyticsIntentStageMetricResult> metricsResults) {
            this.metricsResults = AnalyticsIntentStageMetricResultsCopier.copy(metricsResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(AnalyticsIntentStageMetricResult... metricsResults) {
            metricsResults(Arrays.asList(metricsResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(Consumer<AnalyticsIntentStageMetricResult.Builder>... metricsResults) {
            metricsResults(Stream.of(metricsResults)
                    .map(c -> AnalyticsIntentStageMetricResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalyticsIntentStageResult build() {
            return new AnalyticsIntentStageResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
