/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing the results for the utterance metrics you requested and the bin and/or group(s) they refer to,
 * if applicable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyticsUtteranceResult implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyticsUtteranceResult.Builder, AnalyticsUtteranceResult> {
    private static final SdkField<List<AnalyticsBinKey>> BIN_KEYS_FIELD = SdkField
            .<List<AnalyticsBinKey>> builder(MarshallingType.LIST)
            .memberName("binKeys")
            .getter(getter(AnalyticsUtteranceResult::binKeys))
            .setter(setter(Builder::binKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("binKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsBinKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsBinKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AnalyticsUtteranceGroupByKey>> GROUP_BY_KEYS_FIELD = SdkField
            .<List<AnalyticsUtteranceGroupByKey>> builder(MarshallingType.LIST)
            .memberName("groupByKeys")
            .getter(getter(AnalyticsUtteranceResult::groupByKeys))
            .setter(setter(Builder::groupByKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupByKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsUtteranceGroupByKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsUtteranceGroupByKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AnalyticsUtteranceMetricResult>> METRICS_RESULTS_FIELD = SdkField
            .<List<AnalyticsUtteranceMetricResult>> builder(MarshallingType.LIST)
            .memberName("metricsResults")
            .getter(getter(AnalyticsUtteranceResult::metricsResults))
            .setter(setter(Builder::metricsResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metricsResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsUtteranceMetricResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsUtteranceMetricResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AnalyticsUtteranceAttributeResult>> ATTRIBUTE_RESULTS_FIELD = SdkField
            .<List<AnalyticsUtteranceAttributeResult>> builder(MarshallingType.LIST)
            .memberName("attributeResults")
            .getter(getter(AnalyticsUtteranceResult::attributeResults))
            .setter(setter(Builder::attributeResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributeResults").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalyticsUtteranceAttributeResult> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalyticsUtteranceAttributeResult::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIN_KEYS_FIELD,
            GROUP_BY_KEYS_FIELD, METRICS_RESULTS_FIELD, ATTRIBUTE_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<AnalyticsBinKey> binKeys;

    private final List<AnalyticsUtteranceGroupByKey> groupByKeys;

    private final List<AnalyticsUtteranceMetricResult> metricsResults;

    private final List<AnalyticsUtteranceAttributeResult> attributeResults;

    private AnalyticsUtteranceResult(BuilderImpl builder) {
        this.binKeys = builder.binKeys;
        this.groupByKeys = builder.groupByKeys;
        this.metricsResults = builder.metricsResults;
        this.attributeResults = builder.attributeResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the BinKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasBinKeys() {
        return binKeys != null && !(binKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing the criteria you requested for binning results and the values of the bins.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBinKeys} method.
     * </p>
     * 
     * @return A list of objects containing the criteria you requested for binning results and the values of the bins.
     */
    public final List<AnalyticsBinKey> binKeys() {
        return binKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupByKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGroupByKeys() {
        return groupByKeys != null && !(groupByKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing the criteria you requested for grouping results and the values of the bins.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupByKeys} method.
     * </p>
     * 
     * @return A list of objects containing the criteria you requested for grouping results and the values of the bins.
     */
    public final List<AnalyticsUtteranceGroupByKey> groupByKeys() {
        return groupByKeys;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricsResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricsResults() {
        return metricsResults != null && !(metricsResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
     * return, and the method by which to organize the results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricsResults} method.
     * </p>
     * 
     * @return A list of objects, each of which contains a metric you want to list, the statistic for the metric you
     *         want to return, and the method by which to organize the results.
     */
    public final List<AnalyticsUtteranceMetricResult> metricsResults() {
        return metricsResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributeResults property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributeResults() {
        return attributeResults != null && !(attributeResults instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects containing information about the last used intent at the time of an utterance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributeResults} method.
     * </p>
     * 
     * @return A list of objects containing information about the last used intent at the time of an utterance.
     */
    public final List<AnalyticsUtteranceAttributeResult> attributeResults() {
        return attributeResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasBinKeys() ? binKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupByKeys() ? groupByKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricsResults() ? metricsResults() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributeResults() ? attributeResults() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyticsUtteranceResult)) {
            return false;
        }
        AnalyticsUtteranceResult other = (AnalyticsUtteranceResult) obj;
        return hasBinKeys() == other.hasBinKeys() && Objects.equals(binKeys(), other.binKeys())
                && hasGroupByKeys() == other.hasGroupByKeys() && Objects.equals(groupByKeys(), other.groupByKeys())
                && hasMetricsResults() == other.hasMetricsResults() && Objects.equals(metricsResults(), other.metricsResults())
                && hasAttributeResults() == other.hasAttributeResults()
                && Objects.equals(attributeResults(), other.attributeResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyticsUtteranceResult").add("BinKeys", hasBinKeys() ? binKeys() : null)
                .add("GroupByKeys", hasGroupByKeys() ? groupByKeys() : null)
                .add("MetricsResults", hasMetricsResults() ? metricsResults() : null)
                .add("AttributeResults", hasAttributeResults() ? attributeResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "binKeys":
            return Optional.ofNullable(clazz.cast(binKeys()));
        case "groupByKeys":
            return Optional.ofNullable(clazz.cast(groupByKeys()));
        case "metricsResults":
            return Optional.ofNullable(clazz.cast(metricsResults()));
        case "attributeResults":
            return Optional.ofNullable(clazz.cast(attributeResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("binKeys", BIN_KEYS_FIELD);
        map.put("groupByKeys", GROUP_BY_KEYS_FIELD);
        map.put("metricsResults", METRICS_RESULTS_FIELD);
        map.put("attributeResults", ATTRIBUTE_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyticsUtteranceResult, T> g) {
        return obj -> g.apply((AnalyticsUtteranceResult) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyticsUtteranceResult> {
        /**
         * <p>
         * A list of objects containing the criteria you requested for binning results and the values of the bins.
         * </p>
         * 
         * @param binKeys
         *        A list of objects containing the criteria you requested for binning results and the values of the
         *        bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binKeys(Collection<AnalyticsBinKey> binKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for binning results and the values of the bins.
         * </p>
         * 
         * @param binKeys
         *        A list of objects containing the criteria you requested for binning results and the values of the
         *        bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder binKeys(AnalyticsBinKey... binKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for binning results and the values of the bins.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey.Builder#build()} is called
         * immediately and its result is passed to {@link #binKeys(List<AnalyticsBinKey>)}.
         * 
         * @param binKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsBinKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #binKeys(java.util.Collection<AnalyticsBinKey>)
         */
        Builder binKeys(Consumer<AnalyticsBinKey.Builder>... binKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for grouping results and the values of the bins.
         * </p>
         * 
         * @param groupByKeys
         *        A list of objects containing the criteria you requested for grouping results and the values of the
         *        bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByKeys(Collection<AnalyticsUtteranceGroupByKey> groupByKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for grouping results and the values of the bins.
         * </p>
         * 
         * @param groupByKeys
         *        A list of objects containing the criteria you requested for grouping results and the values of the
         *        bins.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByKeys(AnalyticsUtteranceGroupByKey... groupByKeys);

        /**
         * <p>
         * A list of objects containing the criteria you requested for grouping results and the values of the bins.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.Builder#build()} is
         * called immediately and its result is passed to {@link #groupByKeys(List<AnalyticsUtteranceGroupByKey>)}.
         * 
         * @param groupByKeys
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceGroupByKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #groupByKeys(java.util.Collection<AnalyticsUtteranceGroupByKey>)
         */
        Builder groupByKeys(Consumer<AnalyticsUtteranceGroupByKey.Builder>... groupByKeys);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the method by which to organize the results.
         * </p>
         * 
         * @param metricsResults
         *        A list of objects, each of which contains a metric you want to list, the statistic for the metric you
         *        want to return, and the method by which to organize the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsResults(Collection<AnalyticsUtteranceMetricResult> metricsResults);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the method by which to organize the results.
         * </p>
         * 
         * @param metricsResults
         *        A list of objects, each of which contains a metric you want to list, the statistic for the metric you
         *        want to return, and the method by which to organize the results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricsResults(AnalyticsUtteranceMetricResult... metricsResults);

        /**
         * <p>
         * A list of objects, each of which contains a metric you want to list, the statistic for the metric you want to
         * return, and the method by which to organize the results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult.Builder#build()} is
         * called immediately and its result is passed to {@link #metricsResults(List<AnalyticsUtteranceMetricResult>)}.
         * 
         * @param metricsResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceMetricResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metricsResults(java.util.Collection<AnalyticsUtteranceMetricResult>)
         */
        Builder metricsResults(Consumer<AnalyticsUtteranceMetricResult.Builder>... metricsResults);

        /**
         * <p>
         * A list of objects containing information about the last used intent at the time of an utterance.
         * </p>
         * 
         * @param attributeResults
         *        A list of objects containing information about the last used intent at the time of an utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeResults(Collection<AnalyticsUtteranceAttributeResult> attributeResults);

        /**
         * <p>
         * A list of objects containing information about the last used intent at the time of an utterance.
         * </p>
         * 
         * @param attributeResults
         *        A list of objects containing information about the last used intent at the time of an utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributeResults(AnalyticsUtteranceAttributeResult... attributeResults);

        /**
         * <p>
         * A list of objects containing information about the last used intent at the time of an utterance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #attributeResults(List<AnalyticsUtteranceAttributeResult>)}.
         * 
         * @param attributeResults
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.AnalyticsUtteranceAttributeResult.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributeResults(java.util.Collection<AnalyticsUtteranceAttributeResult>)
         */
        Builder attributeResults(Consumer<AnalyticsUtteranceAttributeResult.Builder>... attributeResults);
    }

    static final class BuilderImpl implements Builder {
        private List<AnalyticsBinKey> binKeys = DefaultSdkAutoConstructList.getInstance();

        private List<AnalyticsUtteranceGroupByKey> groupByKeys = DefaultSdkAutoConstructList.getInstance();

        private List<AnalyticsUtteranceMetricResult> metricsResults = DefaultSdkAutoConstructList.getInstance();

        private List<AnalyticsUtteranceAttributeResult> attributeResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyticsUtteranceResult model) {
            binKeys(model.binKeys);
            groupByKeys(model.groupByKeys);
            metricsResults(model.metricsResults);
            attributeResults(model.attributeResults);
        }

        public final List<AnalyticsBinKey.Builder> getBinKeys() {
            List<AnalyticsBinKey.Builder> result = AnalyticsBinKeysCopier.copyToBuilder(this.binKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBinKeys(Collection<AnalyticsBinKey.BuilderImpl> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copyFromBuilder(binKeys);
        }

        @Override
        public final Builder binKeys(Collection<AnalyticsBinKey> binKeys) {
            this.binKeys = AnalyticsBinKeysCopier.copy(binKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(AnalyticsBinKey... binKeys) {
            binKeys(Arrays.asList(binKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder binKeys(Consumer<AnalyticsBinKey.Builder>... binKeys) {
            binKeys(Stream.of(binKeys).map(c -> AnalyticsBinKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsUtteranceGroupByKey.Builder> getGroupByKeys() {
            List<AnalyticsUtteranceGroupByKey.Builder> result = AnalyticsUtteranceGroupByKeysCopier
                    .copyToBuilder(this.groupByKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByKeys(Collection<AnalyticsUtteranceGroupByKey.BuilderImpl> groupByKeys) {
            this.groupByKeys = AnalyticsUtteranceGroupByKeysCopier.copyFromBuilder(groupByKeys);
        }

        @Override
        public final Builder groupByKeys(Collection<AnalyticsUtteranceGroupByKey> groupByKeys) {
            this.groupByKeys = AnalyticsUtteranceGroupByKeysCopier.copy(groupByKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(AnalyticsUtteranceGroupByKey... groupByKeys) {
            groupByKeys(Arrays.asList(groupByKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByKeys(Consumer<AnalyticsUtteranceGroupByKey.Builder>... groupByKeys) {
            groupByKeys(Stream.of(groupByKeys).map(c -> AnalyticsUtteranceGroupByKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsUtteranceMetricResult.Builder> getMetricsResults() {
            List<AnalyticsUtteranceMetricResult.Builder> result = AnalyticsUtteranceMetricResultsCopier
                    .copyToBuilder(this.metricsResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetricsResults(Collection<AnalyticsUtteranceMetricResult.BuilderImpl> metricsResults) {
            this.metricsResults = AnalyticsUtteranceMetricResultsCopier.copyFromBuilder(metricsResults);
        }

        @Override
        public final Builder metricsResults(Collection<AnalyticsUtteranceMetricResult> metricsResults) {
            this.metricsResults = AnalyticsUtteranceMetricResultsCopier.copy(metricsResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(AnalyticsUtteranceMetricResult... metricsResults) {
            metricsResults(Arrays.asList(metricsResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricsResults(Consumer<AnalyticsUtteranceMetricResult.Builder>... metricsResults) {
            metricsResults(Stream.of(metricsResults).map(c -> AnalyticsUtteranceMetricResult.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AnalyticsUtteranceAttributeResult.Builder> getAttributeResults() {
            List<AnalyticsUtteranceAttributeResult.Builder> result = AnalyticsUtteranceAttributeResultsCopier
                    .copyToBuilder(this.attributeResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributeResults(Collection<AnalyticsUtteranceAttributeResult.BuilderImpl> attributeResults) {
            this.attributeResults = AnalyticsUtteranceAttributeResultsCopier.copyFromBuilder(attributeResults);
        }

        @Override
        public final Builder attributeResults(Collection<AnalyticsUtteranceAttributeResult> attributeResults) {
            this.attributeResults = AnalyticsUtteranceAttributeResultsCopier.copy(attributeResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeResults(AnalyticsUtteranceAttributeResult... attributeResults) {
            attributeResults(Arrays.asList(attributeResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributeResults(Consumer<AnalyticsUtteranceAttributeResult.Builder>... attributeResults) {
            attributeResults(Stream.of(attributeResults)
                    .map(c -> AnalyticsUtteranceAttributeResult.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalyticsUtteranceResult build() {
            return new AnalyticsUtteranceResult(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
