/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchUpdateCustomVocabularyItemResponse extends LexModelsV2Response implements
        ToCopyableBuilder<BatchUpdateCustomVocabularyItemResponse.Builder, BatchUpdateCustomVocabularyItemResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(BatchUpdateCustomVocabularyItemResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(BatchUpdateCustomVocabularyItemResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(BatchUpdateCustomVocabularyItemResponse::localeId))
            .setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<List<FailedCustomVocabularyItem>> ERRORS_FIELD = SdkField
            .<List<FailedCustomVocabularyItem>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(BatchUpdateCustomVocabularyItemResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FailedCustomVocabularyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(FailedCustomVocabularyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CustomVocabularyItem>> RESOURCES_FIELD = SdkField
            .<List<CustomVocabularyItem>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(BatchUpdateCustomVocabularyItemResponse::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomVocabularyItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomVocabularyItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, ERRORS_FIELD, RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final List<FailedCustomVocabularyItem> errors;

    private final List<CustomVocabularyItem> resources;

    private BatchUpdateCustomVocabularyItemResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.errors = builder.errors;
        this.resources = builder.resources;
    }

    /**
     * <p>
     * The identifier of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the bot associated with this custom vocabulary.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The identifier of the version of the bot associated with this custom vocabulary.
     * </p>
     * 
     * @return The identifier of the version of the bot associated with this custom vocabulary.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale where this custom vocabulary is used. The string must match one of the
     * supported locales. For more information, see <a
     * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     * </p>
     * 
     * @return The identifier of the language and locale where this custom vocabulary is used. The string must match one
     *         of the supported locales. For more information, see <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom vocabulary items that failed to update during the operation. The reason for the error is
     * contained within each error object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return A list of custom vocabulary items that failed to update during the operation. The reason for the error is
     *         contained within each error object.
     */
    public final List<FailedCustomVocabularyItem> errors() {
        return errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of custom vocabulary items that were successfully updated during the operation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return A list of custom vocabulary items that were successfully updated during the operation.
     */
    public final List<CustomVocabularyItem> resources() {
        return resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchUpdateCustomVocabularyItemResponse)) {
            return false;
        }
        BatchUpdateCustomVocabularyItemResponse other = (BatchUpdateCustomVocabularyItemResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId()) && hasErrors() == other.hasErrors()
                && Objects.equals(errors(), other.errors()) && hasResources() == other.hasResources()
                && Objects.equals(resources(), other.resources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchUpdateCustomVocabularyItemResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId()).add("Errors", hasErrors() ? errors() : null)
                .add("Resources", hasResources() ? resources() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("errors", ERRORS_FIELD);
        map.put("resources", RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchUpdateCustomVocabularyItemResponse, T> g) {
        return obj -> g.apply((BatchUpdateCustomVocabularyItemResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchUpdateCustomVocabularyItemResponse> {
        /**
         * <p>
         * The identifier of the bot associated with this custom vocabulary.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot associated with this custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The identifier of the version of the bot associated with this custom vocabulary.
         * </p>
         * 
         * @param botVersion
         *        The identifier of the version of the bot associated with this custom vocabulary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale where this custom vocabulary is used. The string must match one of
         * the supported locales. For more information, see <a
         * href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale where this custom vocabulary is used. The string must match
         *        one of the supported locales. For more information, see <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/dg/how-languages.html"> Supported Languages </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * A list of custom vocabulary items that failed to update during the operation. The reason for the error is
         * contained within each error object.
         * </p>
         * 
         * @param errors
         *        A list of custom vocabulary items that failed to update during the operation. The reason for the error
         *        is contained within each error object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<FailedCustomVocabularyItem> errors);

        /**
         * <p>
         * A list of custom vocabulary items that failed to update during the operation. The reason for the error is
         * contained within each error object.
         * </p>
         * 
         * @param errors
         *        A list of custom vocabulary items that failed to update during the operation. The reason for the error
         *        is contained within each error object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(FailedCustomVocabularyItem... errors);

        /**
         * <p>
         * A list of custom vocabulary items that failed to update during the operation. The reason for the error is
         * contained within each error object.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem.Builder#build()} is
         * called immediately and its result is passed to {@link #errors(List<FailedCustomVocabularyItem>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.FailedCustomVocabularyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<FailedCustomVocabularyItem>)
         */
        Builder errors(Consumer<FailedCustomVocabularyItem.Builder>... errors);

        /**
         * <p>
         * A list of custom vocabulary items that were successfully updated during the operation.
         * </p>
         * 
         * @param resources
         *        A list of custom vocabulary items that were successfully updated during the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<CustomVocabularyItem> resources);

        /**
         * <p>
         * A list of custom vocabulary items that were successfully updated during the operation.
         * </p>
         * 
         * @param resources
         *        A list of custom vocabulary items that were successfully updated during the operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(CustomVocabularyItem... resources);

        /**
         * <p>
         * A list of custom vocabulary items that were successfully updated during the operation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem.Builder#build()} is called
         * immediately and its result is passed to {@link #resources(List<CustomVocabularyItem>)}.
         * 
         * @param resources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.CustomVocabularyItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resources(java.util.Collection<CustomVocabularyItem>)
         */
        Builder resources(Consumer<CustomVocabularyItem.Builder>... resources);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private List<FailedCustomVocabularyItem> errors = DefaultSdkAutoConstructList.getInstance();

        private List<CustomVocabularyItem> resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchUpdateCustomVocabularyItemResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            errors(model.errors);
            resources(model.resources);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<FailedCustomVocabularyItem.Builder> getErrors() {
            List<FailedCustomVocabularyItem.Builder> result = FailedCustomVocabularyItemsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<FailedCustomVocabularyItem.BuilderImpl> errors) {
            this.errors = FailedCustomVocabularyItemsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<FailedCustomVocabularyItem> errors) {
            this.errors = FailedCustomVocabularyItemsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(FailedCustomVocabularyItem... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<FailedCustomVocabularyItem.Builder>... errors) {
            errors(Stream.of(errors).map(c -> FailedCustomVocabularyItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CustomVocabularyItem.Builder> getResources() {
            List<CustomVocabularyItem.Builder> result = CustomVocabularyItemsCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<CustomVocabularyItem.BuilderImpl> resources) {
            this.resources = CustomVocabularyItemsCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<CustomVocabularyItem> resources) {
            this.resources = CustomVocabularyItemsCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(CustomVocabularyItem... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<CustomVocabularyItem.Builder>... resources) {
            resources(Stream.of(resources).map(c -> CustomVocabularyItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchUpdateCustomVocabularyItemResponse build() {
            return new BatchUpdateCustomVocabularyItemResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
