/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the Amazon Bedrock model used to interpret the prompt used in descriptive bot building.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockModelSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockModelSpecification.Builder, BedrockModelSpecification> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(BedrockModelSpecification::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<BedrockGuardrailConfiguration> GUARDRAIL_FIELD = SdkField
            .<BedrockGuardrailConfiguration> builder(MarshallingType.SDK_POJO).memberName("guardrail")
            .getter(getter(BedrockModelSpecification::guardrail)).setter(setter(Builder::guardrail))
            .constructor(BedrockGuardrailConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrail").build()).build();

    private static final SdkField<String> TRACE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceStatus").getter(getter(BedrockModelSpecification::traceStatusAsString))
            .setter(setter(Builder::traceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceStatus").build()).build();

    private static final SdkField<String> CUSTOM_PROMPT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customPrompt").getter(getter(BedrockModelSpecification::customPrompt))
            .setter(setter(Builder::customPrompt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customPrompt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            GUARDRAIL_FIELD, TRACE_STATUS_FIELD, CUSTOM_PROMPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelArn;

    private final BedrockGuardrailConfiguration guardrail;

    private final String traceStatus;

    private final String customPrompt;

    private BedrockModelSpecification(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.guardrail = builder.guardrail;
        this.traceStatus = builder.traceStatus;
        this.customPrompt = builder.customPrompt;
    }

    /**
     * <p>
     * The ARN of the foundation model used in descriptive bot building.
     * </p>
     * 
     * @return The ARN of the foundation model used in descriptive bot building.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * The guardrail configuration in the Bedrock model specification details.
     * </p>
     * 
     * @return The guardrail configuration in the Bedrock model specification details.
     */
    public final BedrockGuardrailConfiguration guardrail() {
        return guardrail;
    }

    /**
     * <p>
     * The Bedrock trace status in the Bedrock model specification details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #traceStatus} will
     * return {@link BedrockTraceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceStatusAsString}.
     * </p>
     * 
     * @return The Bedrock trace status in the Bedrock model specification details.
     * @see BedrockTraceStatus
     */
    public final BedrockTraceStatus traceStatus() {
        return BedrockTraceStatus.fromValue(traceStatus);
    }

    /**
     * <p>
     * The Bedrock trace status in the Bedrock model specification details.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #traceStatus} will
     * return {@link BedrockTraceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #traceStatusAsString}.
     * </p>
     * 
     * @return The Bedrock trace status in the Bedrock model specification details.
     * @see BedrockTraceStatus
     */
    public final String traceStatusAsString() {
        return traceStatus;
    }

    /**
     * <p>
     * The custom prompt used in the Bedrock model specification details.
     * </p>
     * 
     * @return The custom prompt used in the Bedrock model specification details.
     */
    public final String customPrompt() {
        return customPrompt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(guardrail());
        hashCode = 31 * hashCode + Objects.hashCode(traceStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(customPrompt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockModelSpecification)) {
            return false;
        }
        BedrockModelSpecification other = (BedrockModelSpecification) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(guardrail(), other.guardrail())
                && Objects.equals(traceStatusAsString(), other.traceStatusAsString())
                && Objects.equals(customPrompt(), other.customPrompt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockModelSpecification").add("ModelArn", modelArn()).add("Guardrail", guardrail())
                .add("TraceStatus", traceStatusAsString()).add("CustomPrompt", customPrompt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "guardrail":
            return Optional.ofNullable(clazz.cast(guardrail()));
        case "traceStatus":
            return Optional.ofNullable(clazz.cast(traceStatusAsString()));
        case "customPrompt":
            return Optional.ofNullable(clazz.cast(customPrompt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("guardrail", GUARDRAIL_FIELD);
        map.put("traceStatus", TRACE_STATUS_FIELD);
        map.put("customPrompt", CUSTOM_PROMPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockModelSpecification, T> g) {
        return obj -> g.apply((BedrockModelSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockModelSpecification> {
        /**
         * <p>
         * The ARN of the foundation model used in descriptive bot building.
         * </p>
         * 
         * @param modelArn
         *        The ARN of the foundation model used in descriptive bot building.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * The guardrail configuration in the Bedrock model specification details.
         * </p>
         * 
         * @param guardrail
         *        The guardrail configuration in the Bedrock model specification details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardrail(BedrockGuardrailConfiguration guardrail);

        /**
         * <p>
         * The guardrail configuration in the Bedrock model specification details.
         * </p>
         * This is a convenience method that creates an instance of the {@link BedrockGuardrailConfiguration.Builder}
         * avoiding the need to create one manually via {@link BedrockGuardrailConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockGuardrailConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #guardrail(BedrockGuardrailConfiguration)}.
         * 
         * @param guardrail
         *        a consumer that will call methods on {@link BedrockGuardrailConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #guardrail(BedrockGuardrailConfiguration)
         */
        default Builder guardrail(Consumer<BedrockGuardrailConfiguration.Builder> guardrail) {
            return guardrail(BedrockGuardrailConfiguration.builder().applyMutation(guardrail).build());
        }

        /**
         * <p>
         * The Bedrock trace status in the Bedrock model specification details.
         * </p>
         * 
         * @param traceStatus
         *        The Bedrock trace status in the Bedrock model specification details.
         * @see BedrockTraceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BedrockTraceStatus
         */
        Builder traceStatus(String traceStatus);

        /**
         * <p>
         * The Bedrock trace status in the Bedrock model specification details.
         * </p>
         * 
         * @param traceStatus
         *        The Bedrock trace status in the Bedrock model specification details.
         * @see BedrockTraceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BedrockTraceStatus
         */
        Builder traceStatus(BedrockTraceStatus traceStatus);

        /**
         * <p>
         * The custom prompt used in the Bedrock model specification details.
         * </p>
         * 
         * @param customPrompt
         *        The custom prompt used in the Bedrock model specification details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customPrompt(String customPrompt);
    }

    static final class BuilderImpl implements Builder {
        private String modelArn;

        private BedrockGuardrailConfiguration guardrail;

        private String traceStatus;

        private String customPrompt;

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockModelSpecification model) {
            modelArn(model.modelArn);
            guardrail(model.guardrail);
            traceStatus(model.traceStatus);
            customPrompt(model.customPrompt);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final BedrockGuardrailConfiguration.Builder getGuardrail() {
            return guardrail != null ? guardrail.toBuilder() : null;
        }

        public final void setGuardrail(BedrockGuardrailConfiguration.BuilderImpl guardrail) {
            this.guardrail = guardrail != null ? guardrail.build() : null;
        }

        @Override
        public final Builder guardrail(BedrockGuardrailConfiguration guardrail) {
            this.guardrail = guardrail;
            return this;
        }

        public final String getTraceStatus() {
            return traceStatus;
        }

        public final void setTraceStatus(String traceStatus) {
            this.traceStatus = traceStatus;
        }

        @Override
        public final Builder traceStatus(String traceStatus) {
            this.traceStatus = traceStatus;
            return this;
        }

        @Override
        public final Builder traceStatus(BedrockTraceStatus traceStatus) {
            this.traceStatus(traceStatus == null ? null : traceStatus.toString());
            return this;
        }

        public final String getCustomPrompt() {
            return customPrompt;
        }

        public final void setCustomPrompt(String customPrompt) {
            this.customPrompt = customPrompt;
        }

        @Override
        public final Builder customPrompt(String customPrompt) {
            this.customPrompt = customPrompt;
            return this;
        }

        @Override
        public BedrockModelSpecification build() {
            return new BedrockModelSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
