/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A bot that is a member of a network of bots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotMember implements SdkPojo, Serializable, ToCopyableBuilder<BotMember.Builder, BotMember> {
    private static final SdkField<String> BOT_MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botMemberId").getter(getter(BotMember::botMemberId)).setter(setter(Builder::botMemberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMemberId").build()).build();

    private static final SdkField<String> BOT_MEMBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botMemberName").getter(getter(BotMember::botMemberName)).setter(setter(Builder::botMemberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMemberName").build()).build();

    private static final SdkField<String> BOT_MEMBER_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botMemberAliasId").getter(getter(BotMember::botMemberAliasId)).setter(setter(Builder::botMemberAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMemberAliasId").build()).build();

    private static final SdkField<String> BOT_MEMBER_ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botMemberAliasName").getter(getter(BotMember::botMemberAliasName))
            .setter(setter(Builder::botMemberAliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMemberAliasName").build())
            .build();

    private static final SdkField<String> BOT_MEMBER_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botMemberVersion").getter(getter(BotMember::botMemberVersion)).setter(setter(Builder::botMemberVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botMemberVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_MEMBER_ID_FIELD,
            BOT_MEMBER_NAME_FIELD, BOT_MEMBER_ALIAS_ID_FIELD, BOT_MEMBER_ALIAS_NAME_FIELD, BOT_MEMBER_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String botMemberId;

    private final String botMemberName;

    private final String botMemberAliasId;

    private final String botMemberAliasName;

    private final String botMemberVersion;

    private BotMember(BuilderImpl builder) {
        this.botMemberId = builder.botMemberId;
        this.botMemberName = builder.botMemberName;
        this.botMemberAliasId = builder.botMemberAliasId;
        this.botMemberAliasName = builder.botMemberAliasName;
        this.botMemberVersion = builder.botMemberVersion;
    }

    /**
     * <p>
     * The unique ID of a bot that is a member of this network of bots.
     * </p>
     * 
     * @return The unique ID of a bot that is a member of this network of bots.
     */
    public final String botMemberId() {
        return botMemberId;
    }

    /**
     * <p>
     * The unique name of a bot that is a member of this network of bots.
     * </p>
     * 
     * @return The unique name of a bot that is a member of this network of bots.
     */
    public final String botMemberName() {
        return botMemberName;
    }

    /**
     * <p>
     * The alias ID of a bot that is a member of this network of bots.
     * </p>
     * 
     * @return The alias ID of a bot that is a member of this network of bots.
     */
    public final String botMemberAliasId() {
        return botMemberAliasId;
    }

    /**
     * <p>
     * The alias name of a bot that is a member of this network of bots.
     * </p>
     * 
     * @return The alias name of a bot that is a member of this network of bots.
     */
    public final String botMemberAliasName() {
        return botMemberAliasName;
    }

    /**
     * <p>
     * The version of a bot that is a member of this network of bots.
     * </p>
     * 
     * @return The version of a bot that is a member of this network of bots.
     */
    public final String botMemberVersion() {
        return botMemberVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botMemberId());
        hashCode = 31 * hashCode + Objects.hashCode(botMemberName());
        hashCode = 31 * hashCode + Objects.hashCode(botMemberAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(botMemberAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(botMemberVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotMember)) {
            return false;
        }
        BotMember other = (BotMember) obj;
        return Objects.equals(botMemberId(), other.botMemberId()) && Objects.equals(botMemberName(), other.botMemberName())
                && Objects.equals(botMemberAliasId(), other.botMemberAliasId())
                && Objects.equals(botMemberAliasName(), other.botMemberAliasName())
                && Objects.equals(botMemberVersion(), other.botMemberVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotMember").add("BotMemberId", botMemberId()).add("BotMemberName", botMemberName())
                .add("BotMemberAliasId", botMemberAliasId()).add("BotMemberAliasName", botMemberAliasName())
                .add("BotMemberVersion", botMemberVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botMemberId":
            return Optional.ofNullable(clazz.cast(botMemberId()));
        case "botMemberName":
            return Optional.ofNullable(clazz.cast(botMemberName()));
        case "botMemberAliasId":
            return Optional.ofNullable(clazz.cast(botMemberAliasId()));
        case "botMemberAliasName":
            return Optional.ofNullable(clazz.cast(botMemberAliasName()));
        case "botMemberVersion":
            return Optional.ofNullable(clazz.cast(botMemberVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botMemberId", BOT_MEMBER_ID_FIELD);
        map.put("botMemberName", BOT_MEMBER_NAME_FIELD);
        map.put("botMemberAliasId", BOT_MEMBER_ALIAS_ID_FIELD);
        map.put("botMemberAliasName", BOT_MEMBER_ALIAS_NAME_FIELD);
        map.put("botMemberVersion", BOT_MEMBER_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotMember, T> g) {
        return obj -> g.apply((BotMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotMember> {
        /**
         * <p>
         * The unique ID of a bot that is a member of this network of bots.
         * </p>
         * 
         * @param botMemberId
         *        The unique ID of a bot that is a member of this network of bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMemberId(String botMemberId);

        /**
         * <p>
         * The unique name of a bot that is a member of this network of bots.
         * </p>
         * 
         * @param botMemberName
         *        The unique name of a bot that is a member of this network of bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMemberName(String botMemberName);

        /**
         * <p>
         * The alias ID of a bot that is a member of this network of bots.
         * </p>
         * 
         * @param botMemberAliasId
         *        The alias ID of a bot that is a member of this network of bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMemberAliasId(String botMemberAliasId);

        /**
         * <p>
         * The alias name of a bot that is a member of this network of bots.
         * </p>
         * 
         * @param botMemberAliasName
         *        The alias name of a bot that is a member of this network of bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMemberAliasName(String botMemberAliasName);

        /**
         * <p>
         * The version of a bot that is a member of this network of bots.
         * </p>
         * 
         * @param botMemberVersion
         *        The version of a bot that is a member of this network of bots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botMemberVersion(String botMemberVersion);
    }

    static final class BuilderImpl implements Builder {
        private String botMemberId;

        private String botMemberName;

        private String botMemberAliasId;

        private String botMemberAliasName;

        private String botMemberVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(BotMember model) {
            botMemberId(model.botMemberId);
            botMemberName(model.botMemberName);
            botMemberAliasId(model.botMemberAliasId);
            botMemberAliasName(model.botMemberAliasName);
            botMemberVersion(model.botMemberVersion);
        }

        public final String getBotMemberId() {
            return botMemberId;
        }

        public final void setBotMemberId(String botMemberId) {
            this.botMemberId = botMemberId;
        }

        @Override
        public final Builder botMemberId(String botMemberId) {
            this.botMemberId = botMemberId;
            return this;
        }

        public final String getBotMemberName() {
            return botMemberName;
        }

        public final void setBotMemberName(String botMemberName) {
            this.botMemberName = botMemberName;
        }

        @Override
        public final Builder botMemberName(String botMemberName) {
            this.botMemberName = botMemberName;
            return this;
        }

        public final String getBotMemberAliasId() {
            return botMemberAliasId;
        }

        public final void setBotMemberAliasId(String botMemberAliasId) {
            this.botMemberAliasId = botMemberAliasId;
        }

        @Override
        public final Builder botMemberAliasId(String botMemberAliasId) {
            this.botMemberAliasId = botMemberAliasId;
            return this;
        }

        public final String getBotMemberAliasName() {
            return botMemberAliasName;
        }

        public final void setBotMemberAliasName(String botMemberAliasName) {
            this.botMemberAliasName = botMemberAliasName;
        }

        @Override
        public final Builder botMemberAliasName(String botMemberAliasName) {
            this.botMemberAliasName = botMemberAliasName;
            return this;
        }

        public final String getBotMemberVersion() {
            return botMemberVersion;
        }

        public final void setBotMemberVersion(String botMemberVersion) {
            this.botMemberVersion = botMemberVersion;
        }

        @Override
        public final Builder botMemberVersion(String botMemberVersion) {
            this.botMemberVersion = botMemberVersion;
            return this;
        }

        @Override
        public BotMember build() {
            return new BotMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
