/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a bot version returned by the <a
 * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_ListBotVersions.html">ListBotVersions</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BotVersionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BotVersionSummary.Builder, BotVersionSummary> {
    private static final SdkField<String> BOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botName").getter(getter(BotVersionSummary::botName)).setter(setter(Builder::botName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botName").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(BotVersionSummary::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(BotVersionSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botStatus").getter(getter(BotVersionSummary::botStatusAsString)).setter(setter(Builder::botStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(BotVersionSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_NAME_FIELD,
            BOT_VERSION_FIELD, DESCRIPTION_FIELD, BOT_STATUS_FIELD, CREATION_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String botName;

    private final String botVersion;

    private final String description;

    private final String botStatus;

    private final Instant creationDateTime;

    private BotVersionSummary(BuilderImpl builder) {
        this.botName = builder.botName;
        this.botVersion = builder.botVersion;
        this.description = builder.description;
        this.botStatus = builder.botStatus;
        this.creationDateTime = builder.creationDateTime;
    }

    /**
     * <p>
     * The name of the bot associated with the version.
     * </p>
     * 
     * @return The name of the bot associated with the version.
     */
    public final String botName() {
        return botName;
    }

    /**
     * <p>
     * The numeric version of the bot, or <code>DRAFT</code> to indicate that this is the version of the bot that can be
     * updated..
     * </p>
     * 
     * @return The numeric version of the bot, or <code>DRAFT</code> to indicate that this is the version of the bot
     *         that can be updated..
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The description of the version.
     * </p>
     * 
     * @return The description of the version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The status of the bot. When the status is available, the version of the bot is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The status of the bot. When the status is available, the version of the bot is ready for use.
     * @see BotStatus
     */
    public final BotStatus botStatus() {
        return BotStatus.fromValue(botStatus);
    }

    /**
     * <p>
     * The status of the bot. When the status is available, the version of the bot is ready for use.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The status of the bot. When the status is available, the version of the bot is ready for use.
     * @see BotStatus
     */
    public final String botStatusAsString() {
        return botStatus;
    }

    /**
     * <p>
     * A timestamp of the date and time that the version was created.
     * </p>
     * 
     * @return A timestamp of the date and time that the version was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botName());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(botStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BotVersionSummary)) {
            return false;
        }
        BotVersionSummary other = (BotVersionSummary) obj;
        return Objects.equals(botName(), other.botName()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(description(), other.description())
                && Objects.equals(botStatusAsString(), other.botStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BotVersionSummary").add("BotName", botName()).add("BotVersion", botVersion())
                .add("Description", description()).add("BotStatus", botStatusAsString())
                .add("CreationDateTime", creationDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botName":
            return Optional.ofNullable(clazz.cast(botName()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botStatus":
            return Optional.ofNullable(clazz.cast(botStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botName", BOT_NAME_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("botStatus", BOT_STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BotVersionSummary, T> g) {
        return obj -> g.apply((BotVersionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BotVersionSummary> {
        /**
         * <p>
         * The name of the bot associated with the version.
         * </p>
         * 
         * @param botName
         *        The name of the bot associated with the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botName(String botName);

        /**
         * <p>
         * The numeric version of the bot, or <code>DRAFT</code> to indicate that this is the version of the bot that
         * can be updated..
         * </p>
         * 
         * @param botVersion
         *        The numeric version of the bot, or <code>DRAFT</code> to indicate that this is the version of the bot
         *        that can be updated..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The description of the version.
         * </p>
         * 
         * @param description
         *        The description of the version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the bot. When the status is available, the version of the bot is ready for use.
         * </p>
         * 
         * @param botStatus
         *        The status of the bot. When the status is available, the version of the bot is ready for use.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(String botStatus);

        /**
         * <p>
         * The status of the bot. When the status is available, the version of the bot is ready for use.
         * </p>
         * 
         * @param botStatus
         *        The status of the bot. When the status is available, the version of the bot is ready for use.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(BotStatus botStatus);

        /**
         * <p>
         * A timestamp of the date and time that the version was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp of the date and time that the version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String botName;

        private String botVersion;

        private String description;

        private String botStatus;

        private Instant creationDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BotVersionSummary model) {
            botName(model.botName);
            botVersion(model.botVersion);
            description(model.description);
            botStatus(model.botStatus);
            creationDateTime(model.creationDateTime);
        }

        public final String getBotName() {
            return botName;
        }

        public final void setBotName(String botName) {
            this.botName = botName;
        }

        @Override
        public final Builder botName(String botName) {
            this.botName = botName;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getBotStatus() {
            return botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        @Override
        public BotVersionSummary build() {
            return new BotVersionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
