/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotLocaleResponse extends LexModelsV2Response implements
        ToCopyableBuilder<CreateBotLocaleResponse.Builder, CreateBotLocaleResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateBotLocaleResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(CreateBotLocaleResponse::botVersion)).setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeName").getter(getter(CreateBotLocaleResponse::localeName)).setter(setter(Builder::localeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeName").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(CreateBotLocaleResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBotLocaleResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Double> NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("nluIntentConfidenceThreshold")
            .getter(getter(CreateBotLocaleResponse::nluIntentConfidenceThreshold))
            .setter(setter(Builder::nluIntentConfidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nluIntentConfidenceThreshold")
                    .build()).build();

    private static final SdkField<VoiceSettings> VOICE_SETTINGS_FIELD = SdkField
            .<VoiceSettings> builder(MarshallingType.SDK_POJO).memberName("voiceSettings")
            .getter(getter(CreateBotLocaleResponse::voiceSettings)).setter(setter(Builder::voiceSettings))
            .constructor(VoiceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voiceSettings").build()).build();

    private static final SdkField<String> BOT_LOCALE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botLocaleStatus").getter(getter(CreateBotLocaleResponse::botLocaleStatusAsString))
            .setter(setter(Builder::botLocaleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(CreateBotLocaleResponse::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<GenerativeAISettings> GENERATIVE_AI_SETTINGS_FIELD = SdkField
            .<GenerativeAISettings> builder(MarshallingType.SDK_POJO).memberName("generativeAISettings")
            .getter(getter(CreateBotLocaleResponse::generativeAISettings)).setter(setter(Builder::generativeAISettings))
            .constructor(GenerativeAISettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeAISettings").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_NAME_FIELD, LOCALE_ID_FIELD, DESCRIPTION_FIELD, NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD,
            VOICE_SETTINGS_FIELD, BOT_LOCALE_STATUS_FIELD, CREATION_DATE_TIME_FIELD, GENERATIVE_AI_SETTINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeName;

    private final String localeId;

    private final String description;

    private final Double nluIntentConfidenceThreshold;

    private final VoiceSettings voiceSettings;

    private final String botLocaleStatus;

    private final Instant creationDateTime;

    private final GenerativeAISettings generativeAISettings;

    private CreateBotLocaleResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeName = builder.localeName;
        this.localeId = builder.localeId;
        this.description = builder.description;
        this.nluIntentConfidenceThreshold = builder.nluIntentConfidenceThreshold;
        this.voiceSettings = builder.voiceSettings;
        this.botLocaleStatus = builder.botLocaleStatus;
        this.creationDateTime = builder.creationDateTime;
        this.generativeAISettings = builder.generativeAISettings;
    }

    /**
     * <p>
     * The specified bot identifier.
     * </p>
     * 
     * @return The specified bot identifier.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The specified bot version.
     * </p>
     * 
     * @return The specified bot version.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The specified locale name.
     * </p>
     * 
     * @return The specified locale name.
     */
    public final String localeName() {
        return localeName;
    }

    /**
     * <p>
     * The specified locale identifier.
     * </p>
     * 
     * @return The specified locale identifier.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * <p>
     * The specified description of the bot locale.
     * </p>
     * 
     * @return The specified description of the bot locale.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and
     * <code>AMAZON.KendraSearchIntent</code> intents.
     * </p>
     * 
     * @return The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and
     *         <code>AMAZON.KendraSearchIntent</code> intents.
     */
    public final Double nluIntentConfidenceThreshold() {
        return nluIntentConfidenceThreshold;
    }

    /**
     * <p>
     * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
     * </p>
     * 
     * @return The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
     */
    public final VoiceSettings voiceSettings() {
        return voiceSettings;
    }

    /**
     * <p>
     * The status of the bot.
     * </p>
     * <p>
     * When the status is <code>Creating</code> the bot locale is being configured. When the status is
     * <code>Building</code> Amazon Lex is building the bot for testing and use.
     * </p>
     * <p>
     * If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances
     * specified in the bots' intents. When the bot is ready for full testing or to run, the status is
     * <code>Built</code>.
     * </p>
     * <p>
     * If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not
     * built, the status is <code>NotBuilt</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The status of the bot.</p>
     *         <p>
     *         When the status is <code>Creating</code> the bot locale is being configured. When the status is
     *         <code>Building</code> Amazon Lex is building the bot for testing and use.
     *         </p>
     *         <p>
     *         If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact
     *         utterances specified in the bots' intents. When the bot is ready for full testing or to run, the status
     *         is <code>Built</code>.
     *         </p>
     *         <p>
     *         If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but
     *         not built, the status is <code>NotBuilt</code>.
     * @see BotLocaleStatus
     */
    public final BotLocaleStatus botLocaleStatus() {
        return BotLocaleStatus.fromValue(botLocaleStatus);
    }

    /**
     * <p>
     * The status of the bot.
     * </p>
     * <p>
     * When the status is <code>Creating</code> the bot locale is being configured. When the status is
     * <code>Building</code> Amazon Lex is building the bot for testing and use.
     * </p>
     * <p>
     * If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances
     * specified in the bots' intents. When the bot is ready for full testing or to run, the status is
     * <code>Built</code>.
     * </p>
     * <p>
     * If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not
     * built, the status is <code>NotBuilt</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botLocaleStatus}
     * will return {@link BotLocaleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #botLocaleStatusAsString}.
     * </p>
     * 
     * @return The status of the bot.</p>
     *         <p>
     *         When the status is <code>Creating</code> the bot locale is being configured. When the status is
     *         <code>Building</code> Amazon Lex is building the bot for testing and use.
     *         </p>
     *         <p>
     *         If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact
     *         utterances specified in the bots' intents. When the bot is ready for full testing or to run, the status
     *         is <code>Built</code>.
     *         </p>
     *         <p>
     *         If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but
     *         not built, the status is <code>NotBuilt</code>.
     * @see BotLocaleStatus
     */
    public final String botLocaleStatusAsString() {
        return botLocaleStatus;
    }

    /**
     * <p>
     * A timestamp specifying the date and time that the bot locale was created.
     * </p>
     * 
     * @return A timestamp specifying the date and time that the bot locale was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * Returns the value of the GenerativeAISettings property for this object.
     * 
     * @return The value of the GenerativeAISettings property for this object.
     */
    public final GenerativeAISettings generativeAISettings() {
        return generativeAISettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeName());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(nluIntentConfidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(voiceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(generativeAISettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotLocaleResponse)) {
            return false;
        }
        CreateBotLocaleResponse other = (CreateBotLocaleResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeName(), other.localeName()) && Objects.equals(localeId(), other.localeId())
                && Objects.equals(description(), other.description())
                && Objects.equals(nluIntentConfidenceThreshold(), other.nluIntentConfidenceThreshold())
                && Objects.equals(voiceSettings(), other.voiceSettings())
                && Objects.equals(botLocaleStatusAsString(), other.botLocaleStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(generativeAISettings(), other.generativeAISettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBotLocaleResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleName", localeName()).add("LocaleId", localeId()).add("Description", description())
                .add("NluIntentConfidenceThreshold", nluIntentConfidenceThreshold()).add("VoiceSettings", voiceSettings())
                .add("BotLocaleStatus", botLocaleStatusAsString()).add("CreationDateTime", creationDateTime())
                .add("GenerativeAISettings", generativeAISettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeName":
            return Optional.ofNullable(clazz.cast(localeName()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "nluIntentConfidenceThreshold":
            return Optional.ofNullable(clazz.cast(nluIntentConfidenceThreshold()));
        case "voiceSettings":
            return Optional.ofNullable(clazz.cast(voiceSettings()));
        case "botLocaleStatus":
            return Optional.ofNullable(clazz.cast(botLocaleStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "generativeAISettings":
            return Optional.ofNullable(clazz.cast(generativeAISettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeName", LOCALE_NAME_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("nluIntentConfidenceThreshold", NLU_INTENT_CONFIDENCE_THRESHOLD_FIELD);
        map.put("voiceSettings", VOICE_SETTINGS_FIELD);
        map.put("botLocaleStatus", BOT_LOCALE_STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("generativeAISettings", GENERATIVE_AI_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBotLocaleResponse, T> g) {
        return obj -> g.apply((CreateBotLocaleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotLocaleResponse> {
        /**
         * <p>
         * The specified bot identifier.
         * </p>
         * 
         * @param botId
         *        The specified bot identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The specified bot version.
         * </p>
         * 
         * @param botVersion
         *        The specified bot version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The specified locale name.
         * </p>
         * 
         * @param localeName
         *        The specified locale name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeName(String localeName);

        /**
         * <p>
         * The specified locale identifier.
         * </p>
         * 
         * @param localeId
         *        The specified locale identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * The specified description of the bot locale.
         * </p>
         * 
         * @param description
         *        The specified description of the bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and
         * <code>AMAZON.KendraSearchIntent</code> intents.
         * </p>
         * 
         * @param nluIntentConfidenceThreshold
         *        The specified confidence threshold for inserting the <code>AMAZON.FallbackIntent</code> and
         *        <code>AMAZON.KendraSearchIntent</code> intents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold);

        /**
         * <p>
         * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
         * </p>
         * 
         * @param voiceSettings
         *        The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voiceSettings(VoiceSettings voiceSettings);

        /**
         * <p>
         * The Amazon Polly voice ID that Amazon Lex uses for voice interaction with the user.
         * </p>
         * This is a convenience method that creates an instance of the {@link VoiceSettings.Builder} avoiding the need
         * to create one manually via {@link VoiceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoiceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #voiceSettings(VoiceSettings)}.
         * 
         * @param voiceSettings
         *        a consumer that will call methods on {@link VoiceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voiceSettings(VoiceSettings)
         */
        default Builder voiceSettings(Consumer<VoiceSettings.Builder> voiceSettings) {
            return voiceSettings(VoiceSettings.builder().applyMutation(voiceSettings).build());
        }

        /**
         * <p>
         * The status of the bot.
         * </p>
         * <p>
         * When the status is <code>Creating</code> the bot locale is being configured. When the status is
         * <code>Building</code> Amazon Lex is building the bot for testing and use.
         * </p>
         * <p>
         * If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances
         * specified in the bots' intents. When the bot is ready for full testing or to run, the status is
         * <code>Built</code>.
         * </p>
         * <p>
         * If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not
         * built, the status is <code>NotBuilt</code>.
         * </p>
         * 
         * @param botLocaleStatus
         *        The status of the bot.</p>
         *        <p>
         *        When the status is <code>Creating</code> the bot locale is being configured. When the status is
         *        <code>Building</code> Amazon Lex is building the bot for testing and use.
         *        </p>
         *        <p>
         *        If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact
         *        utterances specified in the bots' intents. When the bot is ready for full testing or to run, the
         *        status is <code>Built</code>.
         *        </p>
         *        <p>
         *        If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved
         *        but not built, the status is <code>NotBuilt</code>.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(String botLocaleStatus);

        /**
         * <p>
         * The status of the bot.
         * </p>
         * <p>
         * When the status is <code>Creating</code> the bot locale is being configured. When the status is
         * <code>Building</code> Amazon Lex is building the bot for testing and use.
         * </p>
         * <p>
         * If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact utterances
         * specified in the bots' intents. When the bot is ready for full testing or to run, the status is
         * <code>Built</code>.
         * </p>
         * <p>
         * If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved but not
         * built, the status is <code>NotBuilt</code>.
         * </p>
         * 
         * @param botLocaleStatus
         *        The status of the bot.</p>
         *        <p>
         *        When the status is <code>Creating</code> the bot locale is being configured. When the status is
         *        <code>Building</code> Amazon Lex is building the bot for testing and use.
         *        </p>
         *        <p>
         *        If the status of the bot is <code>ReadyExpressTesting</code>, you can test the bot using the exact
         *        utterances specified in the bots' intents. When the bot is ready for full testing or to run, the
         *        status is <code>Built</code>.
         *        </p>
         *        <p>
         *        If there was a problem with building the bot, the status is <code>Failed</code>. If the bot was saved
         *        but not built, the status is <code>NotBuilt</code>.
         * @see BotLocaleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotLocaleStatus
         */
        Builder botLocaleStatus(BotLocaleStatus botLocaleStatus);

        /**
         * <p>
         * A timestamp specifying the date and time that the bot locale was created.
         * </p>
         * 
         * @param creationDateTime
         *        A timestamp specifying the date and time that the bot locale was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * Sets the value of the GenerativeAISettings property for this object.
         *
         * @param generativeAISettings
         *        The new value for the GenerativeAISettings property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generativeAISettings(GenerativeAISettings generativeAISettings);

        /**
         * Sets the value of the GenerativeAISettings property for this object.
         *
         * This is a convenience method that creates an instance of the {@link GenerativeAISettings.Builder} avoiding
         * the need to create one manually via {@link GenerativeAISettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GenerativeAISettings.Builder#build()} is called immediately and
         * its result is passed to {@link #generativeAISettings(GenerativeAISettings)}.
         * 
         * @param generativeAISettings
         *        a consumer that will call methods on {@link GenerativeAISettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #generativeAISettings(GenerativeAISettings)
         */
        default Builder generativeAISettings(Consumer<GenerativeAISettings.Builder> generativeAISettings) {
            return generativeAISettings(GenerativeAISettings.builder().applyMutation(generativeAISettings).build());
        }
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeName;

        private String localeId;

        private String description;

        private Double nluIntentConfidenceThreshold;

        private VoiceSettings voiceSettings;

        private String botLocaleStatus;

        private Instant creationDateTime;

        private GenerativeAISettings generativeAISettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotLocaleResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeName(model.localeName);
            localeId(model.localeId);
            description(model.description);
            nluIntentConfidenceThreshold(model.nluIntentConfidenceThreshold);
            voiceSettings(model.voiceSettings);
            botLocaleStatus(model.botLocaleStatus);
            creationDateTime(model.creationDateTime);
            generativeAISettings(model.generativeAISettings);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleName() {
            return localeName;
        }

        public final void setLocaleName(String localeName) {
            this.localeName = localeName;
        }

        @Override
        public final Builder localeName(String localeName) {
            this.localeName = localeName;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Double getNluIntentConfidenceThreshold() {
            return nluIntentConfidenceThreshold;
        }

        public final void setNluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
        }

        @Override
        public final Builder nluIntentConfidenceThreshold(Double nluIntentConfidenceThreshold) {
            this.nluIntentConfidenceThreshold = nluIntentConfidenceThreshold;
            return this;
        }

        public final VoiceSettings.Builder getVoiceSettings() {
            return voiceSettings != null ? voiceSettings.toBuilder() : null;
        }

        public final void setVoiceSettings(VoiceSettings.BuilderImpl voiceSettings) {
            this.voiceSettings = voiceSettings != null ? voiceSettings.build() : null;
        }

        @Override
        public final Builder voiceSettings(VoiceSettings voiceSettings) {
            this.voiceSettings = voiceSettings;
            return this;
        }

        public final String getBotLocaleStatus() {
            return botLocaleStatus;
        }

        public final void setBotLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
        }

        @Override
        public final Builder botLocaleStatus(String botLocaleStatus) {
            this.botLocaleStatus = botLocaleStatus;
            return this;
        }

        @Override
        public final Builder botLocaleStatus(BotLocaleStatus botLocaleStatus) {
            this.botLocaleStatus(botLocaleStatus == null ? null : botLocaleStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final GenerativeAISettings.Builder getGenerativeAISettings() {
            return generativeAISettings != null ? generativeAISettings.toBuilder() : null;
        }

        public final void setGenerativeAISettings(GenerativeAISettings.BuilderImpl generativeAISettings) {
            this.generativeAISettings = generativeAISettings != null ? generativeAISettings.build() : null;
        }

        @Override
        public final Builder generativeAISettings(GenerativeAISettings generativeAISettings) {
            this.generativeAISettings = generativeAISettings;
            return this;
        }

        @Override
        public CreateBotLocaleResponse build() {
            return new CreateBotLocaleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
