/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBotVersionRequest extends LexModelsV2Request implements
        ToCopyableBuilder<CreateBotVersionRequest.Builder, CreateBotVersionRequest> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(CreateBotVersionRequest::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("botId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateBotVersionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Map<String, BotVersionLocaleDetails>> BOT_VERSION_LOCALE_SPECIFICATION_FIELD = SdkField
            .<Map<String, BotVersionLocaleDetails>> builder(MarshallingType.MAP)
            .memberName("botVersionLocaleSpecification")
            .getter(getter(CreateBotVersionRequest::botVersionLocaleSpecification))
            .setter(setter(Builder::botVersionLocaleSpecification))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersionLocaleSpecification")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<BotVersionLocaleDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotVersionLocaleDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            DESCRIPTION_FIELD, BOT_VERSION_LOCALE_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String description;

    private final Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification;

    private CreateBotVersionRequest(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.description = builder.description;
        this.botVersionLocaleSpecification = builder.botVersionLocaleSpecification;
    }

    /**
     * <p>
     * The identifier of the bot to create the version for.
     * </p>
     * 
     * @return The identifier of the bot to create the version for.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * A description of the version. Use the description to help identify the version in lists.
     * </p>
     * 
     * @return A description of the version. Use the description to help identify the version in lists.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotVersionLocaleSpecification property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBotVersionLocaleSpecification() {
        return botVersionLocaleSpecification != null && !(botVersionLocaleSpecification instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or any
     * other previously published version for each locale. When you specify a source version, the locale data is copied
     * from the source version to the new version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotVersionLocaleSpecification} method.
     * </p>
     * 
     * @return Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version
     *         or any other previously published version for each locale. When you specify a source version, the locale
     *         data is copied from the source version to the new version.
     */
    public final Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification() {
        return botVersionLocaleSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotVersionLocaleSpecification() ? botVersionLocaleSpecification() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBotVersionRequest)) {
            return false;
        }
        CreateBotVersionRequest other = (CreateBotVersionRequest) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(description(), other.description())
                && hasBotVersionLocaleSpecification() == other.hasBotVersionLocaleSpecification()
                && Objects.equals(botVersionLocaleSpecification(), other.botVersionLocaleSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("CreateBotVersionRequest")
                .add("BotId", botId())
                .add("Description", description())
                .add("BotVersionLocaleSpecification", hasBotVersionLocaleSpecification() ? botVersionLocaleSpecification() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "botVersionLocaleSpecification":
            return Optional.ofNullable(clazz.cast(botVersionLocaleSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("botVersionLocaleSpecification", BOT_VERSION_LOCALE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBotVersionRequest, T> g) {
        return obj -> g.apply((CreateBotVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo, CopyableBuilder<Builder, CreateBotVersionRequest> {
        /**
         * <p>
         * The identifier of the bot to create the version for.
         * </p>
         * 
         * @param botId
         *        The identifier of the bot to create the version for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * A description of the version. Use the description to help identify the version in lists.
         * </p>
         * 
         * @param description
         *        A description of the version. Use the description to help identify the version in lists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code> version or
         * any other previously published version for each locale. When you specify a source version, the locale data is
         * copied from the source version to the new version.
         * </p>
         * 
         * @param botVersionLocaleSpecification
         *        Specifies the locales that Amazon Lex adds to this version. You can choose the <code>Draft</code>
         *        version or any other previously published version for each locale. When you specify a source version,
         *        the locale data is copied from the source version to the new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersionLocaleSpecification(Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String botId;

        private String description;

        private Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBotVersionRequest model) {
            super(model);
            botId(model.botId);
            description(model.description);
            botVersionLocaleSpecification(model.botVersionLocaleSpecification);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, BotVersionLocaleDetails.Builder> getBotVersionLocaleSpecification() {
            Map<String, BotVersionLocaleDetails.Builder> result = BotVersionLocaleSpecificationCopier
                    .copyToBuilder(this.botVersionLocaleSpecification);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setBotVersionLocaleSpecification(
                Map<String, BotVersionLocaleDetails.BuilderImpl> botVersionLocaleSpecification) {
            this.botVersionLocaleSpecification = BotVersionLocaleSpecificationCopier
                    .copyFromBuilder(botVersionLocaleSpecification);
        }

        @Override
        public final Builder botVersionLocaleSpecification(Map<String, BotVersionLocaleDetails> botVersionLocaleSpecification) {
            this.botVersionLocaleSpecification = BotVersionLocaleSpecificationCopier.copy(botVersionLocaleSpecification);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBotVersionRequest build() {
            return new CreateBotVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
