/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the configuration of the knowledge store used for the <code>AMAZON.QnAIntent</code>. You must
 * have already created the knowledge store and indexed the documents within it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceConfiguration.Builder, DataSourceConfiguration> {
    private static final SdkField<OpensearchConfiguration> OPENSEARCH_CONFIGURATION_FIELD = SdkField
            .<OpensearchConfiguration> builder(MarshallingType.SDK_POJO).memberName("opensearchConfiguration")
            .getter(getter(DataSourceConfiguration::opensearchConfiguration)).setter(setter(Builder::opensearchConfiguration))
            .constructor(OpensearchConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("opensearchConfiguration").build())
            .build();

    private static final SdkField<QnAKendraConfiguration> KENDRA_CONFIGURATION_FIELD = SdkField
            .<QnAKendraConfiguration> builder(MarshallingType.SDK_POJO).memberName("kendraConfiguration")
            .getter(getter(DataSourceConfiguration::kendraConfiguration)).setter(setter(Builder::kendraConfiguration))
            .constructor(QnAKendraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kendraConfiguration").build())
            .build();

    private static final SdkField<BedrockKnowledgeStoreConfiguration> BEDROCK_KNOWLEDGE_STORE_CONFIGURATION_FIELD = SdkField
            .<BedrockKnowledgeStoreConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("bedrockKnowledgeStoreConfiguration")
            .getter(getter(DataSourceConfiguration::bedrockKnowledgeStoreConfiguration))
            .setter(setter(Builder::bedrockKnowledgeStoreConfiguration))
            .constructor(BedrockKnowledgeStoreConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bedrockKnowledgeStoreConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OPENSEARCH_CONFIGURATION_FIELD, KENDRA_CONFIGURATION_FIELD, BEDROCK_KNOWLEDGE_STORE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final OpensearchConfiguration opensearchConfiguration;

    private final QnAKendraConfiguration kendraConfiguration;

    private final BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration;

    private DataSourceConfiguration(BuilderImpl builder) {
        this.opensearchConfiguration = builder.opensearchConfiguration;
        this.kendraConfiguration = builder.kendraConfiguration;
        this.bedrockKnowledgeStoreConfiguration = builder.bedrockKnowledgeStoreConfiguration;
    }

    /**
     * <p>
     * Contains details about the configuration of the Amazon OpenSearch Service database used for the
     * <code>AMAZON.QnAIntent</code>. To create a domain, follow the steps at <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and
     * managing Amazon OpenSearch Service domains</a>.
     * </p>
     * 
     * @return Contains details about the configuration of the Amazon OpenSearch Service database used for the
     *         <code>AMAZON.QnAIntent</code>. To create a domain, follow the steps at <a
     *         href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html"
     *         >Creating and managing Amazon OpenSearch Service domains</a>.
     */
    public final OpensearchConfiguration opensearchConfiguration() {
        return opensearchConfiguration;
    }

    /**
     * <p>
     * Contains details about the configuration of the Amazon Kendra index used for the <code>AMAZON.QnAIntent</code>.
     * To create a Amazon Kendra index, follow the steps at <a
     * href="https://docs.aws.amazon.com/kendra/latest/dg/create-index.html">Creating an index</a>.
     * </p>
     * 
     * @return Contains details about the configuration of the Amazon Kendra index used for the
     *         <code>AMAZON.QnAIntent</code>. To create a Amazon Kendra index, follow the steps at <a
     *         href="https://docs.aws.amazon.com/kendra/latest/dg/create-index.html">Creating an index</a>.
     */
    public final QnAKendraConfiguration kendraConfiguration() {
        return kendraConfiguration;
    }

    /**
     * <p>
     * Contains details about the configuration of the Amazon Bedrock knowledge base used for the
     * <code>AMAZON.QnAIntent</code>. To set up a knowledge base, follow the steps at <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html">Building a knowledge base</a>.
     * </p>
     * 
     * @return Contains details about the configuration of the Amazon Bedrock knowledge base used for the
     *         <code>AMAZON.QnAIntent</code>. To set up a knowledge base, follow the steps at <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html">Building a knowledge
     *         base</a>.
     */
    public final BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration() {
        return bedrockKnowledgeStoreConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opensearchConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(kendraConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(bedrockKnowledgeStoreConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfiguration)) {
            return false;
        }
        DataSourceConfiguration other = (DataSourceConfiguration) obj;
        return Objects.equals(opensearchConfiguration(), other.opensearchConfiguration())
                && Objects.equals(kendraConfiguration(), other.kendraConfiguration())
                && Objects.equals(bedrockKnowledgeStoreConfiguration(), other.bedrockKnowledgeStoreConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceConfiguration").add("OpensearchConfiguration", opensearchConfiguration())
                .add("KendraConfiguration", kendraConfiguration())
                .add("BedrockKnowledgeStoreConfiguration", bedrockKnowledgeStoreConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "opensearchConfiguration":
            return Optional.ofNullable(clazz.cast(opensearchConfiguration()));
        case "kendraConfiguration":
            return Optional.ofNullable(clazz.cast(kendraConfiguration()));
        case "bedrockKnowledgeStoreConfiguration":
            return Optional.ofNullable(clazz.cast(bedrockKnowledgeStoreConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("opensearchConfiguration", OPENSEARCH_CONFIGURATION_FIELD);
        map.put("kendraConfiguration", KENDRA_CONFIGURATION_FIELD);
        map.put("bedrockKnowledgeStoreConfiguration", BEDROCK_KNOWLEDGE_STORE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfiguration, T> g) {
        return obj -> g.apply((DataSourceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceConfiguration> {
        /**
         * <p>
         * Contains details about the configuration of the Amazon OpenSearch Service database used for the
         * <code>AMAZON.QnAIntent</code>. To create a domain, follow the steps at <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating
         * and managing Amazon OpenSearch Service domains</a>.
         * </p>
         * 
         * @param opensearchConfiguration
         *        Contains details about the configuration of the Amazon OpenSearch Service database used for the
         *        <code>AMAZON.QnAIntent</code>. To create a domain, follow the steps at <a
         *        href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html"
         *        >Creating and managing Amazon OpenSearch Service domains</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opensearchConfiguration(OpensearchConfiguration opensearchConfiguration);

        /**
         * <p>
         * Contains details about the configuration of the Amazon OpenSearch Service database used for the
         * <code>AMAZON.QnAIntent</code>. To create a domain, follow the steps at <a
         * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating
         * and managing Amazon OpenSearch Service domains</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpensearchConfiguration.Builder} avoiding
         * the need to create one manually via {@link OpensearchConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpensearchConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #opensearchConfiguration(OpensearchConfiguration)}.
         * 
         * @param opensearchConfiguration
         *        a consumer that will call methods on {@link OpensearchConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opensearchConfiguration(OpensearchConfiguration)
         */
        default Builder opensearchConfiguration(Consumer<OpensearchConfiguration.Builder> opensearchConfiguration) {
            return opensearchConfiguration(OpensearchConfiguration.builder().applyMutation(opensearchConfiguration).build());
        }

        /**
         * <p>
         * Contains details about the configuration of the Amazon Kendra index used for the
         * <code>AMAZON.QnAIntent</code>. To create a Amazon Kendra index, follow the steps at <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/create-index.html">Creating an index</a>.
         * </p>
         * 
         * @param kendraConfiguration
         *        Contains details about the configuration of the Amazon Kendra index used for the
         *        <code>AMAZON.QnAIntent</code>. To create a Amazon Kendra index, follow the steps at <a
         *        href="https://docs.aws.amazon.com/kendra/latest/dg/create-index.html">Creating an index</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kendraConfiguration(QnAKendraConfiguration kendraConfiguration);

        /**
         * <p>
         * Contains details about the configuration of the Amazon Kendra index used for the
         * <code>AMAZON.QnAIntent</code>. To create a Amazon Kendra index, follow the steps at <a
         * href="https://docs.aws.amazon.com/kendra/latest/dg/create-index.html">Creating an index</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link QnAKendraConfiguration.Builder} avoiding
         * the need to create one manually via {@link QnAKendraConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QnAKendraConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #kendraConfiguration(QnAKendraConfiguration)}.
         * 
         * @param kendraConfiguration
         *        a consumer that will call methods on {@link QnAKendraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #kendraConfiguration(QnAKendraConfiguration)
         */
        default Builder kendraConfiguration(Consumer<QnAKendraConfiguration.Builder> kendraConfiguration) {
            return kendraConfiguration(QnAKendraConfiguration.builder().applyMutation(kendraConfiguration).build());
        }

        /**
         * <p>
         * Contains details about the configuration of the Amazon Bedrock knowledge base used for the
         * <code>AMAZON.QnAIntent</code>. To set up a knowledge base, follow the steps at <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html">Building a knowledge
         * base</a>.
         * </p>
         * 
         * @param bedrockKnowledgeStoreConfiguration
         *        Contains details about the configuration of the Amazon Bedrock knowledge base used for the
         *        <code>AMAZON.QnAIntent</code>. To set up a knowledge base, follow the steps at <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html">Building a knowledge
         *        base</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bedrockKnowledgeStoreConfiguration(BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration);

        /**
         * <p>
         * Contains details about the configuration of the Amazon Bedrock knowledge base used for the
         * <code>AMAZON.QnAIntent</code>. To set up a knowledge base, follow the steps at <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base.html">Building a knowledge
         * base</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link BedrockKnowledgeStoreConfiguration.Builder} avoiding the need to create one manually via
         * {@link BedrockKnowledgeStoreConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BedrockKnowledgeStoreConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #bedrockKnowledgeStoreConfiguration(BedrockKnowledgeStoreConfiguration)}.
         * 
         * @param bedrockKnowledgeStoreConfiguration
         *        a consumer that will call methods on {@link BedrockKnowledgeStoreConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bedrockKnowledgeStoreConfiguration(BedrockKnowledgeStoreConfiguration)
         */
        default Builder bedrockKnowledgeStoreConfiguration(
                Consumer<BedrockKnowledgeStoreConfiguration.Builder> bedrockKnowledgeStoreConfiguration) {
            return bedrockKnowledgeStoreConfiguration(BedrockKnowledgeStoreConfiguration.builder()
                    .applyMutation(bedrockKnowledgeStoreConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private OpensearchConfiguration opensearchConfiguration;

        private QnAKendraConfiguration kendraConfiguration;

        private BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfiguration model) {
            opensearchConfiguration(model.opensearchConfiguration);
            kendraConfiguration(model.kendraConfiguration);
            bedrockKnowledgeStoreConfiguration(model.bedrockKnowledgeStoreConfiguration);
        }

        public final OpensearchConfiguration.Builder getOpensearchConfiguration() {
            return opensearchConfiguration != null ? opensearchConfiguration.toBuilder() : null;
        }

        public final void setOpensearchConfiguration(OpensearchConfiguration.BuilderImpl opensearchConfiguration) {
            this.opensearchConfiguration = opensearchConfiguration != null ? opensearchConfiguration.build() : null;
        }

        @Override
        public final Builder opensearchConfiguration(OpensearchConfiguration opensearchConfiguration) {
            this.opensearchConfiguration = opensearchConfiguration;
            return this;
        }

        public final QnAKendraConfiguration.Builder getKendraConfiguration() {
            return kendraConfiguration != null ? kendraConfiguration.toBuilder() : null;
        }

        public final void setKendraConfiguration(QnAKendraConfiguration.BuilderImpl kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration != null ? kendraConfiguration.build() : null;
        }

        @Override
        public final Builder kendraConfiguration(QnAKendraConfiguration kendraConfiguration) {
            this.kendraConfiguration = kendraConfiguration;
            return this;
        }

        public final BedrockKnowledgeStoreConfiguration.Builder getBedrockKnowledgeStoreConfiguration() {
            return bedrockKnowledgeStoreConfiguration != null ? bedrockKnowledgeStoreConfiguration.toBuilder() : null;
        }

        public final void setBedrockKnowledgeStoreConfiguration(
                BedrockKnowledgeStoreConfiguration.BuilderImpl bedrockKnowledgeStoreConfiguration) {
            this.bedrockKnowledgeStoreConfiguration = bedrockKnowledgeStoreConfiguration != null ? bedrockKnowledgeStoreConfiguration
                    .build() : null;
        }

        @Override
        public final Builder bedrockKnowledgeStoreConfiguration(
                BedrockKnowledgeStoreConfiguration bedrockKnowledgeStoreConfiguration) {
            this.bedrockKnowledgeStoreConfiguration = bedrockKnowledgeStoreConfiguration;
            return this;
        }

        @Override
        public DataSourceConfiguration build() {
            return new DataSourceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
