/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteBotResponse extends LexModelsV2Response implements
        ToCopyableBuilder<DeleteBotResponse.Builder, DeleteBotResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(DeleteBotResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botStatus").getter(getter(DeleteBotResponse::botStatusAsString)).setter(setter(Builder::botStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(BOT_ID_FIELD, BOT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botStatus;

    private DeleteBotResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botStatus = builder.botStatus;
    }

    /**
     * <p>
     * The unique identifier of the bot that Amazon Lex is deleting.
     * </p>
     * 
     * @return The unique identifier of the bot that Amazon Lex is deleting.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are
     * being deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot. The status is <code>Deleting</code> while the bot and its associated
     *         resources are being deleted.
     * @see BotStatus
     */
    public final BotStatus botStatus() {
        return BotStatus.fromValue(botStatus);
    }

    /**
     * <p>
     * The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources are
     * being deleted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #botStatus} will
     * return {@link BotStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #botStatusAsString}.
     * </p>
     * 
     * @return The current status of the bot. The status is <code>Deleting</code> while the bot and its associated
     *         resources are being deleted.
     * @see BotStatus
     */
    public final String botStatusAsString() {
        return botStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteBotResponse)) {
            return false;
        }
        DeleteBotResponse other = (DeleteBotResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botStatusAsString(), other.botStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteBotResponse").add("BotId", botId()).add("BotStatus", botStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botStatus":
            return Optional.ofNullable(clazz.cast(botStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botStatus", BOT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteBotResponse, T> g) {
        return obj -> g.apply((DeleteBotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo, CopyableBuilder<Builder, DeleteBotResponse> {
        /**
         * <p>
         * The unique identifier of the bot that Amazon Lex is deleting.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that Amazon Lex is deleting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources
         * are being deleted.
         * </p>
         * 
         * @param botStatus
         *        The current status of the bot. The status is <code>Deleting</code> while the bot and its associated
         *        resources are being deleted.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(String botStatus);

        /**
         * <p>
         * The current status of the bot. The status is <code>Deleting</code> while the bot and its associated resources
         * are being deleted.
         * </p>
         * 
         * @param botStatus
         *        The current status of the bot. The status is <code>Deleting</code> while the bot and its associated
         *        resources are being deleted.
         * @see BotStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BotStatus
         */
        Builder botStatus(BotStatus botStatus);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteBotResponse model) {
            super(model);
            botId(model.botId);
            botStatus(model.botStatus);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotStatus() {
            return botStatus;
        }

        public final void setBotStatus(String botStatus) {
            this.botStatus = botStatus;
        }

        @Override
        public final Builder botStatus(String botStatus) {
            this.botStatus = botStatus;
            return this;
        }

        @Override
        public final Builder botStatus(BotStatus botStatus) {
            this.botStatus(botStatus == null ? null : botStatus.toString());
            return this;
        }

        @Override
        public DeleteBotResponse build() {
            return new DeleteBotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
