/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTestSetDiscrepancyReportRequest extends LexModelsV2Request implements
        ToCopyableBuilder<DescribeTestSetDiscrepancyReportRequest.Builder, DescribeTestSetDiscrepancyReportRequest> {
    private static final SdkField<String> TEST_SET_DISCREPANCY_REPORT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("testSetDiscrepancyReportId")
            .getter(getter(DescribeTestSetDiscrepancyReportRequest::testSetDiscrepancyReportId))
            .setter(setter(Builder::testSetDiscrepancyReportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testSetDiscrepancyReportId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TEST_SET_DISCREPANCY_REPORT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testSetDiscrepancyReportId;

    private DescribeTestSetDiscrepancyReportRequest(BuilderImpl builder) {
        super(builder);
        this.testSetDiscrepancyReportId = builder.testSetDiscrepancyReportId;
    }

    /**
     * <p>
     * The unique identifier of the test set discrepancy report.
     * </p>
     * 
     * @return The unique identifier of the test set discrepancy report.
     */
    public final String testSetDiscrepancyReportId() {
        return testSetDiscrepancyReportId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSetDiscrepancyReportId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTestSetDiscrepancyReportRequest)) {
            return false;
        }
        DescribeTestSetDiscrepancyReportRequest other = (DescribeTestSetDiscrepancyReportRequest) obj;
        return Objects.equals(testSetDiscrepancyReportId(), other.testSetDiscrepancyReportId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTestSetDiscrepancyReportRequest")
                .add("TestSetDiscrepancyReportId", testSetDiscrepancyReportId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSetDiscrepancyReportId":
            return Optional.ofNullable(clazz.cast(testSetDiscrepancyReportId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testSetDiscrepancyReportId", TEST_SET_DISCREPANCY_REPORT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTestSetDiscrepancyReportRequest, T> g) {
        return obj -> g.apply((DescribeTestSetDiscrepancyReportRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Request.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTestSetDiscrepancyReportRequest> {
        /**
         * <p>
         * The unique identifier of the test set discrepancy report.
         * </p>
         * 
         * @param testSetDiscrepancyReportId
         *        The unique identifier of the test set discrepancy report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetDiscrepancyReportId(String testSetDiscrepancyReportId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends LexModelsV2Request.BuilderImpl implements Builder {
        private String testSetDiscrepancyReportId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTestSetDiscrepancyReportRequest model) {
            super(model);
            testSetDiscrepancyReportId(model.testSetDiscrepancyReportId);
        }

        public final String getTestSetDiscrepancyReportId() {
            return testSetDiscrepancyReportId;
        }

        public final void setTestSetDiscrepancyReportId(String testSetDiscrepancyReportId) {
            this.testSetDiscrepancyReportId = testSetDiscrepancyReportId;
        }

        @Override
        public final Builder testSetDiscrepancyReportId(String testSetDiscrepancyReportId) {
            this.testSetDiscrepancyReportId = testSetDiscrepancyReportId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTestSetDiscrepancyReportRequest build() {
            return new DescribeTestSetDiscrepancyReportRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
