/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the action that the bot executes at runtime when the conversation reaches this step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DialogAction implements SdkPojo, Serializable, ToCopyableBuilder<DialogAction.Builder, DialogAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DialogAction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> SLOT_TO_ELICIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotToElicit").getter(getter(DialogAction::slotToElicit)).setter(setter(Builder::slotToElicit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotToElicit").build()).build();

    private static final SdkField<Boolean> SUPPRESS_NEXT_MESSAGE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("suppressNextMessage").getter(getter(DialogAction::suppressNextMessage))
            .setter(setter(Builder::suppressNextMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suppressNextMessage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            SLOT_TO_ELICIT_FIELD, SUPPRESS_NEXT_MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String slotToElicit;

    private final Boolean suppressNextMessage;

    private DialogAction(BuilderImpl builder) {
        this.type = builder.type;
        this.slotToElicit = builder.slotToElicit;
        this.suppressNextMessage = builder.suppressNextMessage;
    }

    /**
     * <p>
     * The action that the bot should execute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DialogActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The action that the bot should execute.
     * @see DialogActionType
     */
    public final DialogActionType type() {
        return DialogActionType.fromValue(type);
    }

    /**
     * <p>
     * The action that the bot should execute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DialogActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The action that the bot should execute.
     * @see DialogActionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * If the dialog action is <code>ElicitSlot</code>, defines the slot to elicit from the user.
     * </p>
     * 
     * @return If the dialog action is <code>ElicitSlot</code>, defines the slot to elicit from the user.
     */
    public final String slotToElicit() {
        return slotToElicit;
    }

    /**
     * <p>
     * When true the next message for the intent is not used.
     * </p>
     * 
     * @return When true the next message for the intent is not used.
     */
    public final Boolean suppressNextMessage() {
        return suppressNextMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slotToElicit());
        hashCode = 31 * hashCode + Objects.hashCode(suppressNextMessage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DialogAction)) {
            return false;
        }
        DialogAction other = (DialogAction) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(slotToElicit(), other.slotToElicit())
                && Objects.equals(suppressNextMessage(), other.suppressNextMessage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DialogAction").add("Type", typeAsString()).add("SlotToElicit", slotToElicit())
                .add("SuppressNextMessage", suppressNextMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "slotToElicit":
            return Optional.ofNullable(clazz.cast(slotToElicit()));
        case "suppressNextMessage":
            return Optional.ofNullable(clazz.cast(suppressNextMessage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("slotToElicit", SLOT_TO_ELICIT_FIELD);
        map.put("suppressNextMessage", SUPPRESS_NEXT_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DialogAction, T> g) {
        return obj -> g.apply((DialogAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DialogAction> {
        /**
         * <p>
         * The action that the bot should execute.
         * </p>
         * 
         * @param type
         *        The action that the bot should execute.
         * @see DialogActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DialogActionType
         */
        Builder type(String type);

        /**
         * <p>
         * The action that the bot should execute.
         * </p>
         * 
         * @param type
         *        The action that the bot should execute.
         * @see DialogActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DialogActionType
         */
        Builder type(DialogActionType type);

        /**
         * <p>
         * If the dialog action is <code>ElicitSlot</code>, defines the slot to elicit from the user.
         * </p>
         * 
         * @param slotToElicit
         *        If the dialog action is <code>ElicitSlot</code>, defines the slot to elicit from the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotToElicit(String slotToElicit);

        /**
         * <p>
         * When true the next message for the intent is not used.
         * </p>
         * 
         * @param suppressNextMessage
         *        When true the next message for the intent is not used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suppressNextMessage(Boolean suppressNextMessage);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String slotToElicit;

        private Boolean suppressNextMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DialogAction model) {
            type(model.type);
            slotToElicit(model.slotToElicit);
            suppressNextMessage(model.suppressNextMessage);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DialogActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSlotToElicit() {
            return slotToElicit;
        }

        public final void setSlotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
        }

        @Override
        public final Builder slotToElicit(String slotToElicit) {
            this.slotToElicit = slotToElicit;
            return this;
        }

        public final Boolean getSuppressNextMessage() {
            return suppressNextMessage;
        }

        public final void setSuppressNextMessage(Boolean suppressNextMessage) {
            this.suppressNextMessage = suppressNextMessage;
        }

        @Override
        public final Builder suppressNextMessage(Boolean suppressNextMessage) {
            this.suppressNextMessage = suppressNextMessage;
            return this;
        }

        @Override
        public DialogAction build() {
            return new DialogAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
