/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings that specify the dialog code hook that is called by Amazon Lex between eliciting slot values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElicitationCodeHookInvocationSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<ElicitationCodeHookInvocationSetting.Builder, ElicitationCodeHookInvocationSetting> {
    private static final SdkField<Boolean> ENABLE_CODE_HOOK_INVOCATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("enableCodeHookInvocation")
            .getter(getter(ElicitationCodeHookInvocationSetting::enableCodeHookInvocation))
            .setter(setter(Builder::enableCodeHookInvocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableCodeHookInvocation").build())
            .build();

    private static final SdkField<String> INVOCATION_LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("invocationLabel").getter(getter(ElicitationCodeHookInvocationSetting::invocationLabel))
            .setter(setter(Builder::invocationLabel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationLabel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENABLE_CODE_HOOK_INVOCATION_FIELD, INVOCATION_LABEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableCodeHookInvocation;

    private final String invocationLabel;

    private ElicitationCodeHookInvocationSetting(BuilderImpl builder) {
        this.enableCodeHookInvocation = builder.enableCodeHookInvocation;
        this.invocationLabel = builder.invocationLabel;
    }

    /**
     * <p>
     * Indicates whether a Lambda function should be invoked for the dialog.
     * </p>
     * 
     * @return Indicates whether a Lambda function should be invoked for the dialog.
     */
    public final Boolean enableCodeHookInvocation() {
        return enableCodeHookInvocation;
    }

    /**
     * <p>
     * A label that indicates the dialog step from which the dialog code hook is happening.
     * </p>
     * 
     * @return A label that indicates the dialog step from which the dialog code hook is happening.
     */
    public final String invocationLabel() {
        return invocationLabel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableCodeHookInvocation());
        hashCode = 31 * hashCode + Objects.hashCode(invocationLabel());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElicitationCodeHookInvocationSetting)) {
            return false;
        }
        ElicitationCodeHookInvocationSetting other = (ElicitationCodeHookInvocationSetting) obj;
        return Objects.equals(enableCodeHookInvocation(), other.enableCodeHookInvocation())
                && Objects.equals(invocationLabel(), other.invocationLabel());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElicitationCodeHookInvocationSetting")
                .add("EnableCodeHookInvocation", enableCodeHookInvocation()).add("InvocationLabel", invocationLabel()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "enableCodeHookInvocation":
            return Optional.ofNullable(clazz.cast(enableCodeHookInvocation()));
        case "invocationLabel":
            return Optional.ofNullable(clazz.cast(invocationLabel()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("enableCodeHookInvocation", ENABLE_CODE_HOOK_INVOCATION_FIELD);
        map.put("invocationLabel", INVOCATION_LABEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ElicitationCodeHookInvocationSetting, T> g) {
        return obj -> g.apply((ElicitationCodeHookInvocationSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElicitationCodeHookInvocationSetting> {
        /**
         * <p>
         * Indicates whether a Lambda function should be invoked for the dialog.
         * </p>
         * 
         * @param enableCodeHookInvocation
         *        Indicates whether a Lambda function should be invoked for the dialog.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableCodeHookInvocation(Boolean enableCodeHookInvocation);

        /**
         * <p>
         * A label that indicates the dialog step from which the dialog code hook is happening.
         * </p>
         * 
         * @param invocationLabel
         *        A label that indicates the dialog step from which the dialog code hook is happening.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationLabel(String invocationLabel);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableCodeHookInvocation;

        private String invocationLabel;

        private BuilderImpl() {
        }

        private BuilderImpl(ElicitationCodeHookInvocationSetting model) {
            enableCodeHookInvocation(model.enableCodeHookInvocation);
            invocationLabel(model.invocationLabel);
        }

        public final Boolean getEnableCodeHookInvocation() {
            return enableCodeHookInvocation;
        }

        public final void setEnableCodeHookInvocation(Boolean enableCodeHookInvocation) {
            this.enableCodeHookInvocation = enableCodeHookInvocation;
        }

        @Override
        public final Builder enableCodeHookInvocation(Boolean enableCodeHookInvocation) {
            this.enableCodeHookInvocation = enableCodeHookInvocation;
            return this;
        }

        public final String getInvocationLabel() {
            return invocationLabel;
        }

        public final void setInvocationLabel(String invocationLabel) {
            this.invocationLabel = invocationLabel;
        }

        @Override
        public final Builder invocationLabel(String invocationLabel) {
            this.invocationLabel = invocationLabel;
            return this;
        }

        @Override
        public ElicitationCodeHookInvocationSetting build() {
            return new ElicitationCodeHookInvocationSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
