/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a generation request made for the bot locale.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<GenerationSummary.Builder, GenerationSummary> {
    private static final SdkField<String> GENERATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationId").getter(getter(GenerationSummary::generationId)).setter(setter(Builder::generationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationId").build()).build();

    private static final SdkField<String> GENERATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generationStatus").getter(getter(GenerationSummary::generationStatusAsString))
            .setter(setter(Builder::generationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationStatus").build()).build();

    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDateTime").getter(getter(GenerationSummary::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDateTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(GenerationSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GENERATION_ID_FIELD,
            GENERATION_STATUS_FIELD, CREATION_DATE_TIME_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String generationId;

    private final String generationStatus;

    private final Instant creationDateTime;

    private final Instant lastUpdatedDateTime;

    private GenerationSummary(BuilderImpl builder) {
        this.generationId = builder.generationId;
        this.generationStatus = builder.generationStatus;
        this.creationDateTime = builder.creationDateTime;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier of the generation request.
     * </p>
     * 
     * @return The unique identifier of the generation request.
     */
    public final String generationId() {
        return generationId;
    }

    /**
     * <p>
     * The status of the generation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return The status of the generation request.
     * @see GenerationStatus
     */
    public final GenerationStatus generationStatus() {
        return GenerationStatus.fromValue(generationStatus);
    }

    /**
     * <p>
     * The status of the generation request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #generationStatus}
     * will return {@link GenerationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #generationStatusAsString}.
     * </p>
     * 
     * @return The status of the generation request.
     * @see GenerationStatus
     */
    public final String generationStatusAsString() {
        return generationStatus;
    }

    /**
     * <p>
     * The date and time at which the generation request was made.
     * </p>
     * 
     * @return The date and time at which the generation request was made.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The date and time at which the generation request was last updated.
     * </p>
     * 
     * @return The date and time at which the generation request was last updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(generationId());
        hashCode = 31 * hashCode + Objects.hashCode(generationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerationSummary)) {
            return false;
        }
        GenerationSummary other = (GenerationSummary) obj;
        return Objects.equals(generationId(), other.generationId())
                && Objects.equals(generationStatusAsString(), other.generationStatusAsString())
                && Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerationSummary").add("GenerationId", generationId())
                .add("GenerationStatus", generationStatusAsString()).add("CreationDateTime", creationDateTime())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "generationId":
            return Optional.ofNullable(clazz.cast(generationId()));
        case "generationStatus":
            return Optional.ofNullable(clazz.cast(generationStatusAsString()));
        case "creationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("generationId", GENERATION_ID_FIELD);
        map.put("generationStatus", GENERATION_STATUS_FIELD);
        map.put("creationDateTime", CREATION_DATE_TIME_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerationSummary, T> g) {
        return obj -> g.apply((GenerationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenerationSummary> {
        /**
         * <p>
         * The unique identifier of the generation request.
         * </p>
         * 
         * @param generationId
         *        The unique identifier of the generation request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generationId(String generationId);

        /**
         * <p>
         * The status of the generation request.
         * </p>
         * 
         * @param generationStatus
         *        The status of the generation request.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(String generationStatus);

        /**
         * <p>
         * The status of the generation request.
         * </p>
         * 
         * @param generationStatus
         *        The status of the generation request.
         * @see GenerationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GenerationStatus
         */
        Builder generationStatus(GenerationStatus generationStatus);

        /**
         * <p>
         * The date and time at which the generation request was made.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time at which the generation request was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The date and time at which the generation request was last updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The date and time at which the generation request was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String generationId;

        private String generationStatus;

        private Instant creationDateTime;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerationSummary model) {
            generationId(model.generationId);
            generationStatus(model.generationStatus);
            creationDateTime(model.creationDateTime);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getGenerationId() {
            return generationId;
        }

        public final void setGenerationId(String generationId) {
            this.generationId = generationId;
        }

        @Override
        public final Builder generationId(String generationId) {
            this.generationId = generationId;
            return this;
        }

        public final String getGenerationStatus() {
            return generationStatus;
        }

        public final void setGenerationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
        }

        @Override
        public final Builder generationStatus(String generationStatus) {
            this.generationStatus = generationStatus;
            return this;
        }

        @Override
        public final Builder generationStatus(GenerationStatus generationStatus) {
            this.generationStatus(generationStatus == null ? null : generationStatus.toString());
            return this;
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public GenerationSummary build() {
            return new GenerationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
