/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the bot or bot locale that you want to import. You can specify the
 * <code>botImportSpecification</code> or the <code>botLocaleImportSpecification</code>, but not both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportResourceSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<ImportResourceSpecification.Builder, ImportResourceSpecification> {
    private static final SdkField<BotImportSpecification> BOT_IMPORT_SPECIFICATION_FIELD = SdkField
            .<BotImportSpecification> builder(MarshallingType.SDK_POJO).memberName("botImportSpecification")
            .getter(getter(ImportResourceSpecification::botImportSpecification)).setter(setter(Builder::botImportSpecification))
            .constructor(BotImportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botImportSpecification").build())
            .build();

    private static final SdkField<BotLocaleImportSpecification> BOT_LOCALE_IMPORT_SPECIFICATION_FIELD = SdkField
            .<BotLocaleImportSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("botLocaleImportSpecification")
            .getter(getter(ImportResourceSpecification::botLocaleImportSpecification))
            .setter(setter(Builder::botLocaleImportSpecification))
            .constructor(BotLocaleImportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botLocaleImportSpecification")
                    .build()).build();

    private static final SdkField<CustomVocabularyImportSpecification> CUSTOM_VOCABULARY_IMPORT_SPECIFICATION_FIELD = SdkField
            .<CustomVocabularyImportSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("customVocabularyImportSpecification")
            .getter(getter(ImportResourceSpecification::customVocabularyImportSpecification))
            .setter(setter(Builder::customVocabularyImportSpecification))
            .constructor(CustomVocabularyImportSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("customVocabularyImportSpecification").build()).build();

    private static final SdkField<TestSetImportResourceSpecification> TEST_SET_IMPORT_RESOURCE_SPECIFICATION_FIELD = SdkField
            .<TestSetImportResourceSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("testSetImportResourceSpecification")
            .getter(getter(ImportResourceSpecification::testSetImportResourceSpecification))
            .setter(setter(Builder::testSetImportResourceSpecification))
            .constructor(TestSetImportResourceSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetImportResourceSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BOT_IMPORT_SPECIFICATION_FIELD, BOT_LOCALE_IMPORT_SPECIFICATION_FIELD, CUSTOM_VOCABULARY_IMPORT_SPECIFICATION_FIELD,
            TEST_SET_IMPORT_RESOURCE_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BotImportSpecification botImportSpecification;

    private final BotLocaleImportSpecification botLocaleImportSpecification;

    private final CustomVocabularyImportSpecification customVocabularyImportSpecification;

    private final TestSetImportResourceSpecification testSetImportResourceSpecification;

    private ImportResourceSpecification(BuilderImpl builder) {
        this.botImportSpecification = builder.botImportSpecification;
        this.botLocaleImportSpecification = builder.botLocaleImportSpecification;
        this.customVocabularyImportSpecification = builder.customVocabularyImportSpecification;
        this.testSetImportResourceSpecification = builder.testSetImportResourceSpecification;
    }

    /**
     * <p>
     * Parameters for importing a bot.
     * </p>
     * 
     * @return Parameters for importing a bot.
     */
    public final BotImportSpecification botImportSpecification() {
        return botImportSpecification;
    }

    /**
     * <p>
     * Parameters for importing a bot locale.
     * </p>
     * 
     * @return Parameters for importing a bot locale.
     */
    public final BotLocaleImportSpecification botLocaleImportSpecification() {
        return botLocaleImportSpecification;
    }

    /**
     * Returns the value of the CustomVocabularyImportSpecification property for this object.
     * 
     * @return The value of the CustomVocabularyImportSpecification property for this object.
     */
    public final CustomVocabularyImportSpecification customVocabularyImportSpecification() {
        return customVocabularyImportSpecification;
    }

    /**
     * <p>
     * Specifications for the test set that is imported.
     * </p>
     * 
     * @return Specifications for the test set that is imported.
     */
    public final TestSetImportResourceSpecification testSetImportResourceSpecification() {
        return testSetImportResourceSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(botImportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(botLocaleImportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(customVocabularyImportSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(testSetImportResourceSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportResourceSpecification)) {
            return false;
        }
        ImportResourceSpecification other = (ImportResourceSpecification) obj;
        return Objects.equals(botImportSpecification(), other.botImportSpecification())
                && Objects.equals(botLocaleImportSpecification(), other.botLocaleImportSpecification())
                && Objects.equals(customVocabularyImportSpecification(), other.customVocabularyImportSpecification())
                && Objects.equals(testSetImportResourceSpecification(), other.testSetImportResourceSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportResourceSpecification").add("BotImportSpecification", botImportSpecification())
                .add("BotLocaleImportSpecification", botLocaleImportSpecification())
                .add("CustomVocabularyImportSpecification", customVocabularyImportSpecification())
                .add("TestSetImportResourceSpecification", testSetImportResourceSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botImportSpecification":
            return Optional.ofNullable(clazz.cast(botImportSpecification()));
        case "botLocaleImportSpecification":
            return Optional.ofNullable(clazz.cast(botLocaleImportSpecification()));
        case "customVocabularyImportSpecification":
            return Optional.ofNullable(clazz.cast(customVocabularyImportSpecification()));
        case "testSetImportResourceSpecification":
            return Optional.ofNullable(clazz.cast(testSetImportResourceSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botImportSpecification", BOT_IMPORT_SPECIFICATION_FIELD);
        map.put("botLocaleImportSpecification", BOT_LOCALE_IMPORT_SPECIFICATION_FIELD);
        map.put("customVocabularyImportSpecification", CUSTOM_VOCABULARY_IMPORT_SPECIFICATION_FIELD);
        map.put("testSetImportResourceSpecification", TEST_SET_IMPORT_RESOURCE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportResourceSpecification, T> g) {
        return obj -> g.apply((ImportResourceSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImportResourceSpecification> {
        /**
         * <p>
         * Parameters for importing a bot.
         * </p>
         * 
         * @param botImportSpecification
         *        Parameters for importing a bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botImportSpecification(BotImportSpecification botImportSpecification);

        /**
         * <p>
         * Parameters for importing a bot.
         * </p>
         * This is a convenience method that creates an instance of the {@link BotImportSpecification.Builder} avoiding
         * the need to create one manually via {@link BotImportSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BotImportSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #botImportSpecification(BotImportSpecification)}.
         * 
         * @param botImportSpecification
         *        a consumer that will call methods on {@link BotImportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botImportSpecification(BotImportSpecification)
         */
        default Builder botImportSpecification(Consumer<BotImportSpecification.Builder> botImportSpecification) {
            return botImportSpecification(BotImportSpecification.builder().applyMutation(botImportSpecification).build());
        }

        /**
         * <p>
         * Parameters for importing a bot locale.
         * </p>
         * 
         * @param botLocaleImportSpecification
         *        Parameters for importing a bot locale.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botLocaleImportSpecification(BotLocaleImportSpecification botLocaleImportSpecification);

        /**
         * <p>
         * Parameters for importing a bot locale.
         * </p>
         * This is a convenience method that creates an instance of the {@link BotLocaleImportSpecification.Builder}
         * avoiding the need to create one manually via {@link BotLocaleImportSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BotLocaleImportSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #botLocaleImportSpecification(BotLocaleImportSpecification)}.
         * 
         * @param botLocaleImportSpecification
         *        a consumer that will call methods on {@link BotLocaleImportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botLocaleImportSpecification(BotLocaleImportSpecification)
         */
        default Builder botLocaleImportSpecification(Consumer<BotLocaleImportSpecification.Builder> botLocaleImportSpecification) {
            return botLocaleImportSpecification(BotLocaleImportSpecification.builder()
                    .applyMutation(botLocaleImportSpecification).build());
        }

        /**
         * Sets the value of the CustomVocabularyImportSpecification property for this object.
         *
         * @param customVocabularyImportSpecification
         *        The new value for the CustomVocabularyImportSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customVocabularyImportSpecification(CustomVocabularyImportSpecification customVocabularyImportSpecification);

        /**
         * Sets the value of the CustomVocabularyImportSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link CustomVocabularyImportSpecification.Builder} avoiding the need to create one manually via
         * {@link CustomVocabularyImportSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomVocabularyImportSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #customVocabularyImportSpecification(CustomVocabularyImportSpecification)}.
         * 
         * @param customVocabularyImportSpecification
         *        a consumer that will call methods on {@link CustomVocabularyImportSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customVocabularyImportSpecification(CustomVocabularyImportSpecification)
         */
        default Builder customVocabularyImportSpecification(
                Consumer<CustomVocabularyImportSpecification.Builder> customVocabularyImportSpecification) {
            return customVocabularyImportSpecification(CustomVocabularyImportSpecification.builder()
                    .applyMutation(customVocabularyImportSpecification).build());
        }

        /**
         * <p>
         * Specifications for the test set that is imported.
         * </p>
         * 
         * @param testSetImportResourceSpecification
         *        Specifications for the test set that is imported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSetImportResourceSpecification(TestSetImportResourceSpecification testSetImportResourceSpecification);

        /**
         * <p>
         * Specifications for the test set that is imported.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TestSetImportResourceSpecification.Builder} avoiding the need to create one manually via
         * {@link TestSetImportResourceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSetImportResourceSpecification.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #testSetImportResourceSpecification(TestSetImportResourceSpecification)}.
         * 
         * @param testSetImportResourceSpecification
         *        a consumer that will call methods on {@link TestSetImportResourceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testSetImportResourceSpecification(TestSetImportResourceSpecification)
         */
        default Builder testSetImportResourceSpecification(
                Consumer<TestSetImportResourceSpecification.Builder> testSetImportResourceSpecification) {
            return testSetImportResourceSpecification(TestSetImportResourceSpecification.builder()
                    .applyMutation(testSetImportResourceSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BotImportSpecification botImportSpecification;

        private BotLocaleImportSpecification botLocaleImportSpecification;

        private CustomVocabularyImportSpecification customVocabularyImportSpecification;

        private TestSetImportResourceSpecification testSetImportResourceSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportResourceSpecification model) {
            botImportSpecification(model.botImportSpecification);
            botLocaleImportSpecification(model.botLocaleImportSpecification);
            customVocabularyImportSpecification(model.customVocabularyImportSpecification);
            testSetImportResourceSpecification(model.testSetImportResourceSpecification);
        }

        public final BotImportSpecification.Builder getBotImportSpecification() {
            return botImportSpecification != null ? botImportSpecification.toBuilder() : null;
        }

        public final void setBotImportSpecification(BotImportSpecification.BuilderImpl botImportSpecification) {
            this.botImportSpecification = botImportSpecification != null ? botImportSpecification.build() : null;
        }

        @Override
        public final Builder botImportSpecification(BotImportSpecification botImportSpecification) {
            this.botImportSpecification = botImportSpecification;
            return this;
        }

        public final BotLocaleImportSpecification.Builder getBotLocaleImportSpecification() {
            return botLocaleImportSpecification != null ? botLocaleImportSpecification.toBuilder() : null;
        }

        public final void setBotLocaleImportSpecification(BotLocaleImportSpecification.BuilderImpl botLocaleImportSpecification) {
            this.botLocaleImportSpecification = botLocaleImportSpecification != null ? botLocaleImportSpecification.build()
                    : null;
        }

        @Override
        public final Builder botLocaleImportSpecification(BotLocaleImportSpecification botLocaleImportSpecification) {
            this.botLocaleImportSpecification = botLocaleImportSpecification;
            return this;
        }

        public final CustomVocabularyImportSpecification.Builder getCustomVocabularyImportSpecification() {
            return customVocabularyImportSpecification != null ? customVocabularyImportSpecification.toBuilder() : null;
        }

        public final void setCustomVocabularyImportSpecification(
                CustomVocabularyImportSpecification.BuilderImpl customVocabularyImportSpecification) {
            this.customVocabularyImportSpecification = customVocabularyImportSpecification != null ? customVocabularyImportSpecification
                    .build() : null;
        }

        @Override
        public final Builder customVocabularyImportSpecification(
                CustomVocabularyImportSpecification customVocabularyImportSpecification) {
            this.customVocabularyImportSpecification = customVocabularyImportSpecification;
            return this;
        }

        public final TestSetImportResourceSpecification.Builder getTestSetImportResourceSpecification() {
            return testSetImportResourceSpecification != null ? testSetImportResourceSpecification.toBuilder() : null;
        }

        public final void setTestSetImportResourceSpecification(
                TestSetImportResourceSpecification.BuilderImpl testSetImportResourceSpecification) {
            this.testSetImportResourceSpecification = testSetImportResourceSpecification != null ? testSetImportResourceSpecification
                    .build() : null;
        }

        @Override
        public final Builder testSetImportResourceSpecification(
                TestSetImportResourceSpecification testSetImportResourceSpecification) {
            this.testSetImportResourceSpecification = testSetImportResourceSpecification;
            return this;
        }

        @Override
        public ImportResourceSpecification build() {
            return new ImportResourceSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
