/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration setting for a response sent to the user before Amazon Lex starts eliciting slots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InitialResponseSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<InitialResponseSetting.Builder, InitialResponseSetting> {
    private static final SdkField<ResponseSpecification> INITIAL_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("initialResponse")
            .getter(getter(InitialResponseSetting::initialResponse)).setter(setter(Builder::initialResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialResponse").build()).build();

    private static final SdkField<DialogState> NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("nextStep").getter(getter(InitialResponseSetting::nextStep)).setter(setter(Builder::nextStep))
            .constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextStep").build()).build();

    private static final SdkField<ConditionalSpecification> CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("conditional")
            .getter(getter(InitialResponseSetting::conditional)).setter(setter(Builder::conditional))
            .constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditional").build()).build();

    private static final SdkField<DialogCodeHookInvocationSetting> CODE_HOOK_FIELD = SdkField
            .<DialogCodeHookInvocationSetting> builder(MarshallingType.SDK_POJO).memberName("codeHook")
            .getter(getter(InitialResponseSetting::codeHook)).setter(setter(Builder::codeHook))
            .constructor(DialogCodeHookInvocationSetting::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeHook").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_RESPONSE_FIELD,
            NEXT_STEP_FIELD, CONDITIONAL_FIELD, CODE_HOOK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResponseSpecification initialResponse;

    private final DialogState nextStep;

    private final ConditionalSpecification conditional;

    private final DialogCodeHookInvocationSetting codeHook;

    private InitialResponseSetting(BuilderImpl builder) {
        this.initialResponse = builder.initialResponse;
        this.nextStep = builder.nextStep;
        this.conditional = builder.conditional;
        this.codeHook = builder.codeHook;
    }

    /**
     * Returns the value of the InitialResponse property for this object.
     * 
     * @return The value of the InitialResponse property for this object.
     */
    public final ResponseSpecification initialResponse() {
        return initialResponse;
    }

    /**
     * <p>
     * The next step in the conversation.
     * </p>
     * 
     * @return The next step in the conversation.
     */
    public final DialogState nextStep() {
        return nextStep;
    }

    /**
     * Returns the value of the Conditional property for this object.
     * 
     * @return The value of the Conditional property for this object.
     */
    public final ConditionalSpecification conditional() {
        return conditional;
    }

    /**
     * Returns the value of the CodeHook property for this object.
     * 
     * @return The value of the CodeHook property for this object.
     */
    public final DialogCodeHookInvocationSetting codeHook() {
        return codeHook;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialResponse());
        hashCode = 31 * hashCode + Objects.hashCode(nextStep());
        hashCode = 31 * hashCode + Objects.hashCode(conditional());
        hashCode = 31 * hashCode + Objects.hashCode(codeHook());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InitialResponseSetting)) {
            return false;
        }
        InitialResponseSetting other = (InitialResponseSetting) obj;
        return Objects.equals(initialResponse(), other.initialResponse()) && Objects.equals(nextStep(), other.nextStep())
                && Objects.equals(conditional(), other.conditional()) && Objects.equals(codeHook(), other.codeHook());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InitialResponseSetting").add("InitialResponse", initialResponse()).add("NextStep", nextStep())
                .add("Conditional", conditional()).add("CodeHook", codeHook()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "initialResponse":
            return Optional.ofNullable(clazz.cast(initialResponse()));
        case "nextStep":
            return Optional.ofNullable(clazz.cast(nextStep()));
        case "conditional":
            return Optional.ofNullable(clazz.cast(conditional()));
        case "codeHook":
            return Optional.ofNullable(clazz.cast(codeHook()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("initialResponse", INITIAL_RESPONSE_FIELD);
        map.put("nextStep", NEXT_STEP_FIELD);
        map.put("conditional", CONDITIONAL_FIELD);
        map.put("codeHook", CODE_HOOK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InitialResponseSetting, T> g) {
        return obj -> g.apply((InitialResponseSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InitialResponseSetting> {
        /**
         * Sets the value of the InitialResponse property for this object.
         *
         * @param initialResponse
         *        The new value for the InitialResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialResponse(ResponseSpecification initialResponse);

        /**
         * Sets the value of the InitialResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #initialResponse(ResponseSpecification)}.
         * 
         * @param initialResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #initialResponse(ResponseSpecification)
         */
        default Builder initialResponse(Consumer<ResponseSpecification.Builder> initialResponse) {
            return initialResponse(ResponseSpecification.builder().applyMutation(initialResponse).build());
        }

        /**
         * <p>
         * The next step in the conversation.
         * </p>
         * 
         * @param nextStep
         *        The next step in the conversation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextStep(DialogState nextStep);

        /**
         * <p>
         * The next step in the conversation.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #nextStep(DialogState)}.
         * 
         * @param nextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextStep(DialogState)
         */
        default Builder nextStep(Consumer<DialogState.Builder> nextStep) {
            return nextStep(DialogState.builder().applyMutation(nextStep).build());
        }

        /**
         * Sets the value of the Conditional property for this object.
         *
         * @param conditional
         *        The new value for the Conditional property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditional(ConditionalSpecification conditional);

        /**
         * Sets the value of the Conditional property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #conditional(ConditionalSpecification)}.
         * 
         * @param conditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditional(ConditionalSpecification)
         */
        default Builder conditional(Consumer<ConditionalSpecification.Builder> conditional) {
            return conditional(ConditionalSpecification.builder().applyMutation(conditional).build());
        }

        /**
         * Sets the value of the CodeHook property for this object.
         *
         * @param codeHook
         *        The new value for the CodeHook property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeHook(DialogCodeHookInvocationSetting codeHook);

        /**
         * Sets the value of the CodeHook property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DialogCodeHookInvocationSetting.Builder}
         * avoiding the need to create one manually via {@link DialogCodeHookInvocationSetting#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogCodeHookInvocationSetting.Builder#build()} is called
         * immediately and its result is passed to {@link #codeHook(DialogCodeHookInvocationSetting)}.
         * 
         * @param codeHook
         *        a consumer that will call methods on {@link DialogCodeHookInvocationSetting.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #codeHook(DialogCodeHookInvocationSetting)
         */
        default Builder codeHook(Consumer<DialogCodeHookInvocationSetting.Builder> codeHook) {
            return codeHook(DialogCodeHookInvocationSetting.builder().applyMutation(codeHook).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResponseSpecification initialResponse;

        private DialogState nextStep;

        private ConditionalSpecification conditional;

        private DialogCodeHookInvocationSetting codeHook;

        private BuilderImpl() {
        }

        private BuilderImpl(InitialResponseSetting model) {
            initialResponse(model.initialResponse);
            nextStep(model.nextStep);
            conditional(model.conditional);
            codeHook(model.codeHook);
        }

        public final ResponseSpecification.Builder getInitialResponse() {
            return initialResponse != null ? initialResponse.toBuilder() : null;
        }

        public final void setInitialResponse(ResponseSpecification.BuilderImpl initialResponse) {
            this.initialResponse = initialResponse != null ? initialResponse.build() : null;
        }

        @Override
        public final Builder initialResponse(ResponseSpecification initialResponse) {
            this.initialResponse = initialResponse;
            return this;
        }

        public final DialogState.Builder getNextStep() {
            return nextStep != null ? nextStep.toBuilder() : null;
        }

        public final void setNextStep(DialogState.BuilderImpl nextStep) {
            this.nextStep = nextStep != null ? nextStep.build() : null;
        }

        @Override
        public final Builder nextStep(DialogState nextStep) {
            this.nextStep = nextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getConditional() {
            return conditional != null ? conditional.toBuilder() : null;
        }

        public final void setConditional(ConditionalSpecification.BuilderImpl conditional) {
            this.conditional = conditional != null ? conditional.build() : null;
        }

        @Override
        public final Builder conditional(ConditionalSpecification conditional) {
            this.conditional = conditional;
            return this;
        }

        public final DialogCodeHookInvocationSetting.Builder getCodeHook() {
            return codeHook != null ? codeHook.toBuilder() : null;
        }

        public final void setCodeHook(DialogCodeHookInvocationSetting.BuilderImpl codeHook) {
            this.codeHook = codeHook != null ? codeHook.build() : null;
        }

        @Override
        public final Builder codeHook(DialogCodeHookInvocationSetting codeHook) {
            this.codeHook = codeHook;
            return this;
        }

        @Override
        public InitialResponseSetting build() {
            return new InitialResponseSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
