/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifications for the current state of the dialog between the user and the bot in the test set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InputSessionStateSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<InputSessionStateSpecification.Builder, InputSessionStateSpecification> {
    private static final SdkField<Map<String, String>> SESSION_ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("sessionAttributes")
            .getter(getter(InputSessionStateSpecification::sessionAttributes))
            .setter(setter(Builder::sessionAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionAttributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<ActiveContext>> ACTIVE_CONTEXTS_FIELD = SdkField
            .<List<ActiveContext>> builder(MarshallingType.LIST)
            .memberName("activeContexts")
            .getter(getter(InputSessionStateSpecification::activeContexts))
            .setter(setter(Builder::activeContexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeContexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActiveContext> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActiveContext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RuntimeHints> RUNTIME_HINTS_FIELD = SdkField.<RuntimeHints> builder(MarshallingType.SDK_POJO)
            .memberName("runtimeHints").getter(getter(InputSessionStateSpecification::runtimeHints))
            .setter(setter(Builder::runtimeHints)).constructor(RuntimeHints::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeHints").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ATTRIBUTES_FIELD,
            ACTIVE_CONTEXTS_FIELD, RUNTIME_HINTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> sessionAttributes;

    private final List<ActiveContext> activeContexts;

    private final RuntimeHints runtimeHints;

    private InputSessionStateSpecification(BuilderImpl builder) {
        this.sessionAttributes = builder.sessionAttributes;
        this.activeContexts = builder.activeContexts;
        this.runtimeHints = builder.runtimeHints;
    }

    /**
     * For responses, this returns true if the service returned a value for the SessionAttributes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSessionAttributes() {
        return sessionAttributes != null && !(sessionAttributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Session attributes for the session state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessionAttributes} method.
     * </p>
     * 
     * @return Session attributes for the session state.
     */
    public final Map<String, String> sessionAttributes() {
        return sessionAttributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActiveContexts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActiveContexts() {
        return activeContexts != null && !(activeContexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Active contexts for the session state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActiveContexts} method.
     * </p>
     * 
     * @return Active contexts for the session state.
     */
    public final List<ActiveContext> activeContexts() {
        return activeContexts;
    }

    /**
     * <p>
     * Runtime hints for the session state.
     * </p>
     * 
     * @return Runtime hints for the session state.
     */
    public final RuntimeHints runtimeHints() {
        return runtimeHints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSessionAttributes() ? sessionAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActiveContexts() ? activeContexts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(runtimeHints());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InputSessionStateSpecification)) {
            return false;
        }
        InputSessionStateSpecification other = (InputSessionStateSpecification) obj;
        return hasSessionAttributes() == other.hasSessionAttributes()
                && Objects.equals(sessionAttributes(), other.sessionAttributes())
                && hasActiveContexts() == other.hasActiveContexts() && Objects.equals(activeContexts(), other.activeContexts())
                && Objects.equals(runtimeHints(), other.runtimeHints());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InputSessionStateSpecification")
                .add("SessionAttributes", hasSessionAttributes() ? sessionAttributes() : null)
                .add("ActiveContexts", hasActiveContexts() ? activeContexts() : null).add("RuntimeHints", runtimeHints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionAttributes":
            return Optional.ofNullable(clazz.cast(sessionAttributes()));
        case "activeContexts":
            return Optional.ofNullable(clazz.cast(activeContexts()));
        case "runtimeHints":
            return Optional.ofNullable(clazz.cast(runtimeHints()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionAttributes", SESSION_ATTRIBUTES_FIELD);
        map.put("activeContexts", ACTIVE_CONTEXTS_FIELD);
        map.put("runtimeHints", RUNTIME_HINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InputSessionStateSpecification, T> g) {
        return obj -> g.apply((InputSessionStateSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InputSessionStateSpecification> {
        /**
         * <p>
         * Session attributes for the session state.
         * </p>
         * 
         * @param sessionAttributes
         *        Session attributes for the session state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionAttributes(Map<String, String> sessionAttributes);

        /**
         * <p>
         * Active contexts for the session state.
         * </p>
         * 
         * @param activeContexts
         *        Active contexts for the session state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(Collection<ActiveContext> activeContexts);

        /**
         * <p>
         * Active contexts for the session state.
         * </p>
         * 
         * @param activeContexts
         *        Active contexts for the session state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeContexts(ActiveContext... activeContexts);

        /**
         * <p>
         * Active contexts for the session state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext.Builder#build()} is called immediately
         * and its result is passed to {@link #activeContexts(List<ActiveContext>)}.
         * 
         * @param activeContexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.ActiveContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #activeContexts(java.util.Collection<ActiveContext>)
         */
        Builder activeContexts(Consumer<ActiveContext.Builder>... activeContexts);

        /**
         * <p>
         * Runtime hints for the session state.
         * </p>
         * 
         * @param runtimeHints
         *        Runtime hints for the session state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtimeHints(RuntimeHints runtimeHints);

        /**
         * <p>
         * Runtime hints for the session state.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuntimeHints.Builder} avoiding the need
         * to create one manually via {@link RuntimeHints#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuntimeHints.Builder#build()} is called immediately and its
         * result is passed to {@link #runtimeHints(RuntimeHints)}.
         * 
         * @param runtimeHints
         *        a consumer that will call methods on {@link RuntimeHints.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtimeHints(RuntimeHints)
         */
        default Builder runtimeHints(Consumer<RuntimeHints.Builder> runtimeHints) {
            return runtimeHints(RuntimeHints.builder().applyMutation(runtimeHints).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> sessionAttributes = DefaultSdkAutoConstructMap.getInstance();

        private List<ActiveContext> activeContexts = DefaultSdkAutoConstructList.getInstance();

        private RuntimeHints runtimeHints;

        private BuilderImpl() {
        }

        private BuilderImpl(InputSessionStateSpecification model) {
            sessionAttributes(model.sessionAttributes);
            activeContexts(model.activeContexts);
            runtimeHints(model.runtimeHints);
        }

        public final Map<String, String> getSessionAttributes() {
            if (sessionAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return sessionAttributes;
        }

        public final void setSessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
        }

        @Override
        public final Builder sessionAttributes(Map<String, String> sessionAttributes) {
            this.sessionAttributes = StringMapCopier.copy(sessionAttributes);
            return this;
        }

        public final List<ActiveContext.Builder> getActiveContexts() {
            List<ActiveContext.Builder> result = ActiveContextListCopier.copyToBuilder(this.activeContexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActiveContexts(Collection<ActiveContext.BuilderImpl> activeContexts) {
            this.activeContexts = ActiveContextListCopier.copyFromBuilder(activeContexts);
        }

        @Override
        public final Builder activeContexts(Collection<ActiveContext> activeContexts) {
            this.activeContexts = ActiveContextListCopier.copy(activeContexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(ActiveContext... activeContexts) {
            activeContexts(Arrays.asList(activeContexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder activeContexts(Consumer<ActiveContext.Builder>... activeContexts) {
            activeContexts(Stream.of(activeContexts).map(c -> ActiveContext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final RuntimeHints.Builder getRuntimeHints() {
            return runtimeHints != null ? runtimeHints.toBuilder() : null;
        }

        public final void setRuntimeHints(RuntimeHints.BuilderImpl runtimeHints) {
            this.runtimeHints = runtimeHints != null ? runtimeHints.build() : null;
        }

        @Override
        public final Builder runtimeHints(RuntimeHints runtimeHints) {
            this.runtimeHints = runtimeHints;
            return this;
        }

        @Override
        public InputSessionStateSpecification build() {
            return new InputSessionStateSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
