/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information for an intent that is classified by the test workbench.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntentClassificationTestResultItem implements SdkPojo, Serializable,
        ToCopyableBuilder<IntentClassificationTestResultItem.Builder, IntentClassificationTestResultItem> {
    private static final SdkField<String> INTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("intentName").getter(getter(IntentClassificationTestResultItem::intentName))
            .setter(setter(Builder::intentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("intentName").build()).build();

    private static final SdkField<Boolean> MULTI_TURN_CONVERSATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("multiTurnConversation").getter(getter(IntentClassificationTestResultItem::multiTurnConversation))
            .setter(setter(Builder::multiTurnConversation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multiTurnConversation").build())
            .build();

    private static final SdkField<IntentClassificationTestResultItemCounts> RESULT_COUNTS_FIELD = SdkField
            .<IntentClassificationTestResultItemCounts> builder(MarshallingType.SDK_POJO).memberName("resultCounts")
            .getter(getter(IntentClassificationTestResultItem::resultCounts)).setter(setter(Builder::resultCounts))
            .constructor(IntentClassificationTestResultItemCounts::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resultCounts").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTENT_NAME_FIELD,
            MULTI_TURN_CONVERSATION_FIELD, RESULT_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String intentName;

    private final Boolean multiTurnConversation;

    private final IntentClassificationTestResultItemCounts resultCounts;

    private IntentClassificationTestResultItem(BuilderImpl builder) {
        this.intentName = builder.intentName;
        this.multiTurnConversation = builder.multiTurnConversation;
        this.resultCounts = builder.resultCounts;
    }

    /**
     * <p>
     * The name of the intent.
     * </p>
     * 
     * @return The name of the intent.
     */
    public final String intentName() {
        return intentName;
    }

    /**
     * <p>
     * Indicates whether the conversation involves multiple turns or not.
     * </p>
     * 
     * @return Indicates whether the conversation involves multiple turns or not.
     */
    public final Boolean multiTurnConversation() {
        return multiTurnConversation;
    }

    /**
     * <p>
     * The result of the intent classification test.
     * </p>
     * 
     * @return The result of the intent classification test.
     */
    public final IntentClassificationTestResultItemCounts resultCounts() {
        return resultCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(intentName());
        hashCode = 31 * hashCode + Objects.hashCode(multiTurnConversation());
        hashCode = 31 * hashCode + Objects.hashCode(resultCounts());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntentClassificationTestResultItem)) {
            return false;
        }
        IntentClassificationTestResultItem other = (IntentClassificationTestResultItem) obj;
        return Objects.equals(intentName(), other.intentName())
                && Objects.equals(multiTurnConversation(), other.multiTurnConversation())
                && Objects.equals(resultCounts(), other.resultCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntentClassificationTestResultItem").add("IntentName", intentName())
                .add("MultiTurnConversation", multiTurnConversation()).add("ResultCounts", resultCounts()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "intentName":
            return Optional.ofNullable(clazz.cast(intentName()));
        case "multiTurnConversation":
            return Optional.ofNullable(clazz.cast(multiTurnConversation()));
        case "resultCounts":
            return Optional.ofNullable(clazz.cast(resultCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("intentName", INTENT_NAME_FIELD);
        map.put("multiTurnConversation", MULTI_TURN_CONVERSATION_FIELD);
        map.put("resultCounts", RESULT_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IntentClassificationTestResultItem, T> g) {
        return obj -> g.apply((IntentClassificationTestResultItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntentClassificationTestResultItem> {
        /**
         * <p>
         * The name of the intent.
         * </p>
         * 
         * @param intentName
         *        The name of the intent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intentName(String intentName);

        /**
         * <p>
         * Indicates whether the conversation involves multiple turns or not.
         * </p>
         * 
         * @param multiTurnConversation
         *        Indicates whether the conversation involves multiple turns or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiTurnConversation(Boolean multiTurnConversation);

        /**
         * <p>
         * The result of the intent classification test.
         * </p>
         * 
         * @param resultCounts
         *        The result of the intent classification test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultCounts(IntentClassificationTestResultItemCounts resultCounts);

        /**
         * <p>
         * The result of the intent classification test.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link IntentClassificationTestResultItemCounts.Builder} avoiding the need to create one manually via
         * {@link IntentClassificationTestResultItemCounts#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IntentClassificationTestResultItemCounts.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #resultCounts(IntentClassificationTestResultItemCounts)}.
         * 
         * @param resultCounts
         *        a consumer that will call methods on {@link IntentClassificationTestResultItemCounts.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultCounts(IntentClassificationTestResultItemCounts)
         */
        default Builder resultCounts(Consumer<IntentClassificationTestResultItemCounts.Builder> resultCounts) {
            return resultCounts(IntentClassificationTestResultItemCounts.builder().applyMutation(resultCounts).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String intentName;

        private Boolean multiTurnConversation;

        private IntentClassificationTestResultItemCounts resultCounts;

        private BuilderImpl() {
        }

        private BuilderImpl(IntentClassificationTestResultItem model) {
            intentName(model.intentName);
            multiTurnConversation(model.multiTurnConversation);
            resultCounts(model.resultCounts);
        }

        public final String getIntentName() {
            return intentName;
        }

        public final void setIntentName(String intentName) {
            this.intentName = intentName;
        }

        @Override
        public final Builder intentName(String intentName) {
            this.intentName = intentName;
            return this;
        }

        public final Boolean getMultiTurnConversation() {
            return multiTurnConversation;
        }

        public final void setMultiTurnConversation(Boolean multiTurnConversation) {
            this.multiTurnConversation = multiTurnConversation;
        }

        @Override
        public final Builder multiTurnConversation(Boolean multiTurnConversation) {
            this.multiTurnConversation = multiTurnConversation;
            return this;
        }

        public final IntentClassificationTestResultItemCounts.Builder getResultCounts() {
            return resultCounts != null ? resultCounts.toBuilder() : null;
        }

        public final void setResultCounts(IntentClassificationTestResultItemCounts.BuilderImpl resultCounts) {
            this.resultCounts = resultCounts != null ? resultCounts.build() : null;
        }

        @Override
        public final Builder resultCounts(IntentClassificationTestResultItemCounts resultCounts) {
            this.resultCounts = resultCounts;
            return this;
        }

        @Override
        public IntentClassificationTestResultItem build() {
            return new IntentClassificationTestResultItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
