/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListBotRecommendationsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListBotRecommendationsResponse.Builder, ListBotRecommendationsResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListBotRecommendationsResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> BOT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("botVersion").getter(getter(ListBotRecommendationsResponse::botVersion))
            .setter(setter(Builder::botVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botVersion").build()).build();

    private static final SdkField<String> LOCALE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("localeId").getter(getter(ListBotRecommendationsResponse::localeId)).setter(setter(Builder::localeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("localeId").build()).build();

    private static final SdkField<List<BotRecommendationSummary>> BOT_RECOMMENDATION_SUMMARIES_FIELD = SdkField
            .<List<BotRecommendationSummary>> builder(MarshallingType.LIST)
            .memberName("botRecommendationSummaries")
            .getter(getter(ListBotRecommendationsResponse::botRecommendationSummaries))
            .setter(setter(Builder::botRecommendationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botRecommendationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BotRecommendationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(BotRecommendationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListBotRecommendationsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            BOT_VERSION_FIELD, LOCALE_ID_FIELD, BOT_RECOMMENDATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String botVersion;

    private final String localeId;

    private final List<BotRecommendationSummary> botRecommendationSummaries;

    private final String nextToken;

    private ListBotRecommendationsResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.botVersion = builder.botVersion;
        this.localeId = builder.localeId;
        this.botRecommendationSummaries = builder.botRecommendationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The unique identifier of the bot that contains the bot recommendation list.
     * </p>
     * 
     * @return The unique identifier of the bot that contains the bot recommendation list.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * The version of the bot that contains the bot recommendation list.
     * </p>
     * 
     * @return The version of the bot that contains the bot recommendation list.
     */
    public final String botVersion() {
        return botVersion;
    }

    /**
     * <p>
     * The identifier of the language and locale of the bot recommendation list.
     * </p>
     * 
     * @return The identifier of the language and locale of the bot recommendation list.
     */
    public final String localeId() {
        return localeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the BotRecommendationSummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasBotRecommendationSummaries() {
        return botRecommendationSummaries != null && !(botRecommendationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Summary information for the bot recommendations that meet the filter specified in this request. The length of the
     * list is specified in the maxResults parameter of the request. If there are more bot recommendations available,
     * the nextToken field contains a token to get the next page of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBotRecommendationSummaries} method.
     * </p>
     * 
     * @return Summary information for the bot recommendations that meet the filter specified in this request. The
     *         length of the list is specified in the maxResults parameter of the request. If there are more bot
     *         recommendations available, the nextToken field contains a token to get the next page of results.
     */
    public final List<BotRecommendationSummary> botRecommendationSummaries() {
        return botRecommendationSummaries;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the ListBotRecommendations
     * operation. If the nextToken field is present, you send the contents as the nextToken parameter of a
     * ListBotRecommendations operation request to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         ListBotRecommendations operation. If the nextToken field is present, you send the contents as the
     *         nextToken parameter of a ListBotRecommendations operation request to get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(botVersion());
        hashCode = 31 * hashCode + Objects.hashCode(localeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasBotRecommendationSummaries() ? botRecommendationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBotRecommendationsResponse)) {
            return false;
        }
        ListBotRecommendationsResponse other = (ListBotRecommendationsResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(botVersion(), other.botVersion())
                && Objects.equals(localeId(), other.localeId())
                && hasBotRecommendationSummaries() == other.hasBotRecommendationSummaries()
                && Objects.equals(botRecommendationSummaries(), other.botRecommendationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListBotRecommendationsResponse").add("BotId", botId()).add("BotVersion", botVersion())
                .add("LocaleId", localeId())
                .add("BotRecommendationSummaries", hasBotRecommendationSummaries() ? botRecommendationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "botVersion":
            return Optional.ofNullable(clazz.cast(botVersion()));
        case "localeId":
            return Optional.ofNullable(clazz.cast(localeId()));
        case "botRecommendationSummaries":
            return Optional.ofNullable(clazz.cast(botRecommendationSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("botVersion", BOT_VERSION_FIELD);
        map.put("localeId", LOCALE_ID_FIELD);
        map.put("botRecommendationSummaries", BOT_RECOMMENDATION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListBotRecommendationsResponse, T> g) {
        return obj -> g.apply((ListBotRecommendationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListBotRecommendationsResponse> {
        /**
         * <p>
         * The unique identifier of the bot that contains the bot recommendation list.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that contains the bot recommendation list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * The version of the bot that contains the bot recommendation list.
         * </p>
         * 
         * @param botVersion
         *        The version of the bot that contains the bot recommendation list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botVersion(String botVersion);

        /**
         * <p>
         * The identifier of the language and locale of the bot recommendation list.
         * </p>
         * 
         * @param localeId
         *        The identifier of the language and locale of the bot recommendation list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder localeId(String localeId);

        /**
         * <p>
         * Summary information for the bot recommendations that meet the filter specified in this request. The length of
         * the list is specified in the maxResults parameter of the request. If there are more bot recommendations
         * available, the nextToken field contains a token to get the next page of results.
         * </p>
         * 
         * @param botRecommendationSummaries
         *        Summary information for the bot recommendations that meet the filter specified in this request. The
         *        length of the list is specified in the maxResults parameter of the request. If there are more bot
         *        recommendations available, the nextToken field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botRecommendationSummaries(Collection<BotRecommendationSummary> botRecommendationSummaries);

        /**
         * <p>
         * Summary information for the bot recommendations that meet the filter specified in this request. The length of
         * the list is specified in the maxResults parameter of the request. If there are more bot recommendations
         * available, the nextToken field contains a token to get the next page of results.
         * </p>
         * 
         * @param botRecommendationSummaries
         *        Summary information for the bot recommendations that meet the filter specified in this request. The
         *        length of the list is specified in the maxResults parameter of the request. If there are more bot
         *        recommendations available, the nextToken field contains a token to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botRecommendationSummaries(BotRecommendationSummary... botRecommendationSummaries);

        /**
         * <p>
         * Summary information for the bot recommendations that meet the filter specified in this request. The length of
         * the list is specified in the maxResults parameter of the request. If there are more bot recommendations
         * available, the nextToken field contains a token to get the next page of results.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #botRecommendationSummaries(List<BotRecommendationSummary>)}.
         * 
         * @param botRecommendationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.BotRecommendationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #botRecommendationSummaries(java.util.Collection<BotRecommendationSummary>)
         */
        Builder botRecommendationSummaries(Consumer<BotRecommendationSummary.Builder>... botRecommendationSummaries);

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the ListBotRecommendations
         * operation. If the nextToken field is present, you send the contents as the nextToken parameter of a
         * ListBotRecommendations operation request to get the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        ListBotRecommendations operation. If the nextToken field is present, you send the contents as the
         *        nextToken parameter of a ListBotRecommendations operation request to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String botVersion;

        private String localeId;

        private List<BotRecommendationSummary> botRecommendationSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBotRecommendationsResponse model) {
            super(model);
            botId(model.botId);
            botVersion(model.botVersion);
            localeId(model.localeId);
            botRecommendationSummaries(model.botRecommendationSummaries);
            nextToken(model.nextToken);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getBotVersion() {
            return botVersion;
        }

        public final void setBotVersion(String botVersion) {
            this.botVersion = botVersion;
        }

        @Override
        public final Builder botVersion(String botVersion) {
            this.botVersion = botVersion;
            return this;
        }

        public final String getLocaleId() {
            return localeId;
        }

        public final void setLocaleId(String localeId) {
            this.localeId = localeId;
        }

        @Override
        public final Builder localeId(String localeId) {
            this.localeId = localeId;
            return this;
        }

        public final List<BotRecommendationSummary.Builder> getBotRecommendationSummaries() {
            List<BotRecommendationSummary.Builder> result = BotRecommendationSummaryListCopier
                    .copyToBuilder(this.botRecommendationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBotRecommendationSummaries(
                Collection<BotRecommendationSummary.BuilderImpl> botRecommendationSummaries) {
            this.botRecommendationSummaries = BotRecommendationSummaryListCopier.copyFromBuilder(botRecommendationSummaries);
        }

        @Override
        public final Builder botRecommendationSummaries(Collection<BotRecommendationSummary> botRecommendationSummaries) {
            this.botRecommendationSummaries = BotRecommendationSummaryListCopier.copy(botRecommendationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botRecommendationSummaries(BotRecommendationSummary... botRecommendationSummaries) {
            botRecommendationSummaries(Arrays.asList(botRecommendationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder botRecommendationSummaries(Consumer<BotRecommendationSummary.Builder>... botRecommendationSummaries) {
            botRecommendationSummaries(Stream.of(botRecommendationSummaries)
                    .map(c -> BotRecommendationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListBotRecommendationsResponse build() {
            return new ListBotRecommendationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
