/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTestExecutionResultItemsResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListTestExecutionResultItemsResponse.Builder, ListTestExecutionResultItemsResponse> {
    private static final SdkField<TestExecutionResultItems> TEST_EXECUTION_RESULTS_FIELD = SdkField
            .<TestExecutionResultItems> builder(MarshallingType.SDK_POJO).memberName("testExecutionResults")
            .getter(getter(ListTestExecutionResultItemsResponse::testExecutionResults))
            .setter(setter(Builder::testExecutionResults)).constructor(TestExecutionResultItems::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testExecutionResults").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTestExecutionResultItemsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_EXECUTION_RESULTS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TestExecutionResultItems testExecutionResults;

    private final String nextToken;

    private ListTestExecutionResultItemsResponse(BuilderImpl builder) {
        super(builder);
        this.testExecutionResults = builder.testExecutionResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The list of results from the test execution.
     * </p>
     * 
     * @return The list of results from the test execution.
     */
    public final TestExecutionResultItems testExecutionResults() {
        return testExecutionResults;
    }

    /**
     * <p>
     * A token that indicates whether there are more results to return in a response to the
     * <code>ListTestExecutionResultItems</code> operation. If the <code>nextToken</code> field is present, you send the
     * contents as the <code>nextToken</code> parameter of a <code>ListTestExecutionResultItems</code> operation request
     * to get the next page of results.
     * </p>
     * 
     * @return A token that indicates whether there are more results to return in a response to the
     *         <code>ListTestExecutionResultItems</code> operation. If the <code>nextToken</code> field is present, you
     *         send the contents as the <code>nextToken</code> parameter of a <code>ListTestExecutionResultItems</code>
     *         operation request to get the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testExecutionResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestExecutionResultItemsResponse)) {
            return false;
        }
        ListTestExecutionResultItemsResponse other = (ListTestExecutionResultItemsResponse) obj;
        return Objects.equals(testExecutionResults(), other.testExecutionResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTestExecutionResultItemsResponse").add("TestExecutionResults", testExecutionResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testExecutionResults":
            return Optional.ofNullable(clazz.cast(testExecutionResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testExecutionResults", TEST_EXECUTION_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestExecutionResultItemsResponse, T> g) {
        return obj -> g.apply((ListTestExecutionResultItemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTestExecutionResultItemsResponse> {
        /**
         * <p>
         * The list of results from the test execution.
         * </p>
         * 
         * @param testExecutionResults
         *        The list of results from the test execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testExecutionResults(TestExecutionResultItems testExecutionResults);

        /**
         * <p>
         * The list of results from the test execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestExecutionResultItems.Builder}
         * avoiding the need to create one manually via {@link TestExecutionResultItems#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestExecutionResultItems.Builder#build()} is called immediately
         * and its result is passed to {@link #testExecutionResults(TestExecutionResultItems)}.
         * 
         * @param testExecutionResults
         *        a consumer that will call methods on {@link TestExecutionResultItems.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testExecutionResults(TestExecutionResultItems)
         */
        default Builder testExecutionResults(Consumer<TestExecutionResultItems.Builder> testExecutionResults) {
            return testExecutionResults(TestExecutionResultItems.builder().applyMutation(testExecutionResults).build());
        }

        /**
         * <p>
         * A token that indicates whether there are more results to return in a response to the
         * <code>ListTestExecutionResultItems</code> operation. If the <code>nextToken</code> field is present, you send
         * the contents as the <code>nextToken</code> parameter of a <code>ListTestExecutionResultItems</code> operation
         * request to get the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token that indicates whether there are more results to return in a response to the
         *        <code>ListTestExecutionResultItems</code> operation. If the <code>nextToken</code> field is present,
         *        you send the contents as the <code>nextToken</code> parameter of a
         *        <code>ListTestExecutionResultItems</code> operation request to get the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private TestExecutionResultItems testExecutionResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestExecutionResultItemsResponse model) {
            super(model);
            testExecutionResults(model.testExecutionResults);
            nextToken(model.nextToken);
        }

        public final TestExecutionResultItems.Builder getTestExecutionResults() {
            return testExecutionResults != null ? testExecutionResults.toBuilder() : null;
        }

        public final void setTestExecutionResults(TestExecutionResultItems.BuilderImpl testExecutionResults) {
            this.testExecutionResults = testExecutionResults != null ? testExecutionResults.build() : null;
        }

        @Override
        public final Builder testExecutionResults(TestExecutionResultItems testExecutionResults) {
            this.testExecutionResults = testExecutionResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestExecutionResultItemsResponse build() {
            return new ListTestExecutionResultItemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
