/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUtteranceAnalyticsDataResponse extends LexModelsV2Response implements
        ToCopyableBuilder<ListUtteranceAnalyticsDataResponse.Builder, ListUtteranceAnalyticsDataResponse> {
    private static final SdkField<String> BOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("botId")
            .getter(getter(ListUtteranceAnalyticsDataResponse::botId)).setter(setter(Builder::botId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("botId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListUtteranceAnalyticsDataResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<UtteranceSpecification>> UTTERANCES_FIELD = SdkField
            .<List<UtteranceSpecification>> builder(MarshallingType.LIST)
            .memberName("utterances")
            .getter(getter(ListUtteranceAnalyticsDataResponse::utterances))
            .setter(setter(Builder::utterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("utterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UtteranceSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(UtteranceSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOT_ID_FIELD,
            NEXT_TOKEN_FIELD, UTTERANCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String botId;

    private final String nextToken;

    private final List<UtteranceSpecification> utterances;

    private ListUtteranceAnalyticsDataResponse(BuilderImpl builder) {
        super(builder);
        this.botId = builder.botId;
        this.nextToken = builder.nextToken;
        this.utterances = builder.utterances;
    }

    /**
     * <p>
     * The unique identifier of the bot that the utterances belong to.
     * </p>
     * 
     * @return The unique identifier of the bot that the utterances belong to.
     */
    public final String botId() {
        return botId;
    }

    /**
     * <p>
     * If the response from the ListUtteranceAnalyticsData operation contains more results than specified in the
     * maxResults parameter, a token is returned in the response.
     * </p>
     * <p>
     * Use the returned token in the nextToken parameter of a ListUtteranceAnalyticsData request to return the next page
     * of results. For a complete set of results, call the ListUtteranceAnalyticsData operation until the nextToken
     * returned in the response is null.
     * </p>
     * 
     * @return If the response from the ListUtteranceAnalyticsData operation contains more results than specified in the
     *         maxResults parameter, a token is returned in the response.</p>
     *         <p>
     *         Use the returned token in the nextToken parameter of a ListUtteranceAnalyticsData request to return the
     *         next page of results. For a complete set of results, call the ListUtteranceAnalyticsData operation until
     *         the nextToken returned in the response is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Utterances property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUtterances() {
        return utterances != null && !(utterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains information about an utterance in a user session with your bot.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUtterances} method.
     * </p>
     * 
     * @return A list of objects, each of which contains information about an utterance in a user session with your bot.
     */
    public final List<UtteranceSpecification> utterances() {
        return utterances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(botId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasUtterances() ? utterances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUtteranceAnalyticsDataResponse)) {
            return false;
        }
        ListUtteranceAnalyticsDataResponse other = (ListUtteranceAnalyticsDataResponse) obj;
        return Objects.equals(botId(), other.botId()) && Objects.equals(nextToken(), other.nextToken())
                && hasUtterances() == other.hasUtterances() && Objects.equals(utterances(), other.utterances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUtteranceAnalyticsDataResponse").add("BotId", botId()).add("NextToken", nextToken())
                .add("Utterances", hasUtterances() ? utterances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "botId":
            return Optional.ofNullable(clazz.cast(botId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "utterances":
            return Optional.ofNullable(clazz.cast(utterances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("botId", BOT_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("utterances", UTTERANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListUtteranceAnalyticsDataResponse, T> g) {
        return obj -> g.apply((ListUtteranceAnalyticsDataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends LexModelsV2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, ListUtteranceAnalyticsDataResponse> {
        /**
         * <p>
         * The unique identifier of the bot that the utterances belong to.
         * </p>
         * 
         * @param botId
         *        The unique identifier of the bot that the utterances belong to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder botId(String botId);

        /**
         * <p>
         * If the response from the ListUtteranceAnalyticsData operation contains more results than specified in the
         * maxResults parameter, a token is returned in the response.
         * </p>
         * <p>
         * Use the returned token in the nextToken parameter of a ListUtteranceAnalyticsData request to return the next
         * page of results. For a complete set of results, call the ListUtteranceAnalyticsData operation until the
         * nextToken returned in the response is null.
         * </p>
         * 
         * @param nextToken
         *        If the response from the ListUtteranceAnalyticsData operation contains more results than specified in
         *        the maxResults parameter, a token is returned in the response.</p>
         *        <p>
         *        Use the returned token in the nextToken parameter of a ListUtteranceAnalyticsData request to return
         *        the next page of results. For a complete set of results, call the ListUtteranceAnalyticsData operation
         *        until the nextToken returned in the response is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A list of objects, each of which contains information about an utterance in a user session with your bot.
         * </p>
         * 
         * @param utterances
         *        A list of objects, each of which contains information about an utterance in a user session with your
         *        bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterances(Collection<UtteranceSpecification> utterances);

        /**
         * <p>
         * A list of objects, each of which contains information about an utterance in a user session with your bot.
         * </p>
         * 
         * @param utterances
         *        A list of objects, each of which contains information about an utterance in a user session with your
         *        bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder utterances(UtteranceSpecification... utterances);

        /**
         * <p>
         * A list of objects, each of which contains information about an utterance in a user session with your bot.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #utterances(List<UtteranceSpecification>)}.
         * 
         * @param utterances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.UtteranceSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #utterances(java.util.Collection<UtteranceSpecification>)
         */
        Builder utterances(Consumer<UtteranceSpecification.Builder>... utterances);
    }

    static final class BuilderImpl extends LexModelsV2Response.BuilderImpl implements Builder {
        private String botId;

        private String nextToken;

        private List<UtteranceSpecification> utterances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListUtteranceAnalyticsDataResponse model) {
            super(model);
            botId(model.botId);
            nextToken(model.nextToken);
            utterances(model.utterances);
        }

        public final String getBotId() {
            return botId;
        }

        public final void setBotId(String botId) {
            this.botId = botId;
        }

        @Override
        public final Builder botId(String botId) {
            this.botId = botId;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<UtteranceSpecification.Builder> getUtterances() {
            List<UtteranceSpecification.Builder> result = UtteranceSpecificationsCopier.copyToBuilder(this.utterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUtterances(Collection<UtteranceSpecification.BuilderImpl> utterances) {
            this.utterances = UtteranceSpecificationsCopier.copyFromBuilder(utterances);
        }

        @Override
        public final Builder utterances(Collection<UtteranceSpecification> utterances) {
            this.utterances = UtteranceSpecificationsCopier.copy(utterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(UtteranceSpecification... utterances) {
            utterances(Arrays.asList(utterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder utterances(Consumer<UtteranceSpecification.Builder>... utterances) {
            utterances(Stream.of(utterances).map(c -> UtteranceSpecification.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListUtteranceAnalyticsDataResponse build() {
            return new ListUtteranceAnalyticsDataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
