/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates whether a slot can return multiple values.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MultipleValuesSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<MultipleValuesSetting.Builder, MultipleValuesSetting> {
    private static final SdkField<Boolean> ALLOW_MULTIPLE_VALUES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowMultipleValues").getter(getter(MultipleValuesSetting::allowMultipleValues))
            .setter(setter(Builder::allowMultipleValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowMultipleValues").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_MULTIPLE_VALUES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean allowMultipleValues;

    private MultipleValuesSetting(BuilderImpl builder) {
        this.allowMultipleValues = builder.allowMultipleValues;
    }

    /**
     * <p>
     * Indicates whether a slot can return multiple values. When <code>true</code>, the slot may return more than one
     * value in a response. When <code>false</code>, the slot returns only a single value.
     * </p>
     * <p>
     * Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any other
     * locale, Amazon Lex throws a <code>ValidationException</code>.
     * </p>
     * <p>
     * If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code>.
     * </p>
     * 
     * @return Indicates whether a slot can return multiple values. When <code>true</code>, the slot may return more
     *         than one value in a response. When <code>false</code>, the slot returns only a single value.</p>
     *         <p>
     *         Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in
     *         any other locale, Amazon Lex throws a <code>ValidationException</code>.
     *         </p>
     *         <p>
     *         If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code>.
     */
    public final Boolean allowMultipleValues() {
        return allowMultipleValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowMultipleValues());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MultipleValuesSetting)) {
            return false;
        }
        MultipleValuesSetting other = (MultipleValuesSetting) obj;
        return Objects.equals(allowMultipleValues(), other.allowMultipleValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MultipleValuesSetting").add("AllowMultipleValues", allowMultipleValues()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "allowMultipleValues":
            return Optional.ofNullable(clazz.cast(allowMultipleValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("allowMultipleValues", ALLOW_MULTIPLE_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MultipleValuesSetting, T> g) {
        return obj -> g.apply((MultipleValuesSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MultipleValuesSetting> {
        /**
         * <p>
         * Indicates whether a slot can return multiple values. When <code>true</code>, the slot may return more than
         * one value in a response. When <code>false</code>, the slot returns only a single value.
         * </p>
         * <p>
         * Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code> in any
         * other locale, Amazon Lex throws a <code>ValidationException</code>.
         * </p>
         * <p>
         * If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code>.
         * </p>
         * 
         * @param allowMultipleValues
         *        Indicates whether a slot can return multiple values. When <code>true</code>, the slot may return more
         *        than one value in a response. When <code>false</code>, the slot returns only a single value.</p>
         *        <p>
         *        Multi-value slots are only available in the en-US locale. If you set this value to <code>true</code>
         *        in any other locale, Amazon Lex throws a <code>ValidationException</code>.
         *        </p>
         *        <p>
         *        If the <code>allowMutlipleValues</code> is not set, the default value is <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowMultipleValues(Boolean allowMultipleValues);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowMultipleValues;

        private BuilderImpl() {
        }

        private BuilderImpl(MultipleValuesSetting model) {
            allowMultipleValues(model.allowMultipleValues);
        }

        public final Boolean getAllowMultipleValues() {
            return allowMultipleValues;
        }

        public final void setAllowMultipleValues(Boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
        }

        @Override
        public final Builder allowMultipleValues(Boolean allowMultipleValues) {
            this.allowMultipleValues = allowMultipleValues;
            return this;
        }

        @Override
        public MultipleValuesSetting build() {
            return new MultipleValuesSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
