/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The object that contains a path format that will be applied when Amazon Lex reads the transcript file in the bucket
 * you provide. Specify this object if you only want Lex to read a subset of files in your Amazon S3 bucket.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathFormat implements SdkPojo, Serializable, ToCopyableBuilder<PathFormat.Builder, PathFormat> {
    private static final SdkField<List<String>> OBJECT_PREFIXES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("objectPrefixes")
            .getter(getter(PathFormat::objectPrefixes))
            .setter(setter(Builder::objectPrefixes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("objectPrefixes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_PREFIXES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> objectPrefixes;

    private PathFormat(BuilderImpl builder) {
        this.objectPrefixes = builder.objectPrefixes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectPrefixes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObjectPrefixes() {
        return objectPrefixes != null && !(objectPrefixes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3 bucket. Specify this list if you only
     * want Lex to read the files under this set of sub-folders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectPrefixes} method.
     * </p>
     * 
     * @return A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3 bucket. Specify this list if you
     *         only want Lex to read the files under this set of sub-folders.
     */
    public final List<String> objectPrefixes() {
        return objectPrefixes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectPrefixes() ? objectPrefixes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathFormat)) {
            return false;
        }
        PathFormat other = (PathFormat) obj;
        return hasObjectPrefixes() == other.hasObjectPrefixes() && Objects.equals(objectPrefixes(), other.objectPrefixes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathFormat").add("ObjectPrefixes", hasObjectPrefixes() ? objectPrefixes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "objectPrefixes":
            return Optional.ofNullable(clazz.cast(objectPrefixes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("objectPrefixes", OBJECT_PREFIXES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathFormat, T> g) {
        return obj -> g.apply((PathFormat) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathFormat> {
        /**
         * <p>
         * A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3 bucket. Specify this list if you
         * only want Lex to read the files under this set of sub-folders.
         * </p>
         * 
         * @param objectPrefixes
         *        A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3 bucket. Specify this list if
         *        you only want Lex to read the files under this set of sub-folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectPrefixes(Collection<String> objectPrefixes);

        /**
         * <p>
         * A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3 bucket. Specify this list if you
         * only want Lex to read the files under this set of sub-folders.
         * </p>
         * 
         * @param objectPrefixes
         *        A list of Amazon S3 prefixes that points to sub-folders in the Amazon S3 bucket. Specify this list if
         *        you only want Lex to read the files under this set of sub-folders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectPrefixes(String... objectPrefixes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> objectPrefixes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PathFormat model) {
            objectPrefixes(model.objectPrefixes);
        }

        public final Collection<String> getObjectPrefixes() {
            if (objectPrefixes instanceof SdkAutoConstructList) {
                return null;
            }
            return objectPrefixes;
        }

        public final void setObjectPrefixes(Collection<String> objectPrefixes) {
            this.objectPrefixes = ObjectPrefixesCopier.copy(objectPrefixes);
        }

        @Override
        public final Builder objectPrefixes(Collection<String> objectPrefixes) {
            this.objectPrefixes = ObjectPrefixesCopier.copy(objectPrefixes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectPrefixes(String... objectPrefixes) {
            objectPrefixes(Arrays.asList(objectPrefixes));
            return this;
        }

        @Override
        public PathFormat build() {
            return new PathFormat(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
