/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies next steps to run after the dialog code hook finishes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostDialogCodeHookInvocationSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<PostDialogCodeHookInvocationSpecification.Builder, PostDialogCodeHookInvocationSpecification> {
    private static final SdkField<ResponseSpecification> SUCCESS_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("successResponse")
            .getter(getter(PostDialogCodeHookInvocationSpecification::successResponse)).setter(setter(Builder::successResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successResponse").build()).build();

    private static final SdkField<DialogState> SUCCESS_NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("successNextStep").getter(getter(PostDialogCodeHookInvocationSpecification::successNextStep))
            .setter(setter(Builder::successNextStep)).constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successNextStep").build()).build();

    private static final SdkField<ConditionalSpecification> SUCCESS_CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("successConditional")
            .getter(getter(PostDialogCodeHookInvocationSpecification::successConditional))
            .setter(setter(Builder::successConditional)).constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successConditional").build())
            .build();

    private static final SdkField<ResponseSpecification> FAILURE_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("failureResponse")
            .getter(getter(PostDialogCodeHookInvocationSpecification::failureResponse)).setter(setter(Builder::failureResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureResponse").build()).build();

    private static final SdkField<DialogState> FAILURE_NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("failureNextStep").getter(getter(PostDialogCodeHookInvocationSpecification::failureNextStep))
            .setter(setter(Builder::failureNextStep)).constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureNextStep").build()).build();

    private static final SdkField<ConditionalSpecification> FAILURE_CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("failureConditional")
            .getter(getter(PostDialogCodeHookInvocationSpecification::failureConditional))
            .setter(setter(Builder::failureConditional)).constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureConditional").build())
            .build();

    private static final SdkField<ResponseSpecification> TIMEOUT_RESPONSE_FIELD = SdkField
            .<ResponseSpecification> builder(MarshallingType.SDK_POJO).memberName("timeoutResponse")
            .getter(getter(PostDialogCodeHookInvocationSpecification::timeoutResponse)).setter(setter(Builder::timeoutResponse))
            .constructor(ResponseSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutResponse").build()).build();

    private static final SdkField<DialogState> TIMEOUT_NEXT_STEP_FIELD = SdkField.<DialogState> builder(MarshallingType.SDK_POJO)
            .memberName("timeoutNextStep").getter(getter(PostDialogCodeHookInvocationSpecification::timeoutNextStep))
            .setter(setter(Builder::timeoutNextStep)).constructor(DialogState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutNextStep").build()).build();

    private static final SdkField<ConditionalSpecification> TIMEOUT_CONDITIONAL_FIELD = SdkField
            .<ConditionalSpecification> builder(MarshallingType.SDK_POJO).memberName("timeoutConditional")
            .getter(getter(PostDialogCodeHookInvocationSpecification::timeoutConditional))
            .setter(setter(Builder::timeoutConditional)).constructor(ConditionalSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutConditional").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESS_RESPONSE_FIELD,
            SUCCESS_NEXT_STEP_FIELD, SUCCESS_CONDITIONAL_FIELD, FAILURE_RESPONSE_FIELD, FAILURE_NEXT_STEP_FIELD,
            FAILURE_CONDITIONAL_FIELD, TIMEOUT_RESPONSE_FIELD, TIMEOUT_NEXT_STEP_FIELD, TIMEOUT_CONDITIONAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResponseSpecification successResponse;

    private final DialogState successNextStep;

    private final ConditionalSpecification successConditional;

    private final ResponseSpecification failureResponse;

    private final DialogState failureNextStep;

    private final ConditionalSpecification failureConditional;

    private final ResponseSpecification timeoutResponse;

    private final DialogState timeoutNextStep;

    private final ConditionalSpecification timeoutConditional;

    private PostDialogCodeHookInvocationSpecification(BuilderImpl builder) {
        this.successResponse = builder.successResponse;
        this.successNextStep = builder.successNextStep;
        this.successConditional = builder.successConditional;
        this.failureResponse = builder.failureResponse;
        this.failureNextStep = builder.failureNextStep;
        this.failureConditional = builder.failureConditional;
        this.timeoutResponse = builder.timeoutResponse;
        this.timeoutNextStep = builder.timeoutNextStep;
        this.timeoutConditional = builder.timeoutConditional;
    }

    /**
     * Returns the value of the SuccessResponse property for this object.
     * 
     * @return The value of the SuccessResponse property for this object.
     */
    public final ResponseSpecification successResponse() {
        return successResponse;
    }

    /**
     * <p>
     * Specifics the next step the bot runs after the dialog code hook finishes successfully.
     * </p>
     * 
     * @return Specifics the next step the bot runs after the dialog code hook finishes successfully.
     */
    public final DialogState successNextStep() {
        return successNextStep;
    }

    /**
     * <p>
     * A list of conditional branches to evaluate after the dialog code hook finishes successfully.
     * </p>
     * 
     * @return A list of conditional branches to evaluate after the dialog code hook finishes successfully.
     */
    public final ConditionalSpecification successConditional() {
        return successConditional;
    }

    /**
     * Returns the value of the FailureResponse property for this object.
     * 
     * @return The value of the FailureResponse property for this object.
     */
    public final ResponseSpecification failureResponse() {
        return failureResponse;
    }

    /**
     * <p>
     * Specifies the next step the bot runs after the dialog code hook throws an exception or returns with the
     * <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
     * </p>
     * 
     * @return Specifies the next step the bot runs after the dialog code hook throws an exception or returns with the
     *         <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
     */
    public final DialogState failureNextStep() {
        return failureNextStep;
    }

    /**
     * <p>
     * A list of conditional branches to evaluate after the dialog code hook throws an exception or returns with the
     * <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
     * </p>
     * 
     * @return A list of conditional branches to evaluate after the dialog code hook throws an exception or returns with
     *         the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
     */
    public final ConditionalSpecification failureConditional() {
        return failureConditional;
    }

    /**
     * Returns the value of the TimeoutResponse property for this object.
     * 
     * @return The value of the TimeoutResponse property for this object.
     */
    public final ResponseSpecification timeoutResponse() {
        return timeoutResponse;
    }

    /**
     * <p>
     * Specifies the next step that the bot runs when the code hook times out.
     * </p>
     * 
     * @return Specifies the next step that the bot runs when the code hook times out.
     */
    public final DialogState timeoutNextStep() {
        return timeoutNextStep;
    }

    /**
     * <p>
     * A list of conditional branches to evaluate if the code hook times out.
     * </p>
     * 
     * @return A list of conditional branches to evaluate if the code hook times out.
     */
    public final ConditionalSpecification timeoutConditional() {
        return timeoutConditional;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(successResponse());
        hashCode = 31 * hashCode + Objects.hashCode(successNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(successConditional());
        hashCode = 31 * hashCode + Objects.hashCode(failureResponse());
        hashCode = 31 * hashCode + Objects.hashCode(failureNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(failureConditional());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutResponse());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutNextStep());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutConditional());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostDialogCodeHookInvocationSpecification)) {
            return false;
        }
        PostDialogCodeHookInvocationSpecification other = (PostDialogCodeHookInvocationSpecification) obj;
        return Objects.equals(successResponse(), other.successResponse())
                && Objects.equals(successNextStep(), other.successNextStep())
                && Objects.equals(successConditional(), other.successConditional())
                && Objects.equals(failureResponse(), other.failureResponse())
                && Objects.equals(failureNextStep(), other.failureNextStep())
                && Objects.equals(failureConditional(), other.failureConditional())
                && Objects.equals(timeoutResponse(), other.timeoutResponse())
                && Objects.equals(timeoutNextStep(), other.timeoutNextStep())
                && Objects.equals(timeoutConditional(), other.timeoutConditional());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PostDialogCodeHookInvocationSpecification").add("SuccessResponse", successResponse())
                .add("SuccessNextStep", successNextStep()).add("SuccessConditional", successConditional())
                .add("FailureResponse", failureResponse()).add("FailureNextStep", failureNextStep())
                .add("FailureConditional", failureConditional()).add("TimeoutResponse", timeoutResponse())
                .add("TimeoutNextStep", timeoutNextStep()).add("TimeoutConditional", timeoutConditional()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "successResponse":
            return Optional.ofNullable(clazz.cast(successResponse()));
        case "successNextStep":
            return Optional.ofNullable(clazz.cast(successNextStep()));
        case "successConditional":
            return Optional.ofNullable(clazz.cast(successConditional()));
        case "failureResponse":
            return Optional.ofNullable(clazz.cast(failureResponse()));
        case "failureNextStep":
            return Optional.ofNullable(clazz.cast(failureNextStep()));
        case "failureConditional":
            return Optional.ofNullable(clazz.cast(failureConditional()));
        case "timeoutResponse":
            return Optional.ofNullable(clazz.cast(timeoutResponse()));
        case "timeoutNextStep":
            return Optional.ofNullable(clazz.cast(timeoutNextStep()));
        case "timeoutConditional":
            return Optional.ofNullable(clazz.cast(timeoutConditional()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("successResponse", SUCCESS_RESPONSE_FIELD);
        map.put("successNextStep", SUCCESS_NEXT_STEP_FIELD);
        map.put("successConditional", SUCCESS_CONDITIONAL_FIELD);
        map.put("failureResponse", FAILURE_RESPONSE_FIELD);
        map.put("failureNextStep", FAILURE_NEXT_STEP_FIELD);
        map.put("failureConditional", FAILURE_CONDITIONAL_FIELD);
        map.put("timeoutResponse", TIMEOUT_RESPONSE_FIELD);
        map.put("timeoutNextStep", TIMEOUT_NEXT_STEP_FIELD);
        map.put("timeoutConditional", TIMEOUT_CONDITIONAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostDialogCodeHookInvocationSpecification, T> g) {
        return obj -> g.apply((PostDialogCodeHookInvocationSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PostDialogCodeHookInvocationSpecification> {
        /**
         * Sets the value of the SuccessResponse property for this object.
         *
         * @param successResponse
         *        The new value for the SuccessResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successResponse(ResponseSpecification successResponse);

        /**
         * Sets the value of the SuccessResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #successResponse(ResponseSpecification)}.
         * 
         * @param successResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successResponse(ResponseSpecification)
         */
        default Builder successResponse(Consumer<ResponseSpecification.Builder> successResponse) {
            return successResponse(ResponseSpecification.builder().applyMutation(successResponse).build());
        }

        /**
         * <p>
         * Specifics the next step the bot runs after the dialog code hook finishes successfully.
         * </p>
         * 
         * @param successNextStep
         *        Specifics the next step the bot runs after the dialog code hook finishes successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successNextStep(DialogState successNextStep);

        /**
         * <p>
         * Specifics the next step the bot runs after the dialog code hook finishes successfully.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #successNextStep(DialogState)}.
         * 
         * @param successNextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successNextStep(DialogState)
         */
        default Builder successNextStep(Consumer<DialogState.Builder> successNextStep) {
            return successNextStep(DialogState.builder().applyMutation(successNextStep).build());
        }

        /**
         * <p>
         * A list of conditional branches to evaluate after the dialog code hook finishes successfully.
         * </p>
         * 
         * @param successConditional
         *        A list of conditional branches to evaluate after the dialog code hook finishes successfully.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successConditional(ConditionalSpecification successConditional);

        /**
         * <p>
         * A list of conditional branches to evaluate after the dialog code hook finishes successfully.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #successConditional(ConditionalSpecification)}.
         * 
         * @param successConditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #successConditional(ConditionalSpecification)
         */
        default Builder successConditional(Consumer<ConditionalSpecification.Builder> successConditional) {
            return successConditional(ConditionalSpecification.builder().applyMutation(successConditional).build());
        }

        /**
         * Sets the value of the FailureResponse property for this object.
         *
         * @param failureResponse
         *        The new value for the FailureResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureResponse(ResponseSpecification failureResponse);

        /**
         * Sets the value of the FailureResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #failureResponse(ResponseSpecification)}.
         * 
         * @param failureResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureResponse(ResponseSpecification)
         */
        default Builder failureResponse(Consumer<ResponseSpecification.Builder> failureResponse) {
            return failureResponse(ResponseSpecification.builder().applyMutation(failureResponse).build());
        }

        /**
         * <p>
         * Specifies the next step the bot runs after the dialog code hook throws an exception or returns with the
         * <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
         * </p>
         * 
         * @param failureNextStep
         *        Specifies the next step the bot runs after the dialog code hook throws an exception or returns with
         *        the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureNextStep(DialogState failureNextStep);

        /**
         * <p>
         * Specifies the next step the bot runs after the dialog code hook throws an exception or returns with the
         * <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #failureNextStep(DialogState)}.
         * 
         * @param failureNextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureNextStep(DialogState)
         */
        default Builder failureNextStep(Consumer<DialogState.Builder> failureNextStep) {
            return failureNextStep(DialogState.builder().applyMutation(failureNextStep).build());
        }

        /**
         * <p>
         * A list of conditional branches to evaluate after the dialog code hook throws an exception or returns with the
         * <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
         * </p>
         * 
         * @param failureConditional
         *        A list of conditional branches to evaluate after the dialog code hook throws an exception or returns
         *        with the <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureConditional(ConditionalSpecification failureConditional);

        /**
         * <p>
         * A list of conditional branches to evaluate after the dialog code hook throws an exception or returns with the
         * <code>State</code> field of the <code>Intent</code> object set to <code>Failed</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #failureConditional(ConditionalSpecification)}.
         * 
         * @param failureConditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #failureConditional(ConditionalSpecification)
         */
        default Builder failureConditional(Consumer<ConditionalSpecification.Builder> failureConditional) {
            return failureConditional(ConditionalSpecification.builder().applyMutation(failureConditional).build());
        }

        /**
         * Sets the value of the TimeoutResponse property for this object.
         *
         * @param timeoutResponse
         *        The new value for the TimeoutResponse property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutResponse(ResponseSpecification timeoutResponse);

        /**
         * Sets the value of the TimeoutResponse property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ResponseSpecification.Builder} avoiding
         * the need to create one manually via {@link ResponseSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResponseSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #timeoutResponse(ResponseSpecification)}.
         * 
         * @param timeoutResponse
         *        a consumer that will call methods on {@link ResponseSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutResponse(ResponseSpecification)
         */
        default Builder timeoutResponse(Consumer<ResponseSpecification.Builder> timeoutResponse) {
            return timeoutResponse(ResponseSpecification.builder().applyMutation(timeoutResponse).build());
        }

        /**
         * <p>
         * Specifies the next step that the bot runs when the code hook times out.
         * </p>
         * 
         * @param timeoutNextStep
         *        Specifies the next step that the bot runs when the code hook times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutNextStep(DialogState timeoutNextStep);

        /**
         * <p>
         * Specifies the next step that the bot runs when the code hook times out.
         * </p>
         * This is a convenience method that creates an instance of the {@link DialogState.Builder} avoiding the need to
         * create one manually via {@link DialogState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DialogState.Builder#build()} is called immediately and its result
         * is passed to {@link #timeoutNextStep(DialogState)}.
         * 
         * @param timeoutNextStep
         *        a consumer that will call methods on {@link DialogState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutNextStep(DialogState)
         */
        default Builder timeoutNextStep(Consumer<DialogState.Builder> timeoutNextStep) {
            return timeoutNextStep(DialogState.builder().applyMutation(timeoutNextStep).build());
        }

        /**
         * <p>
         * A list of conditional branches to evaluate if the code hook times out.
         * </p>
         * 
         * @param timeoutConditional
         *        A list of conditional branches to evaluate if the code hook times out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutConditional(ConditionalSpecification timeoutConditional);

        /**
         * <p>
         * A list of conditional branches to evaluate if the code hook times out.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConditionalSpecification.Builder}
         * avoiding the need to create one manually via {@link ConditionalSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConditionalSpecification.Builder#build()} is called immediately
         * and its result is passed to {@link #timeoutConditional(ConditionalSpecification)}.
         * 
         * @param timeoutConditional
         *        a consumer that will call methods on {@link ConditionalSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeoutConditional(ConditionalSpecification)
         */
        default Builder timeoutConditional(Consumer<ConditionalSpecification.Builder> timeoutConditional) {
            return timeoutConditional(ConditionalSpecification.builder().applyMutation(timeoutConditional).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResponseSpecification successResponse;

        private DialogState successNextStep;

        private ConditionalSpecification successConditional;

        private ResponseSpecification failureResponse;

        private DialogState failureNextStep;

        private ConditionalSpecification failureConditional;

        private ResponseSpecification timeoutResponse;

        private DialogState timeoutNextStep;

        private ConditionalSpecification timeoutConditional;

        private BuilderImpl() {
        }

        private BuilderImpl(PostDialogCodeHookInvocationSpecification model) {
            successResponse(model.successResponse);
            successNextStep(model.successNextStep);
            successConditional(model.successConditional);
            failureResponse(model.failureResponse);
            failureNextStep(model.failureNextStep);
            failureConditional(model.failureConditional);
            timeoutResponse(model.timeoutResponse);
            timeoutNextStep(model.timeoutNextStep);
            timeoutConditional(model.timeoutConditional);
        }

        public final ResponseSpecification.Builder getSuccessResponse() {
            return successResponse != null ? successResponse.toBuilder() : null;
        }

        public final void setSuccessResponse(ResponseSpecification.BuilderImpl successResponse) {
            this.successResponse = successResponse != null ? successResponse.build() : null;
        }

        @Override
        public final Builder successResponse(ResponseSpecification successResponse) {
            this.successResponse = successResponse;
            return this;
        }

        public final DialogState.Builder getSuccessNextStep() {
            return successNextStep != null ? successNextStep.toBuilder() : null;
        }

        public final void setSuccessNextStep(DialogState.BuilderImpl successNextStep) {
            this.successNextStep = successNextStep != null ? successNextStep.build() : null;
        }

        @Override
        public final Builder successNextStep(DialogState successNextStep) {
            this.successNextStep = successNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getSuccessConditional() {
            return successConditional != null ? successConditional.toBuilder() : null;
        }

        public final void setSuccessConditional(ConditionalSpecification.BuilderImpl successConditional) {
            this.successConditional = successConditional != null ? successConditional.build() : null;
        }

        @Override
        public final Builder successConditional(ConditionalSpecification successConditional) {
            this.successConditional = successConditional;
            return this;
        }

        public final ResponseSpecification.Builder getFailureResponse() {
            return failureResponse != null ? failureResponse.toBuilder() : null;
        }

        public final void setFailureResponse(ResponseSpecification.BuilderImpl failureResponse) {
            this.failureResponse = failureResponse != null ? failureResponse.build() : null;
        }

        @Override
        public final Builder failureResponse(ResponseSpecification failureResponse) {
            this.failureResponse = failureResponse;
            return this;
        }

        public final DialogState.Builder getFailureNextStep() {
            return failureNextStep != null ? failureNextStep.toBuilder() : null;
        }

        public final void setFailureNextStep(DialogState.BuilderImpl failureNextStep) {
            this.failureNextStep = failureNextStep != null ? failureNextStep.build() : null;
        }

        @Override
        public final Builder failureNextStep(DialogState failureNextStep) {
            this.failureNextStep = failureNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getFailureConditional() {
            return failureConditional != null ? failureConditional.toBuilder() : null;
        }

        public final void setFailureConditional(ConditionalSpecification.BuilderImpl failureConditional) {
            this.failureConditional = failureConditional != null ? failureConditional.build() : null;
        }

        @Override
        public final Builder failureConditional(ConditionalSpecification failureConditional) {
            this.failureConditional = failureConditional;
            return this;
        }

        public final ResponseSpecification.Builder getTimeoutResponse() {
            return timeoutResponse != null ? timeoutResponse.toBuilder() : null;
        }

        public final void setTimeoutResponse(ResponseSpecification.BuilderImpl timeoutResponse) {
            this.timeoutResponse = timeoutResponse != null ? timeoutResponse.build() : null;
        }

        @Override
        public final Builder timeoutResponse(ResponseSpecification timeoutResponse) {
            this.timeoutResponse = timeoutResponse;
            return this;
        }

        public final DialogState.Builder getTimeoutNextStep() {
            return timeoutNextStep != null ? timeoutNextStep.toBuilder() : null;
        }

        public final void setTimeoutNextStep(DialogState.BuilderImpl timeoutNextStep) {
            this.timeoutNextStep = timeoutNextStep != null ? timeoutNextStep.build() : null;
        }

        @Override
        public final Builder timeoutNextStep(DialogState timeoutNextStep) {
            this.timeoutNextStep = timeoutNextStep;
            return this;
        }

        public final ConditionalSpecification.Builder getTimeoutConditional() {
            return timeoutConditional != null ? timeoutConditional.toBuilder() : null;
        }

        public final void setTimeoutConditional(ConditionalSpecification.BuilderImpl timeoutConditional) {
            this.timeoutConditional = timeoutConditional != null ? timeoutConditional.build() : null;
        }

        @Override
        public final Builder timeoutConditional(ConditionalSpecification timeoutConditional) {
            this.timeoutConditional = timeoutConditional;
            return this;
        }

        @Override
        public PostDialogCodeHookInvocationSpecification build() {
            return new PostDialogCodeHookInvocationSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
