/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the time window that utterance statistics are returned for. The time window is always relative to the last
 * time that the that utterances were aggregated. For example, if the <code>ListAggregatedUtterances</code> operation is
 * called at 1600, the time window is set to 1 hour, and the last refresh time was 1530, only utterances made between
 * 1430 and 1530 are returned.
 * </p>
 * <p>
 * You can choose the time window that statistics should be returned for.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <b>Hours</b> - You can request utterance statistics for 1, 3, 6, 12, or 24 hour time windows. Statistics are
 * refreshed every half hour for 1 hour time windows, and hourly for the other time windows.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Days</b> - You can request utterance statistics for 3 days. Statistics are refreshed every 6 hours.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Weeks</b> - You can see statistics for one or two weeks. Statistics are refreshed every 12 hours for one week time
 * windows, and once per day for two week time windows.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelativeAggregationDuration implements SdkPojo, Serializable,
        ToCopyableBuilder<RelativeAggregationDuration.Builder, RelativeAggregationDuration> {
    private static final SdkField<String> TIME_DIMENSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeDimension").getter(getter(RelativeAggregationDuration::timeDimensionAsString))
            .setter(setter(Builder::timeDimension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDimension").build()).build();

    private static final SdkField<Integer> TIME_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeValue").getter(getter(RelativeAggregationDuration::timeValue)).setter(setter(Builder::timeValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_DIMENSION_FIELD,
            TIME_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String timeDimension;

    private final Integer timeValue;

    private RelativeAggregationDuration(BuilderImpl builder) {
        this.timeDimension = builder.timeDimension;
        this.timeValue = builder.timeValue;
    }

    /**
     * <p>
     * The type of time period that the <code>timeValue</code> field represents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeDimension}
     * will return {@link TimeDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeDimensionAsString}.
     * </p>
     * 
     * @return The type of time period that the <code>timeValue</code> field represents.
     * @see TimeDimension
     */
    public final TimeDimension timeDimension() {
        return TimeDimension.fromValue(timeDimension);
    }

    /**
     * <p>
     * The type of time period that the <code>timeValue</code> field represents.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeDimension}
     * will return {@link TimeDimension#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #timeDimensionAsString}.
     * </p>
     * 
     * @return The type of time period that the <code>timeValue</code> field represents.
     * @see TimeDimension
     */
    public final String timeDimensionAsString() {
        return timeDimension;
    }

    /**
     * <p>
     * The period of the time window to gather statistics for. The valid value depends on the setting of the
     * <code>timeDimension</code> field.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Hours</code> - 1/3/6/12/24
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Days</code> - 3
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Weeks</code> - 1/2
     * </p>
     * </li>
     * </ul>
     * 
     * @return The period of the time window to gather statistics for. The valid value depends on the setting of the
     *         <code>timeDimension</code> field.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Hours</code> - 1/3/6/12/24
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Days</code> - 3
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Weeks</code> - 1/2
     *         </p>
     *         </li>
     */
    public final Integer timeValue() {
        return timeValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeDimensionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timeValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelativeAggregationDuration)) {
            return false;
        }
        RelativeAggregationDuration other = (RelativeAggregationDuration) obj;
        return Objects.equals(timeDimensionAsString(), other.timeDimensionAsString())
                && Objects.equals(timeValue(), other.timeValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelativeAggregationDuration").add("TimeDimension", timeDimensionAsString())
                .add("TimeValue", timeValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeDimension":
            return Optional.ofNullable(clazz.cast(timeDimensionAsString()));
        case "timeValue":
            return Optional.ofNullable(clazz.cast(timeValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeDimension", TIME_DIMENSION_FIELD);
        map.put("timeValue", TIME_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelativeAggregationDuration, T> g) {
        return obj -> g.apply((RelativeAggregationDuration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelativeAggregationDuration> {
        /**
         * <p>
         * The type of time period that the <code>timeValue</code> field represents.
         * </p>
         * 
         * @param timeDimension
         *        The type of time period that the <code>timeValue</code> field represents.
         * @see TimeDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeDimension
         */
        Builder timeDimension(String timeDimension);

        /**
         * <p>
         * The type of time period that the <code>timeValue</code> field represents.
         * </p>
         * 
         * @param timeDimension
         *        The type of time period that the <code>timeValue</code> field represents.
         * @see TimeDimension
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TimeDimension
         */
        Builder timeDimension(TimeDimension timeDimension);

        /**
         * <p>
         * The period of the time window to gather statistics for. The valid value depends on the setting of the
         * <code>timeDimension</code> field.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Hours</code> - 1/3/6/12/24
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Days</code> - 3
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Weeks</code> - 1/2
         * </p>
         * </li>
         * </ul>
         * 
         * @param timeValue
         *        The period of the time window to gather statistics for. The valid value depends on the setting of the
         *        <code>timeDimension</code> field.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Hours</code> - 1/3/6/12/24
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Days</code> - 3
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Weeks</code> - 1/2
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeValue(Integer timeValue);
    }

    static final class BuilderImpl implements Builder {
        private String timeDimension;

        private Integer timeValue;

        private BuilderImpl() {
        }

        private BuilderImpl(RelativeAggregationDuration model) {
            timeDimension(model.timeDimension);
            timeValue(model.timeValue);
        }

        public final String getTimeDimension() {
            return timeDimension;
        }

        public final void setTimeDimension(String timeDimension) {
            this.timeDimension = timeDimension;
        }

        @Override
        public final Builder timeDimension(String timeDimension) {
            this.timeDimension = timeDimension;
            return this;
        }

        @Override
        public final Builder timeDimension(TimeDimension timeDimension) {
            this.timeDimension(timeDimension == null ? null : timeDimension.toString());
            return this;
        }

        public final Integer getTimeValue() {
            return timeValue;
        }

        public final void setTimeValue(Integer timeValue) {
            this.timeValue = timeValue;
        }

        @Override
        public final Builder timeValue(Integer timeValue) {
            this.timeValue = timeValue;
            return this;
        }

        @Override
        public RelativeAggregationDuration build() {
            return new RelativeAggregationDuration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
