/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about a slot, a value that the bot elicits from the user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SlotSummary implements SdkPojo, Serializable, ToCopyableBuilder<SlotSummary.Builder, SlotSummary> {
    private static final SdkField<String> SLOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("slotId")
            .getter(getter(SlotSummary::slotId)).setter(setter(Builder::slotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotId").build()).build();

    private static final SdkField<String> SLOT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotName").getter(getter(SlotSummary::slotName)).setter(setter(Builder::slotName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SlotSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SLOT_CONSTRAINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotConstraint").getter(getter(SlotSummary::slotConstraintAsString))
            .setter(setter(Builder::slotConstraint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotConstraint").build()).build();

    private static final SdkField<String> SLOT_TYPE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("slotTypeId").getter(getter(SlotSummary::slotTypeId)).setter(setter(Builder::slotTypeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("slotTypeId").build()).build();

    private static final SdkField<PromptSpecification> VALUE_ELICITATION_PROMPT_SPECIFICATION_FIELD = SdkField
            .<PromptSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("valueElicitationPromptSpecification")
            .getter(getter(SlotSummary::valueElicitationPromptSpecification))
            .setter(setter(Builder::valueElicitationPromptSpecification))
            .constructor(PromptSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("valueElicitationPromptSpecification").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDateTime").getter(getter(SlotSummary::lastUpdatedDateTime))
            .setter(setter(Builder::lastUpdatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDateTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SLOT_ID_FIELD,
            SLOT_NAME_FIELD, DESCRIPTION_FIELD, SLOT_CONSTRAINT_FIELD, SLOT_TYPE_ID_FIELD,
            VALUE_ELICITATION_PROMPT_SPECIFICATION_FIELD, LAST_UPDATED_DATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String slotId;

    private final String slotName;

    private final String description;

    private final String slotConstraint;

    private final String slotTypeId;

    private final PromptSpecification valueElicitationPromptSpecification;

    private final Instant lastUpdatedDateTime;

    private SlotSummary(BuilderImpl builder) {
        this.slotId = builder.slotId;
        this.slotName = builder.slotName;
        this.description = builder.description;
        this.slotConstraint = builder.slotConstraint;
        this.slotTypeId = builder.slotTypeId;
        this.valueElicitationPromptSpecification = builder.valueElicitationPromptSpecification;
        this.lastUpdatedDateTime = builder.lastUpdatedDateTime;
    }

    /**
     * <p>
     * The unique identifier of the slot.
     * </p>
     * 
     * @return The unique identifier of the slot.
     */
    public final String slotId() {
        return slotId;
    }

    /**
     * <p>
     * The name given to the slot.
     * </p>
     * 
     * @return The name given to the slot.
     */
    public final String slotName() {
        return slotName;
    }

    /**
     * <p>
     * The description of the slot.
     * </p>
     * 
     * @return The description of the slot.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the slot is required or optional. An intent is complete when all required slots are filled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slotConstraint}
     * will return {@link SlotConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slotConstraintAsString}.
     * </p>
     * 
     * @return Whether the slot is required or optional. An intent is complete when all required slots are filled.
     * @see SlotConstraint
     */
    public final SlotConstraint slotConstraint() {
        return SlotConstraint.fromValue(slotConstraint);
    }

    /**
     * <p>
     * Whether the slot is required or optional. An intent is complete when all required slots are filled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #slotConstraint}
     * will return {@link SlotConstraint#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #slotConstraintAsString}.
     * </p>
     * 
     * @return Whether the slot is required or optional. An intent is complete when all required slots are filled.
     * @see SlotConstraint
     */
    public final String slotConstraintAsString() {
        return slotConstraint;
    }

    /**
     * <p>
     * The unique identifier for the slot type that defines the values for the slot.
     * </p>
     * 
     * @return The unique identifier for the slot type that defines the values for the slot.
     */
    public final String slotTypeId() {
        return slotTypeId;
    }

    /**
     * <p>
     * Prompts that are sent to the user to elicit a value for the slot.
     * </p>
     * 
     * @return Prompts that are sent to the user to elicit a value for the slot.
     */
    public final PromptSpecification valueElicitationPromptSpecification() {
        return valueElicitationPromptSpecification;
    }

    /**
     * <p>
     * The timestamp of the last date and time that the slot was updated.
     * </p>
     * 
     * @return The timestamp of the last date and time that the slot was updated.
     */
    public final Instant lastUpdatedDateTime() {
        return lastUpdatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(slotId());
        hashCode = 31 * hashCode + Objects.hashCode(slotName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(slotConstraintAsString());
        hashCode = 31 * hashCode + Objects.hashCode(slotTypeId());
        hashCode = 31 * hashCode + Objects.hashCode(valueElicitationPromptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SlotSummary)) {
            return false;
        }
        SlotSummary other = (SlotSummary) obj;
        return Objects.equals(slotId(), other.slotId()) && Objects.equals(slotName(), other.slotName())
                && Objects.equals(description(), other.description())
                && Objects.equals(slotConstraintAsString(), other.slotConstraintAsString())
                && Objects.equals(slotTypeId(), other.slotTypeId())
                && Objects.equals(valueElicitationPromptSpecification(), other.valueElicitationPromptSpecification())
                && Objects.equals(lastUpdatedDateTime(), other.lastUpdatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SlotSummary").add("SlotId", slotId()).add("SlotName", slotName())
                .add("Description", description()).add("SlotConstraint", slotConstraintAsString())
                .add("SlotTypeId", slotTypeId())
                .add("ValueElicitationPromptSpecification", valueElicitationPromptSpecification())
                .add("LastUpdatedDateTime", lastUpdatedDateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "slotId":
            return Optional.ofNullable(clazz.cast(slotId()));
        case "slotName":
            return Optional.ofNullable(clazz.cast(slotName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "slotConstraint":
            return Optional.ofNullable(clazz.cast(slotConstraintAsString()));
        case "slotTypeId":
            return Optional.ofNullable(clazz.cast(slotTypeId()));
        case "valueElicitationPromptSpecification":
            return Optional.ofNullable(clazz.cast(valueElicitationPromptSpecification()));
        case "lastUpdatedDateTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("slotId", SLOT_ID_FIELD);
        map.put("slotName", SLOT_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("slotConstraint", SLOT_CONSTRAINT_FIELD);
        map.put("slotTypeId", SLOT_TYPE_ID_FIELD);
        map.put("valueElicitationPromptSpecification", VALUE_ELICITATION_PROMPT_SPECIFICATION_FIELD);
        map.put("lastUpdatedDateTime", LAST_UPDATED_DATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SlotSummary, T> g) {
        return obj -> g.apply((SlotSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SlotSummary> {
        /**
         * <p>
         * The unique identifier of the slot.
         * </p>
         * 
         * @param slotId
         *        The unique identifier of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotId(String slotId);

        /**
         * <p>
         * The name given to the slot.
         * </p>
         * 
         * @param slotName
         *        The name given to the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotName(String slotName);

        /**
         * <p>
         * The description of the slot.
         * </p>
         * 
         * @param description
         *        The description of the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the slot is required or optional. An intent is complete when all required slots are filled.
         * </p>
         * 
         * @param slotConstraint
         *        Whether the slot is required or optional. An intent is complete when all required slots are filled.
         * @see SlotConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotConstraint
         */
        Builder slotConstraint(String slotConstraint);

        /**
         * <p>
         * Whether the slot is required or optional. An intent is complete when all required slots are filled.
         * </p>
         * 
         * @param slotConstraint
         *        Whether the slot is required or optional. An intent is complete when all required slots are filled.
         * @see SlotConstraint
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SlotConstraint
         */
        Builder slotConstraint(SlotConstraint slotConstraint);

        /**
         * <p>
         * The unique identifier for the slot type that defines the values for the slot.
         * </p>
         * 
         * @param slotTypeId
         *        The unique identifier for the slot type that defines the values for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder slotTypeId(String slotTypeId);

        /**
         * <p>
         * Prompts that are sent to the user to elicit a value for the slot.
         * </p>
         * 
         * @param valueElicitationPromptSpecification
         *        Prompts that are sent to the user to elicit a value for the slot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueElicitationPromptSpecification(PromptSpecification valueElicitationPromptSpecification);

        /**
         * <p>
         * Prompts that are sent to the user to elicit a value for the slot.
         * </p>
         * This is a convenience method that creates an instance of the {@link PromptSpecification.Builder} avoiding the
         * need to create one manually via {@link PromptSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #valueElicitationPromptSpecification(PromptSpecification)}.
         * 
         * @param valueElicitationPromptSpecification
         *        a consumer that will call methods on {@link PromptSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueElicitationPromptSpecification(PromptSpecification)
         */
        default Builder valueElicitationPromptSpecification(
                Consumer<PromptSpecification.Builder> valueElicitationPromptSpecification) {
            return valueElicitationPromptSpecification(PromptSpecification.builder()
                    .applyMutation(valueElicitationPromptSpecification).build());
        }

        /**
         * <p>
         * The timestamp of the last date and time that the slot was updated.
         * </p>
         * 
         * @param lastUpdatedDateTime
         *        The timestamp of the last date and time that the slot was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDateTime(Instant lastUpdatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String slotId;

        private String slotName;

        private String description;

        private String slotConstraint;

        private String slotTypeId;

        private PromptSpecification valueElicitationPromptSpecification;

        private Instant lastUpdatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(SlotSummary model) {
            slotId(model.slotId);
            slotName(model.slotName);
            description(model.description);
            slotConstraint(model.slotConstraint);
            slotTypeId(model.slotTypeId);
            valueElicitationPromptSpecification(model.valueElicitationPromptSpecification);
            lastUpdatedDateTime(model.lastUpdatedDateTime);
        }

        public final String getSlotId() {
            return slotId;
        }

        public final void setSlotId(String slotId) {
            this.slotId = slotId;
        }

        @Override
        public final Builder slotId(String slotId) {
            this.slotId = slotId;
            return this;
        }

        public final String getSlotName() {
            return slotName;
        }

        public final void setSlotName(String slotName) {
            this.slotName = slotName;
        }

        @Override
        public final Builder slotName(String slotName) {
            this.slotName = slotName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSlotConstraint() {
            return slotConstraint;
        }

        public final void setSlotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
        }

        @Override
        public final Builder slotConstraint(String slotConstraint) {
            this.slotConstraint = slotConstraint;
            return this;
        }

        @Override
        public final Builder slotConstraint(SlotConstraint slotConstraint) {
            this.slotConstraint(slotConstraint == null ? null : slotConstraint.toString());
            return this;
        }

        public final String getSlotTypeId() {
            return slotTypeId;
        }

        public final void setSlotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
        }

        @Override
        public final Builder slotTypeId(String slotTypeId) {
            this.slotTypeId = slotTypeId;
            return this;
        }

        public final PromptSpecification.Builder getValueElicitationPromptSpecification() {
            return valueElicitationPromptSpecification != null ? valueElicitationPromptSpecification.toBuilder() : null;
        }

        public final void setValueElicitationPromptSpecification(
                PromptSpecification.BuilderImpl valueElicitationPromptSpecification) {
            this.valueElicitationPromptSpecification = valueElicitationPromptSpecification != null ? valueElicitationPromptSpecification
                    .build() : null;
        }

        @Override
        public final Builder valueElicitationPromptSpecification(PromptSpecification valueElicitationPromptSpecification) {
            this.valueElicitationPromptSpecification = valueElicitationPromptSpecification;
            return this;
        }

        public final Instant getLastUpdatedDateTime() {
            return lastUpdatedDateTime;
        }

        public final void setLastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
        }

        @Override
        public final Builder lastUpdatedDateTime(Instant lastUpdatedDateTime) {
            this.lastUpdatedDateTime = lastUpdatedDateTime;
            return this;
        }

        @Override
        public SlotSummary build() {
            return new SlotSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
