/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the messages that Amazon Lex sends to a user to remind them that the bot is waiting for a response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StillWaitingResponseSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<StillWaitingResponseSpecification.Builder, StillWaitingResponseSpecification> {
    private static final SdkField<List<MessageGroup>> MESSAGE_GROUPS_FIELD = SdkField
            .<List<MessageGroup>> builder(MarshallingType.LIST)
            .memberName("messageGroups")
            .getter(getter(StillWaitingResponseSpecification::messageGroups))
            .setter(setter(Builder::messageGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MessageGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(MessageGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> FREQUENCY_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("frequencyInSeconds").getter(getter(StillWaitingResponseSpecification::frequencyInSeconds))
            .setter(setter(Builder::frequencyInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frequencyInSeconds").build())
            .build();

    private static final SdkField<Integer> TIMEOUT_IN_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutInSeconds").getter(getter(StillWaitingResponseSpecification::timeoutInSeconds))
            .setter(setter(Builder::timeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutInSeconds").build()).build();

    private static final SdkField<Boolean> ALLOW_INTERRUPT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("allowInterrupt").getter(getter(StillWaitingResponseSpecification::allowInterrupt))
            .setter(setter(Builder::allowInterrupt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowInterrupt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_GROUPS_FIELD,
            FREQUENCY_IN_SECONDS_FIELD, TIMEOUT_IN_SECONDS_FIELD, ALLOW_INTERRUPT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<MessageGroup> messageGroups;

    private final Integer frequencyInSeconds;

    private final Integer timeoutInSeconds;

    private final Boolean allowInterrupt;

    private StillWaitingResponseSpecification(BuilderImpl builder) {
        this.messageGroups = builder.messageGroups;
        this.frequencyInSeconds = builder.frequencyInSeconds;
        this.timeoutInSeconds = builder.timeoutInSeconds;
        this.allowInterrupt = builder.allowInterrupt;
    }

    /**
     * For responses, this returns true if the service returned a value for the MessageGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMessageGroups() {
        return messageGroups != null && !(messageGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex sends
     * to the user.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMessageGroups} method.
     * </p>
     * 
     * @return One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex
     *         sends to the user.
     */
    public final List<MessageGroup> messageGroups() {
        return messageGroups;
    }

    /**
     * <p>
     * How often a message should be sent to the user. Minimum of 1 second, maximum of 5 minutes.
     * </p>
     * 
     * @return How often a message should be sent to the user. Minimum of 1 second, maximum of 5 minutes.
     */
    public final Integer frequencyInSeconds() {
        return frequencyInSeconds;
    }

    /**
     * <p>
     * If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.
     * </p>
     * 
     * @return If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.
     */
    public final Integer timeoutInSeconds() {
        return timeoutInSeconds;
    }

    /**
     * <p>
     * Indicates that the user can interrupt the response by speaking while the message is being played.
     * </p>
     * 
     * @return Indicates that the user can interrupt the response by speaking while the message is being played.
     */
    public final Boolean allowInterrupt() {
        return allowInterrupt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMessageGroups() ? messageGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(frequencyInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(timeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(allowInterrupt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StillWaitingResponseSpecification)) {
            return false;
        }
        StillWaitingResponseSpecification other = (StillWaitingResponseSpecification) obj;
        return hasMessageGroups() == other.hasMessageGroups() && Objects.equals(messageGroups(), other.messageGroups())
                && Objects.equals(frequencyInSeconds(), other.frequencyInSeconds())
                && Objects.equals(timeoutInSeconds(), other.timeoutInSeconds())
                && Objects.equals(allowInterrupt(), other.allowInterrupt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StillWaitingResponseSpecification")
                .add("MessageGroups", hasMessageGroups() ? messageGroups() : null)
                .add("FrequencyInSeconds", frequencyInSeconds()).add("TimeoutInSeconds", timeoutInSeconds())
                .add("AllowInterrupt", allowInterrupt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageGroups":
            return Optional.ofNullable(clazz.cast(messageGroups()));
        case "frequencyInSeconds":
            return Optional.ofNullable(clazz.cast(frequencyInSeconds()));
        case "timeoutInSeconds":
            return Optional.ofNullable(clazz.cast(timeoutInSeconds()));
        case "allowInterrupt":
            return Optional.ofNullable(clazz.cast(allowInterrupt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("messageGroups", MESSAGE_GROUPS_FIELD);
        map.put("frequencyInSeconds", FREQUENCY_IN_SECONDS_FIELD);
        map.put("timeoutInSeconds", TIMEOUT_IN_SECONDS_FIELD);
        map.put("allowInterrupt", ALLOW_INTERRUPT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StillWaitingResponseSpecification, T> g) {
        return obj -> g.apply((StillWaitingResponseSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StillWaitingResponseSpecification> {
        /**
         * <p>
         * One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex
         * sends to the user.
         * </p>
         * 
         * @param messageGroups
         *        One or more message groups, each containing one or more messages, that define the prompts that Amazon
         *        Lex sends to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageGroups(Collection<MessageGroup> messageGroups);

        /**
         * <p>
         * One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex
         * sends to the user.
         * </p>
         * 
         * @param messageGroups
         *        One or more message groups, each containing one or more messages, that define the prompts that Amazon
         *        Lex sends to the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageGroups(MessageGroup... messageGroups);

        /**
         * <p>
         * One or more message groups, each containing one or more messages, that define the prompts that Amazon Lex
         * sends to the user.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder#build()} is called immediately
         * and its result is passed to {@link #messageGroups(List<MessageGroup>)}.
         * 
         * @param messageGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.MessageGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messageGroups(java.util.Collection<MessageGroup>)
         */
        Builder messageGroups(Consumer<MessageGroup.Builder>... messageGroups);

        /**
         * <p>
         * How often a message should be sent to the user. Minimum of 1 second, maximum of 5 minutes.
         * </p>
         * 
         * @param frequencyInSeconds
         *        How often a message should be sent to the user. Minimum of 1 second, maximum of 5 minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frequencyInSeconds(Integer frequencyInSeconds);

        /**
         * <p>
         * If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.
         * </p>
         * 
         * @param timeoutInSeconds
         *        If Amazon Lex waits longer than this length of time for a response, it will stop sending messages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutInSeconds(Integer timeoutInSeconds);

        /**
         * <p>
         * Indicates that the user can interrupt the response by speaking while the message is being played.
         * </p>
         * 
         * @param allowInterrupt
         *        Indicates that the user can interrupt the response by speaking while the message is being played.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowInterrupt(Boolean allowInterrupt);
    }

    static final class BuilderImpl implements Builder {
        private List<MessageGroup> messageGroups = DefaultSdkAutoConstructList.getInstance();

        private Integer frequencyInSeconds;

        private Integer timeoutInSeconds;

        private Boolean allowInterrupt;

        private BuilderImpl() {
        }

        private BuilderImpl(StillWaitingResponseSpecification model) {
            messageGroups(model.messageGroups);
            frequencyInSeconds(model.frequencyInSeconds);
            timeoutInSeconds(model.timeoutInSeconds);
            allowInterrupt(model.allowInterrupt);
        }

        public final List<MessageGroup.Builder> getMessageGroups() {
            List<MessageGroup.Builder> result = MessageGroupsListCopier.copyToBuilder(this.messageGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMessageGroups(Collection<MessageGroup.BuilderImpl> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copyFromBuilder(messageGroups);
        }

        @Override
        public final Builder messageGroups(Collection<MessageGroup> messageGroups) {
            this.messageGroups = MessageGroupsListCopier.copy(messageGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(MessageGroup... messageGroups) {
            messageGroups(Arrays.asList(messageGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messageGroups(Consumer<MessageGroup.Builder>... messageGroups) {
            messageGroups(Stream.of(messageGroups).map(c -> MessageGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getFrequencyInSeconds() {
            return frequencyInSeconds;
        }

        public final void setFrequencyInSeconds(Integer frequencyInSeconds) {
            this.frequencyInSeconds = frequencyInSeconds;
        }

        @Override
        public final Builder frequencyInSeconds(Integer frequencyInSeconds) {
            this.frequencyInSeconds = frequencyInSeconds;
            return this;
        }

        public final Integer getTimeoutInSeconds() {
            return timeoutInSeconds;
        }

        public final void setTimeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
        }

        @Override
        public final Builder timeoutInSeconds(Integer timeoutInSeconds) {
            this.timeoutInSeconds = timeoutInSeconds;
            return this;
        }

        public final Boolean getAllowInterrupt() {
            return allowInterrupt;
        }

        public final void setAllowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
        }

        @Override
        public final Builder allowInterrupt(Boolean allowInterrupt) {
            this.allowInterrupt = allowInterrupt;
            return this;
        }

        @Override
        public StillWaitingResponseSpecification build() {
            return new StillWaitingResponseSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
