/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Subslot elicitation settings.
 * </p>
 * <p>
 * <code>DefaultValueSpecification</code> is a list of default values for a constituent sub slot in a composite slot.
 * Default values are used when Amazon Lex hasn't determined a value for a slot. You can specify default values from
 * context variables, session attributes, and defined values. This is similar to <code>DefaultValueSpecification</code>
 * for slots.
 * </p>
 * <p>
 * <code>PromptSpecification</code> is the prompt that Amazon Lex uses to elicit the sub slot value from the user. This
 * is similar to <code>PromptSpecification</code> for slots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SubSlotValueElicitationSetting implements SdkPojo, Serializable,
        ToCopyableBuilder<SubSlotValueElicitationSetting.Builder, SubSlotValueElicitationSetting> {
    private static final SdkField<SlotDefaultValueSpecification> DEFAULT_VALUE_SPECIFICATION_FIELD = SdkField
            .<SlotDefaultValueSpecification> builder(MarshallingType.SDK_POJO).memberName("defaultValueSpecification")
            .getter(getter(SubSlotValueElicitationSetting::defaultValueSpecification))
            .setter(setter(Builder::defaultValueSpecification)).constructor(SlotDefaultValueSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValueSpecification").build())
            .build();

    private static final SdkField<PromptSpecification> PROMPT_SPECIFICATION_FIELD = SdkField
            .<PromptSpecification> builder(MarshallingType.SDK_POJO).memberName("promptSpecification")
            .getter(getter(SubSlotValueElicitationSetting::promptSpecification)).setter(setter(Builder::promptSpecification))
            .constructor(PromptSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptSpecification").build())
            .build();

    private static final SdkField<List<SampleUtterance>> SAMPLE_UTTERANCES_FIELD = SdkField
            .<List<SampleUtterance>> builder(MarshallingType.LIST)
            .memberName("sampleUtterances")
            .getter(getter(SubSlotValueElicitationSetting::sampleUtterances))
            .setter(setter(Builder::sampleUtterances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleUtterances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SampleUtterance> builder(MarshallingType.SDK_POJO)
                                            .constructor(SampleUtterance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<WaitAndContinueSpecification> WAIT_AND_CONTINUE_SPECIFICATION_FIELD = SdkField
            .<WaitAndContinueSpecification> builder(MarshallingType.SDK_POJO)
            .memberName("waitAndContinueSpecification")
            .getter(getter(SubSlotValueElicitationSetting::waitAndContinueSpecification))
            .setter(setter(Builder::waitAndContinueSpecification))
            .constructor(WaitAndContinueSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waitAndContinueSpecification")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            DEFAULT_VALUE_SPECIFICATION_FIELD, PROMPT_SPECIFICATION_FIELD, SAMPLE_UTTERANCES_FIELD,
            WAIT_AND_CONTINUE_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SlotDefaultValueSpecification defaultValueSpecification;

    private final PromptSpecification promptSpecification;

    private final List<SampleUtterance> sampleUtterances;

    private final WaitAndContinueSpecification waitAndContinueSpecification;

    private SubSlotValueElicitationSetting(BuilderImpl builder) {
        this.defaultValueSpecification = builder.defaultValueSpecification;
        this.promptSpecification = builder.promptSpecification;
        this.sampleUtterances = builder.sampleUtterances;
        this.waitAndContinueSpecification = builder.waitAndContinueSpecification;
    }

    /**
     * Returns the value of the DefaultValueSpecification property for this object.
     * 
     * @return The value of the DefaultValueSpecification property for this object.
     */
    public final SlotDefaultValueSpecification defaultValueSpecification() {
        return defaultValueSpecification;
    }

    /**
     * Returns the value of the PromptSpecification property for this object.
     * 
     * @return The value of the PromptSpecification property for this object.
     */
    public final PromptSpecification promptSpecification() {
        return promptSpecification;
    }

    /**
     * For responses, this returns true if the service returned a value for the SampleUtterances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSampleUtterances() {
        return sampleUtterances != null && !(sampleUtterances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value, you can
     * provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is capable of
     * understanding user utterances. This is similar to <code>SampleUtterances</code> for slots.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSampleUtterances} method.
     * </p>
     * 
     * @return If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value,
     *         you can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is
     *         capable of understanding user utterances. This is similar to <code>SampleUtterances</code> for slots.
     */
    public final List<SampleUtterance> sampleUtterances() {
        return sampleUtterances;
    }

    /**
     * Returns the value of the WaitAndContinueSpecification property for this object.
     * 
     * @return The value of the WaitAndContinueSpecification property for this object.
     */
    public final WaitAndContinueSpecification waitAndContinueSpecification() {
        return waitAndContinueSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValueSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(promptSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(hasSampleUtterances() ? sampleUtterances() : null);
        hashCode = 31 * hashCode + Objects.hashCode(waitAndContinueSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubSlotValueElicitationSetting)) {
            return false;
        }
        SubSlotValueElicitationSetting other = (SubSlotValueElicitationSetting) obj;
        return Objects.equals(defaultValueSpecification(), other.defaultValueSpecification())
                && Objects.equals(promptSpecification(), other.promptSpecification())
                && hasSampleUtterances() == other.hasSampleUtterances()
                && Objects.equals(sampleUtterances(), other.sampleUtterances())
                && Objects.equals(waitAndContinueSpecification(), other.waitAndContinueSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SubSlotValueElicitationSetting").add("DefaultValueSpecification", defaultValueSpecification())
                .add("PromptSpecification", promptSpecification())
                .add("SampleUtterances", hasSampleUtterances() ? sampleUtterances() : null)
                .add("WaitAndContinueSpecification", waitAndContinueSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "defaultValueSpecification":
            return Optional.ofNullable(clazz.cast(defaultValueSpecification()));
        case "promptSpecification":
            return Optional.ofNullable(clazz.cast(promptSpecification()));
        case "sampleUtterances":
            return Optional.ofNullable(clazz.cast(sampleUtterances()));
        case "waitAndContinueSpecification":
            return Optional.ofNullable(clazz.cast(waitAndContinueSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("defaultValueSpecification", DEFAULT_VALUE_SPECIFICATION_FIELD);
        map.put("promptSpecification", PROMPT_SPECIFICATION_FIELD);
        map.put("sampleUtterances", SAMPLE_UTTERANCES_FIELD);
        map.put("waitAndContinueSpecification", WAIT_AND_CONTINUE_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubSlotValueElicitationSetting, T> g) {
        return obj -> g.apply((SubSlotValueElicitationSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SubSlotValueElicitationSetting> {
        /**
         * Sets the value of the DefaultValueSpecification property for this object.
         *
         * @param defaultValueSpecification
         *        The new value for the DefaultValueSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValueSpecification(SlotDefaultValueSpecification defaultValueSpecification);

        /**
         * Sets the value of the DefaultValueSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SlotDefaultValueSpecification.Builder}
         * avoiding the need to create one manually via {@link SlotDefaultValueSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SlotDefaultValueSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #defaultValueSpecification(SlotDefaultValueSpecification)}.
         * 
         * @param defaultValueSpecification
         *        a consumer that will call methods on {@link SlotDefaultValueSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValueSpecification(SlotDefaultValueSpecification)
         */
        default Builder defaultValueSpecification(Consumer<SlotDefaultValueSpecification.Builder> defaultValueSpecification) {
            return defaultValueSpecification(SlotDefaultValueSpecification.builder().applyMutation(defaultValueSpecification)
                    .build());
        }

        /**
         * Sets the value of the PromptSpecification property for this object.
         *
         * @param promptSpecification
         *        The new value for the PromptSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promptSpecification(PromptSpecification promptSpecification);

        /**
         * Sets the value of the PromptSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link PromptSpecification.Builder} avoiding the
         * need to create one manually via {@link PromptSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PromptSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #promptSpecification(PromptSpecification)}.
         * 
         * @param promptSpecification
         *        a consumer that will call methods on {@link PromptSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #promptSpecification(PromptSpecification)
         */
        default Builder promptSpecification(Consumer<PromptSpecification.Builder> promptSpecification) {
            return promptSpecification(PromptSpecification.builder().applyMutation(promptSpecification).build());
        }

        /**
         * <p>
         * If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value, you
         * can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is capable of
         * understanding user utterances. This is similar to <code>SampleUtterances</code> for slots.
         * </p>
         * 
         * @param sampleUtterances
         *        If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value,
         *        you can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is
         *        capable of understanding user utterances. This is similar to <code>SampleUtterances</code> for slots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances);

        /**
         * <p>
         * If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value, you
         * can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is capable of
         * understanding user utterances. This is similar to <code>SampleUtterances</code> for slots.
         * </p>
         * 
         * @param sampleUtterances
         *        If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value,
         *        you can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is
         *        capable of understanding user utterances. This is similar to <code>SampleUtterances</code> for slots.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sampleUtterances(SampleUtterance... sampleUtterances);

        /**
         * <p>
         * If you know a specific pattern that users might respond to an Amazon Lex request for a sub slot value, you
         * can provide those utterances to improve accuracy. This is optional. In most cases Amazon Lex is capable of
         * understanding user utterances. This is similar to <code>SampleUtterances</code> for slots.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder#build()} is called
         * immediately and its result is passed to {@link #sampleUtterances(List<SampleUtterance>)}.
         * 
         * @param sampleUtterances
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.lexmodelsv2.model.SampleUtterance.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sampleUtterances(java.util.Collection<SampleUtterance>)
         */
        Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances);

        /**
         * Sets the value of the WaitAndContinueSpecification property for this object.
         *
         * @param waitAndContinueSpecification
         *        The new value for the WaitAndContinueSpecification property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder waitAndContinueSpecification(WaitAndContinueSpecification waitAndContinueSpecification);

        /**
         * Sets the value of the WaitAndContinueSpecification property for this object.
         *
         * This is a convenience method that creates an instance of the {@link WaitAndContinueSpecification.Builder}
         * avoiding the need to create one manually via {@link WaitAndContinueSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WaitAndContinueSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #waitAndContinueSpecification(WaitAndContinueSpecification)}.
         * 
         * @param waitAndContinueSpecification
         *        a consumer that will call methods on {@link WaitAndContinueSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #waitAndContinueSpecification(WaitAndContinueSpecification)
         */
        default Builder waitAndContinueSpecification(Consumer<WaitAndContinueSpecification.Builder> waitAndContinueSpecification) {
            return waitAndContinueSpecification(WaitAndContinueSpecification.builder()
                    .applyMutation(waitAndContinueSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SlotDefaultValueSpecification defaultValueSpecification;

        private PromptSpecification promptSpecification;

        private List<SampleUtterance> sampleUtterances = DefaultSdkAutoConstructList.getInstance();

        private WaitAndContinueSpecification waitAndContinueSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(SubSlotValueElicitationSetting model) {
            defaultValueSpecification(model.defaultValueSpecification);
            promptSpecification(model.promptSpecification);
            sampleUtterances(model.sampleUtterances);
            waitAndContinueSpecification(model.waitAndContinueSpecification);
        }

        public final SlotDefaultValueSpecification.Builder getDefaultValueSpecification() {
            return defaultValueSpecification != null ? defaultValueSpecification.toBuilder() : null;
        }

        public final void setDefaultValueSpecification(SlotDefaultValueSpecification.BuilderImpl defaultValueSpecification) {
            this.defaultValueSpecification = defaultValueSpecification != null ? defaultValueSpecification.build() : null;
        }

        @Override
        public final Builder defaultValueSpecification(SlotDefaultValueSpecification defaultValueSpecification) {
            this.defaultValueSpecification = defaultValueSpecification;
            return this;
        }

        public final PromptSpecification.Builder getPromptSpecification() {
            return promptSpecification != null ? promptSpecification.toBuilder() : null;
        }

        public final void setPromptSpecification(PromptSpecification.BuilderImpl promptSpecification) {
            this.promptSpecification = promptSpecification != null ? promptSpecification.build() : null;
        }

        @Override
        public final Builder promptSpecification(PromptSpecification promptSpecification) {
            this.promptSpecification = promptSpecification;
            return this;
        }

        public final List<SampleUtterance.Builder> getSampleUtterances() {
            List<SampleUtterance.Builder> result = SampleUtterancesListCopier.copyToBuilder(this.sampleUtterances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSampleUtterances(Collection<SampleUtterance.BuilderImpl> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copyFromBuilder(sampleUtterances);
        }

        @Override
        public final Builder sampleUtterances(Collection<SampleUtterance> sampleUtterances) {
            this.sampleUtterances = SampleUtterancesListCopier.copy(sampleUtterances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(SampleUtterance... sampleUtterances) {
            sampleUtterances(Arrays.asList(sampleUtterances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sampleUtterances(Consumer<SampleUtterance.Builder>... sampleUtterances) {
            sampleUtterances(Stream.of(sampleUtterances).map(c -> SampleUtterance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final WaitAndContinueSpecification.Builder getWaitAndContinueSpecification() {
            return waitAndContinueSpecification != null ? waitAndContinueSpecification.toBuilder() : null;
        }

        public final void setWaitAndContinueSpecification(WaitAndContinueSpecification.BuilderImpl waitAndContinueSpecification) {
            this.waitAndContinueSpecification = waitAndContinueSpecification != null ? waitAndContinueSpecification.build()
                    : null;
        }

        @Override
        public final Builder waitAndContinueSpecification(WaitAndContinueSpecification waitAndContinueSpecification) {
            this.waitAndContinueSpecification = waitAndContinueSpecification;
            return this;
        }

        @Override
        public SubSlotValueElicitationSetting build() {
            return new SubSlotValueElicitationSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
