/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a turn in a test set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestSetTurnRecord implements SdkPojo, Serializable,
        ToCopyableBuilder<TestSetTurnRecord.Builder, TestSetTurnRecord> {
    private static final SdkField<Long> RECORD_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("recordNumber").getter(getter(TestSetTurnRecord::recordNumber)).setter(setter(Builder::recordNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordNumber").build()).build();

    private static final SdkField<String> CONVERSATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversationId").getter(getter(TestSetTurnRecord::conversationId))
            .setter(setter(Builder::conversationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversationId").build()).build();

    private static final SdkField<Integer> TURN_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("turnNumber").getter(getter(TestSetTurnRecord::turnNumber)).setter(setter(Builder::turnNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("turnNumber").build()).build();

    private static final SdkField<TurnSpecification> TURN_SPECIFICATION_FIELD = SdkField
            .<TurnSpecification> builder(MarshallingType.SDK_POJO).memberName("turnSpecification")
            .getter(getter(TestSetTurnRecord::turnSpecification)).setter(setter(Builder::turnSpecification))
            .constructor(TurnSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("turnSpecification").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_NUMBER_FIELD,
            CONVERSATION_ID_FIELD, TURN_NUMBER_FIELD, TURN_SPECIFICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long recordNumber;

    private final String conversationId;

    private final Integer turnNumber;

    private final TurnSpecification turnSpecification;

    private TestSetTurnRecord(BuilderImpl builder) {
        this.recordNumber = builder.recordNumber;
        this.conversationId = builder.conversationId;
        this.turnNumber = builder.turnNumber;
        this.turnSpecification = builder.turnSpecification;
    }

    /**
     * <p>
     * The record number associated with the turn.
     * </p>
     * 
     * @return The record number associated with the turn.
     */
    public final Long recordNumber() {
        return recordNumber;
    }

    /**
     * <p>
     * The unique identifier for the conversation associated with the turn.
     * </p>
     * 
     * @return The unique identifier for the conversation associated with the turn.
     */
    public final String conversationId() {
        return conversationId;
    }

    /**
     * <p>
     * The number of turns that has elapsed up to that turn.
     * </p>
     * 
     * @return The number of turns that has elapsed up to that turn.
     */
    public final Integer turnNumber() {
        return turnNumber;
    }

    /**
     * <p>
     * Contains information about the agent or user turn depending upon type of turn.
     * </p>
     * 
     * @return Contains information about the agent or user turn depending upon type of turn.
     */
    public final TurnSpecification turnSpecification() {
        return turnSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(recordNumber());
        hashCode = 31 * hashCode + Objects.hashCode(conversationId());
        hashCode = 31 * hashCode + Objects.hashCode(turnNumber());
        hashCode = 31 * hashCode + Objects.hashCode(turnSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestSetTurnRecord)) {
            return false;
        }
        TestSetTurnRecord other = (TestSetTurnRecord) obj;
        return Objects.equals(recordNumber(), other.recordNumber()) && Objects.equals(conversationId(), other.conversationId())
                && Objects.equals(turnNumber(), other.turnNumber())
                && Objects.equals(turnSpecification(), other.turnSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestSetTurnRecord").add("RecordNumber", recordNumber()).add("ConversationId", conversationId())
                .add("TurnNumber", turnNumber()).add("TurnSpecification", turnSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "recordNumber":
            return Optional.ofNullable(clazz.cast(recordNumber()));
        case "conversationId":
            return Optional.ofNullable(clazz.cast(conversationId()));
        case "turnNumber":
            return Optional.ofNullable(clazz.cast(turnNumber()));
        case "turnSpecification":
            return Optional.ofNullable(clazz.cast(turnSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("recordNumber", RECORD_NUMBER_FIELD);
        map.put("conversationId", CONVERSATION_ID_FIELD);
        map.put("turnNumber", TURN_NUMBER_FIELD);
        map.put("turnSpecification", TURN_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestSetTurnRecord, T> g) {
        return obj -> g.apply((TestSetTurnRecord) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestSetTurnRecord> {
        /**
         * <p>
         * The record number associated with the turn.
         * </p>
         * 
         * @param recordNumber
         *        The record number associated with the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordNumber(Long recordNumber);

        /**
         * <p>
         * The unique identifier for the conversation associated with the turn.
         * </p>
         * 
         * @param conversationId
         *        The unique identifier for the conversation associated with the turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversationId(String conversationId);

        /**
         * <p>
         * The number of turns that has elapsed up to that turn.
         * </p>
         * 
         * @param turnNumber
         *        The number of turns that has elapsed up to that turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnNumber(Integer turnNumber);

        /**
         * <p>
         * Contains information about the agent or user turn depending upon type of turn.
         * </p>
         * 
         * @param turnSpecification
         *        Contains information about the agent or user turn depending upon type of turn.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder turnSpecification(TurnSpecification turnSpecification);

        /**
         * <p>
         * Contains information about the agent or user turn depending upon type of turn.
         * </p>
         * This is a convenience method that creates an instance of the {@link TurnSpecification.Builder} avoiding the
         * need to create one manually via {@link TurnSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TurnSpecification.Builder#build()} is called immediately and its
         * result is passed to {@link #turnSpecification(TurnSpecification)}.
         * 
         * @param turnSpecification
         *        a consumer that will call methods on {@link TurnSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #turnSpecification(TurnSpecification)
         */
        default Builder turnSpecification(Consumer<TurnSpecification.Builder> turnSpecification) {
            return turnSpecification(TurnSpecification.builder().applyMutation(turnSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long recordNumber;

        private String conversationId;

        private Integer turnNumber;

        private TurnSpecification turnSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(TestSetTurnRecord model) {
            recordNumber(model.recordNumber);
            conversationId(model.conversationId);
            turnNumber(model.turnNumber);
            turnSpecification(model.turnSpecification);
        }

        public final Long getRecordNumber() {
            return recordNumber;
        }

        public final void setRecordNumber(Long recordNumber) {
            this.recordNumber = recordNumber;
        }

        @Override
        public final Builder recordNumber(Long recordNumber) {
            this.recordNumber = recordNumber;
            return this;
        }

        public final String getConversationId() {
            return conversationId;
        }

        public final void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @Override
        public final Builder conversationId(String conversationId) {
            this.conversationId = conversationId;
            return this;
        }

        public final Integer getTurnNumber() {
            return turnNumber;
        }

        public final void setTurnNumber(Integer turnNumber) {
            this.turnNumber = turnNumber;
        }

        @Override
        public final Builder turnNumber(Integer turnNumber) {
            this.turnNumber = turnNumber;
            return this;
        }

        public final TurnSpecification.Builder getTurnSpecification() {
            return turnSpecification != null ? turnSpecification.toBuilder() : null;
        }

        public final void setTurnSpecification(TurnSpecification.BuilderImpl turnSpecification) {
            this.turnSpecification = turnSpecification != null ? turnSpecification.build() : null;
        }

        @Override
        public final Builder turnSpecification(TurnSpecification turnSpecification) {
            this.turnSpecification = turnSpecification;
            return this;
        }

        @Override
        public TestSetTurnRecord build() {
            return new TestSetTurnRecord(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
