/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a response to the utterance from the bot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtteranceBotResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<UtteranceBotResponse.Builder, UtteranceBotResponse> {
    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("content")
            .getter(getter(UtteranceBotResponse::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(UtteranceBotResponse::contentTypeAsString))
            .setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentType").build()).build();

    private static final SdkField<ImageResponseCard> IMAGE_RESPONSE_CARD_FIELD = SdkField
            .<ImageResponseCard> builder(MarshallingType.SDK_POJO).memberName("imageResponseCard")
            .getter(getter(UtteranceBotResponse::imageResponseCard)).setter(setter(Builder::imageResponseCard))
            .constructor(ImageResponseCard::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageResponseCard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD,
            CONTENT_TYPE_FIELD, IMAGE_RESPONSE_CARD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String content;

    private final String contentType;

    private final ImageResponseCard imageResponseCard;

    private UtteranceBotResponse(BuilderImpl builder) {
        this.content = builder.content;
        this.contentType = builder.contentType;
        this.imageResponseCard = builder.imageResponseCard;
    }

    /**
     * <p>
     * The text of the response to the utterance from the bot.
     * </p>
     * 
     * @return The text of the response to the utterance from the bot.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The type of the response. The following values are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlainText</code> – A plain text string.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CustomPayload</code> – A response string that you can customize to include data or metadata for your
     * application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html"
     * >ImageResponseCard</a> for more information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link UtteranceContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The type of the response. The following values are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlainText</code> – A plain text string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomPayload</code> – A response string that you can customize to include data or metadata for
     *         your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio
     *         response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html"
     *         >ImageResponseCard</a> for more information.
     *         </p>
     *         </li>
     * @see UtteranceContentType
     */
    public final UtteranceContentType contentType() {
        return UtteranceContentType.fromValue(contentType);
    }

    /**
     * <p>
     * The type of the response. The following values are possible:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PlainText</code> – A plain text string.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CustomPayload</code> – A response string that you can customize to include data or metadata for your
     * application.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio response.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a
     * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html"
     * >ImageResponseCard</a> for more information.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #contentType} will
     * return {@link UtteranceContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #contentTypeAsString}.
     * </p>
     * 
     * @return The type of the response. The following values are possible:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PlainText</code> – A plain text string.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CustomPayload</code> – A response string that you can customize to include data or metadata for
     *         your application.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio
     *         response.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a
     *         href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html"
     *         >ImageResponseCard</a> for more information.
     *         </p>
     *         </li>
     * @see UtteranceContentType
     */
    public final String contentTypeAsString() {
        return contentType;
    }

    /**
     * Returns the value of the ImageResponseCard property for this object.
     * 
     * @return The value of the ImageResponseCard property for this object.
     */
    public final ImageResponseCard imageResponseCard() {
        return imageResponseCard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(contentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageResponseCard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceBotResponse)) {
            return false;
        }
        UtteranceBotResponse other = (UtteranceBotResponse) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(contentTypeAsString(), other.contentTypeAsString())
                && Objects.equals(imageResponseCard(), other.imageResponseCard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtteranceBotResponse").add("Content", content()).add("ContentType", contentTypeAsString())
                .add("ImageResponseCard", imageResponseCard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentTypeAsString()));
        case "imageResponseCard":
            return Optional.ofNullable(clazz.cast(imageResponseCard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("contentType", CONTENT_TYPE_FIELD);
        map.put("imageResponseCard", IMAGE_RESPONSE_CARD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UtteranceBotResponse, T> g) {
        return obj -> g.apply((UtteranceBotResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtteranceBotResponse> {
        /**
         * <p>
         * The text of the response to the utterance from the bot.
         * </p>
         * 
         * @param content
         *        The text of the response to the utterance from the bot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The type of the response. The following values are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlainText</code> – A plain text string.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CustomPayload</code> – A response string that you can customize to include data or metadata for your
         * application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a
         * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html"
         * >ImageResponseCard</a> for more information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        The type of the response. The following values are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlainText</code> – A plain text string.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomPayload</code> – A response string that you can customize to include data or metadata for
         *        your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio
         *        response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html"
         *        >ImageResponseCard</a> for more information.
         *        </p>
         *        </li>
         * @see UtteranceContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UtteranceContentType
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * The type of the response. The following values are possible:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PlainText</code> – A plain text string.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CustomPayload</code> – A response string that you can customize to include data or metadata for your
         * application.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio response.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a
         * href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html"
         * >ImageResponseCard</a> for more information.
         * </p>
         * </li>
         * </ul>
         * 
         * @param contentType
         *        The type of the response. The following values are possible:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PlainText</code> – A plain text string.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CustomPayload</code> – A response string that you can customize to include data or metadata for
         *        your application.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SSML</code> – A string that includes Speech Synthesis Markup Language to customize the audio
         *        response.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ImageResponseCard</code> – An image with buttons that the customer can select. See <a
         *        href="https://docs.aws.amazon.com/lexv2/latest/APIReference/API_runtime_ImageResponseCard.html"
         *        >ImageResponseCard</a> for more information.
         *        </p>
         *        </li>
         * @see UtteranceContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UtteranceContentType
         */
        Builder contentType(UtteranceContentType contentType);

        /**
         * Sets the value of the ImageResponseCard property for this object.
         *
         * @param imageResponseCard
         *        The new value for the ImageResponseCard property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageResponseCard(ImageResponseCard imageResponseCard);

        /**
         * Sets the value of the ImageResponseCard property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageResponseCard.Builder} avoiding the
         * need to create one manually via {@link ImageResponseCard#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageResponseCard.Builder#build()} is called immediately and its
         * result is passed to {@link #imageResponseCard(ImageResponseCard)}.
         * 
         * @param imageResponseCard
         *        a consumer that will call methods on {@link ImageResponseCard.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageResponseCard(ImageResponseCard)
         */
        default Builder imageResponseCard(Consumer<ImageResponseCard.Builder> imageResponseCard) {
            return imageResponseCard(ImageResponseCard.builder().applyMutation(imageResponseCard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String content;

        private String contentType;

        private ImageResponseCard imageResponseCard;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceBotResponse model) {
            content(model.content);
            contentType(model.contentType);
            imageResponseCard(model.imageResponseCard);
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        @Override
        public final Builder contentType(UtteranceContentType contentType) {
            this.contentType(contentType == null ? null : contentType.toString());
            return this;
        }

        public final ImageResponseCard.Builder getImageResponseCard() {
            return imageResponseCard != null ? imageResponseCard.toBuilder() : null;
        }

        public final void setImageResponseCard(ImageResponseCard.BuilderImpl imageResponseCard) {
            this.imageResponseCard = imageResponseCard != null ? imageResponseCard.build() : null;
        }

        @Override
        public final Builder imageResponseCard(ImageResponseCard imageResponseCard) {
            this.imageResponseCard = imageResponseCard;
            return this;
        }

        @Override
        public UtteranceBotResponse build() {
            return new UtteranceBotResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
