/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object specifying the measure and method by which to sort the utterance data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtteranceDataSortBy implements SdkPojo, Serializable,
        ToCopyableBuilder<UtteranceDataSortBy.Builder, UtteranceDataSortBy> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UtteranceDataSortBy::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("order")
            .getter(getter(UtteranceDataSortBy::orderAsString)).setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String order;

    private UtteranceDataSortBy(BuilderImpl builder) {
        this.name = builder.name;
        this.order = builder.order;
    }

    /**
     * <p>
     * The measure by which to sort the utterance analytics data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Count</code> – The number of utterances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UtteranceTimestamp</code> – The date and time of the utterance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsUtteranceSortByName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nameAsString}.
     * </p>
     * 
     * @return The measure by which to sort the utterance analytics data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Count</code> – The number of utterances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UtteranceTimestamp</code> – The date and time of the utterance.
     *         </p>
     *         </li>
     * @see AnalyticsUtteranceSortByName
     */
    public final AnalyticsUtteranceSortByName name() {
        return AnalyticsUtteranceSortByName.fromValue(name);
    }

    /**
     * <p>
     * The measure by which to sort the utterance analytics data.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Count</code> – The number of utterances.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UtteranceTimestamp</code> – The date and time of the utterance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AnalyticsUtteranceSortByName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nameAsString}.
     * </p>
     * 
     * @return The measure by which to sort the utterance analytics data.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Count</code> – The number of utterances.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UtteranceTimestamp</code> – The date and time of the utterance.
     *         </p>
     *         </li>
     * @see AnalyticsUtteranceSortByName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * Specifies whether to sort the results in ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link AnalyticsSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return Specifies whether to sort the results in ascending or descending order.
     * @see AnalyticsSortOrder
     */
    public final AnalyticsSortOrder order() {
        return AnalyticsSortOrder.fromValue(order);
    }

    /**
     * <p>
     * Specifies whether to sort the results in ascending or descending order.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #order} will return
     * {@link AnalyticsSortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #orderAsString}.
     * </p>
     * 
     * @return Specifies whether to sort the results in ascending or descending order.
     * @see AnalyticsSortOrder
     */
    public final String orderAsString() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(orderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceDataSortBy)) {
            return false;
        }
        UtteranceDataSortBy other = (UtteranceDataSortBy) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(orderAsString(), other.orderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtteranceDataSortBy").add("Name", nameAsString()).add("Order", orderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "order":
            return Optional.ofNullable(clazz.cast(orderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("order", ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UtteranceDataSortBy, T> g) {
        return obj -> g.apply((UtteranceDataSortBy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtteranceDataSortBy> {
        /**
         * <p>
         * The measure by which to sort the utterance analytics data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Count</code> – The number of utterances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UtteranceTimestamp</code> – The date and time of the utterance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The measure by which to sort the utterance analytics data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Count</code> – The number of utterances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UtteranceTimestamp</code> – The date and time of the utterance.
         *        </p>
         *        </li>
         * @see AnalyticsUtteranceSortByName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsUtteranceSortByName
         */
        Builder name(String name);

        /**
         * <p>
         * The measure by which to sort the utterance analytics data.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Count</code> – The number of utterances.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UtteranceTimestamp</code> – The date and time of the utterance.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The measure by which to sort the utterance analytics data.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Count</code> – The number of utterances.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UtteranceTimestamp</code> – The date and time of the utterance.
         *        </p>
         *        </li>
         * @see AnalyticsUtteranceSortByName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsUtteranceSortByName
         */
        Builder name(AnalyticsUtteranceSortByName name);

        /**
         * <p>
         * Specifies whether to sort the results in ascending or descending order.
         * </p>
         * 
         * @param order
         *        Specifies whether to sort the results in ascending or descending order.
         * @see AnalyticsSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsSortOrder
         */
        Builder order(String order);

        /**
         * <p>
         * Specifies whether to sort the results in ascending or descending order.
         * </p>
         * 
         * @param order
         *        Specifies whether to sort the results in ascending or descending order.
         * @see AnalyticsSortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnalyticsSortOrder
         */
        Builder order(AnalyticsSortOrder order);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String order;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceDataSortBy model) {
            name(model.name);
            order(model.order);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AnalyticsUtteranceSortByName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getOrder() {
            return order;
        }

        public final void setOrder(String order) {
            this.order = order;
        }

        @Override
        public final Builder order(String order) {
            this.order = order;
            return this;
        }

        @Override
        public final Builder order(AnalyticsSortOrder order) {
            this.order(order == null ? null : order.toString());
            return this;
        }

        @Override
        public UtteranceDataSortBy build() {
            return new UtteranceDataSortBy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
