/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lexmodelsv2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about input of an utterance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UtteranceInputSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<UtteranceInputSpecification.Builder, UtteranceInputSpecification> {
    private static final SdkField<String> TEXT_INPUT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("textInput").getter(getter(UtteranceInputSpecification::textInput)).setter(setter(Builder::textInput))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textInput").build()).build();

    private static final SdkField<UtteranceAudioInputSpecification> AUDIO_INPUT_FIELD = SdkField
            .<UtteranceAudioInputSpecification> builder(MarshallingType.SDK_POJO).memberName("audioInput")
            .getter(getter(UtteranceInputSpecification::audioInput)).setter(setter(Builder::audioInput))
            .constructor(UtteranceAudioInputSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audioInput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_INPUT_FIELD,
            AUDIO_INPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String textInput;

    private final UtteranceAudioInputSpecification audioInput;

    private UtteranceInputSpecification(BuilderImpl builder) {
        this.textInput = builder.textInput;
        this.audioInput = builder.audioInput;
    }

    /**
     * <p>
     * A text input transcription of the utterance. It is only applicable for test-sets containing text data.
     * </p>
     * 
     * @return A text input transcription of the utterance. It is only applicable for test-sets containing text data.
     */
    public final String textInput() {
        return textInput;
    }

    /**
     * <p>
     * Contains information about the audio input for an utterance.
     * </p>
     * 
     * @return Contains information about the audio input for an utterance.
     */
    public final UtteranceAudioInputSpecification audioInput() {
        return audioInput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textInput());
        hashCode = 31 * hashCode + Objects.hashCode(audioInput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UtteranceInputSpecification)) {
            return false;
        }
        UtteranceInputSpecification other = (UtteranceInputSpecification) obj;
        return Objects.equals(textInput(), other.textInput()) && Objects.equals(audioInput(), other.audioInput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UtteranceInputSpecification").add("TextInput", textInput()).add("AudioInput", audioInput())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textInput":
            return Optional.ofNullable(clazz.cast(textInput()));
        case "audioInput":
            return Optional.ofNullable(clazz.cast(audioInput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textInput", TEXT_INPUT_FIELD);
        map.put("audioInput", AUDIO_INPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UtteranceInputSpecification, T> g) {
        return obj -> g.apply((UtteranceInputSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UtteranceInputSpecification> {
        /**
         * <p>
         * A text input transcription of the utterance. It is only applicable for test-sets containing text data.
         * </p>
         * 
         * @param textInput
         *        A text input transcription of the utterance. It is only applicable for test-sets containing text data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textInput(String textInput);

        /**
         * <p>
         * Contains information about the audio input for an utterance.
         * </p>
         * 
         * @param audioInput
         *        Contains information about the audio input for an utterance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audioInput(UtteranceAudioInputSpecification audioInput);

        /**
         * <p>
         * Contains information about the audio input for an utterance.
         * </p>
         * This is a convenience method that creates an instance of the {@link UtteranceAudioInputSpecification.Builder}
         * avoiding the need to create one manually via {@link UtteranceAudioInputSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UtteranceAudioInputSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #audioInput(UtteranceAudioInputSpecification)}.
         * 
         * @param audioInput
         *        a consumer that will call methods on {@link UtteranceAudioInputSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audioInput(UtteranceAudioInputSpecification)
         */
        default Builder audioInput(Consumer<UtteranceAudioInputSpecification.Builder> audioInput) {
            return audioInput(UtteranceAudioInputSpecification.builder().applyMutation(audioInput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String textInput;

        private UtteranceAudioInputSpecification audioInput;

        private BuilderImpl() {
        }

        private BuilderImpl(UtteranceInputSpecification model) {
            textInput(model.textInput);
            audioInput(model.audioInput);
        }

        public final String getTextInput() {
            return textInput;
        }

        public final void setTextInput(String textInput) {
            this.textInput = textInput;
        }

        @Override
        public final Builder textInput(String textInput) {
            this.textInput = textInput;
            return this;
        }

        public final UtteranceAudioInputSpecification.Builder getAudioInput() {
            return audioInput != null ? audioInput.toBuilder() : null;
        }

        public final void setAudioInput(UtteranceAudioInputSpecification.BuilderImpl audioInput) {
            this.audioInput = audioInput != null ? audioInput.build() : null;
        }

        @Override
        public final Builder audioInput(UtteranceAudioInputSpecification audioInput) {
            this.audioInput = audioInput;
            return this;
        }

        @Override
        public UtteranceInputSpecification build() {
            return new UtteranceInputSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
