/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.lexmodelsv2.model.LexModelsV2Response;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecord;
import software.amazon.awssdk.services.lexmodelsv2.model.TestSetTurnRecordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTestSetRecordsResponse
extends LexModelsV2Response
implements ToCopyableBuilder<Builder, ListTestSetRecordsResponse> {
    private static final SdkField<List<TestSetTurnRecord>> TEST_SET_RECORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("testSetRecords").getter(ListTestSetRecordsResponse.getter(ListTestSetRecordsResponse::testSetRecords)).setter(ListTestSetRecordsResponse.setter(Builder::testSetRecords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSetRecords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TestSetTurnRecord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTestSetRecordsResponse.getter(ListTestSetRecordsResponse::nextToken)).setter(ListTestSetRecordsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SET_RECORDS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTestSetRecordsResponse.memberNameToFieldInitializer();
    private final List<TestSetTurnRecord> testSetRecords;
    private final String nextToken;

    private ListTestSetRecordsResponse(BuilderImpl builder) {
        super(builder);
        this.testSetRecords = builder.testSetRecords;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTestSetRecords() {
        return this.testSetRecords != null && !(this.testSetRecords instanceof SdkAutoConstructList);
    }

    public final List<TestSetTurnRecord> testSetRecords() {
        return this.testSetRecords;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTestSetRecords() ? this.testSetRecords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTestSetRecordsResponse)) {
            return false;
        }
        ListTestSetRecordsResponse other = (ListTestSetRecordsResponse)((Object)obj);
        return this.hasTestSetRecords() == other.hasTestSetRecords() && Objects.equals(this.testSetRecords(), other.testSetRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTestSetRecordsResponse").add("TestSetRecords", this.hasTestSetRecords() ? this.testSetRecords() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSetRecords": {
                return Optional.ofNullable(clazz.cast(this.testSetRecords()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("testSetRecords", TEST_SET_RECORDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTestSetRecordsResponse, T> g) {
        return obj -> g.apply((ListTestSetRecordsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends LexModelsV2Response.BuilderImpl
    implements Builder {
        private List<TestSetTurnRecord> testSetRecords = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTestSetRecordsResponse model) {
            super(model);
            this.testSetRecords(model.testSetRecords);
            this.nextToken(model.nextToken);
        }

        public final List<TestSetTurnRecord.Builder> getTestSetRecords() {
            List<TestSetTurnRecord.Builder> result = TestSetTurnRecordListCopier.copyToBuilder(this.testSetRecords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTestSetRecords(Collection<TestSetTurnRecord.BuilderImpl> testSetRecords) {
            this.testSetRecords = TestSetTurnRecordListCopier.copyFromBuilder(testSetRecords);
        }

        @Override
        public final Builder testSetRecords(Collection<TestSetTurnRecord> testSetRecords) {
            this.testSetRecords = TestSetTurnRecordListCopier.copy(testSetRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSetRecords(TestSetTurnRecord ... testSetRecords) {
            this.testSetRecords(Arrays.asList(testSetRecords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder testSetRecords(Consumer<TestSetTurnRecord.Builder> ... testSetRecords) {
            this.testSetRecords(Stream.of(testSetRecords).map(c -> (TestSetTurnRecord)((TestSetTurnRecord.Builder)TestSetTurnRecord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTestSetRecordsResponse build() {
            return new ListTestSetRecordsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends LexModelsV2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTestSetRecordsResponse> {
        public Builder testSetRecords(Collection<TestSetTurnRecord> var1);

        public Builder testSetRecords(TestSetTurnRecord ... var1);

        public Builder testSetRecords(Consumer<TestSetTurnRecord.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

