/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.lexmodelsv2.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.lexmodelsv2.LexModelsV2AsyncClient;
import software.amazon.awssdk.services.lexmodelsv2.internal.UserAgentUtils;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionReplicasRequest;
import software.amazon.awssdk.services.lexmodelsv2.model.ListBotVersionReplicasResponse;

public class ListBotVersionReplicasPublisher
implements SdkPublisher<ListBotVersionReplicasResponse> {
    private final LexModelsV2AsyncClient client;
    private final ListBotVersionReplicasRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListBotVersionReplicasPublisher(LexModelsV2AsyncClient client, ListBotVersionReplicasRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListBotVersionReplicasPublisher(LexModelsV2AsyncClient client, ListBotVersionReplicasRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListBotVersionReplicasResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListBotVersionReplicasResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListBotVersionReplicasResponseFetcher
    implements AsyncPageFetcher<ListBotVersionReplicasResponse> {
        private ListBotVersionReplicasResponseFetcher() {
        }

        public boolean hasNextPage(ListBotVersionReplicasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListBotVersionReplicasResponse> nextPage(ListBotVersionReplicasResponse previousPage) {
            if (previousPage == null) {
                return ListBotVersionReplicasPublisher.this.client.listBotVersionReplicas(ListBotVersionReplicasPublisher.this.firstRequest);
            }
            return ListBotVersionReplicasPublisher.this.client.listBotVersionReplicas((ListBotVersionReplicasRequest)((Object)ListBotVersionReplicasPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

